/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.buddies;

import games.stendhal.client.gui.MousePopupAdapter;
import games.stendhal.client.gui.buddies.Buddy;
import games.stendhal.client.gui.buddies.BuddyLabel;
import games.stendhal.client.gui.buddies.BuddyLabelPopMenu;
import games.stendhal.client.gui.buddies.BuddyListModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class BuddyPanel
extends JList<Buddy> {
    private static final int POPUP_OFFSET = 10;

    protected BuddyPanel(BuddyListModel buddyListModel) {
        super(buddyListModel);
        this.setCellRenderer(new BuddyLabel());
        this.setOpaque(false);
        this.setFocusable(false);
        this.addMouseListener(new BuddyPanelMouseListener());
    }

    @Override
    public Font getFont() {
        ListCellRenderer listCellRenderer = this.getCellRenderer();
        if (listCellRenderer instanceof Component) {
            return ((Component)((Object)listCellRenderer)).getFont();
        }
        return super.getFont();
    }

    @Override
    public void setFont(Font font) {
        ListCellRenderer listCellRenderer = this.getCellRenderer();
        if (listCellRenderer instanceof Component) {
            Component component = (Component)((Object)listCellRenderer);
            component.setFont(font);
        }
    }

    private class BuddyPanelMouseListener
    extends MousePopupAdapter {
        private BuddyPanelMouseListener() {
        }

        @Override
        protected void showPopup(MouseEvent mouseEvent) {
            int n = BuddyPanel.this.locationToIndex(mouseEvent.getPoint());
            Buddy buddy = (Buddy)BuddyPanel.this.getModel().getElementAt(n);
            BuddyLabelPopMenu buddyLabelPopMenu = new BuddyLabelPopMenu(buddy.getName(), buddy.isOnline());
            buddyLabelPopMenu.show(mouseEvent.getComponent(), mouseEvent.getX() - 10, mouseEvent.getY() - 10);
        }
    }
}

