/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.chattext;

import games.stendhal.common.MathHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.log4j.Logger;

class ChatCache {
    private static final Logger logger = Logger.getLogger(ChatCache.class);
    private final String chatCacheFile;
    private int current;
    private final LinkedList<String> lines = new LinkedList();

    ChatCache(String string) {
        this.chatCacheFile = string;
    }

    public LinkedList<String> getLines() {
        return this.lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadChatCache() {
        if (this.chatCacheFile == null) {
            return;
        }
        try {
            File file = new File(this.chatCacheFile);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));){
                    String string = null;
                    while (null != (string = bufferedReader.readLine())) {
                        this.lines.add(string);
                    }
                }
                fileInputStream.close();
            }
            this.setCurrent(this.lines.size());
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
        }
    }

    void save() {
        if (this.chatCacheFile == null) {
            return;
        }
        try {
            new File(this.chatCacheFile).getParentFile().mkdirs();
            PrintStream printStream = new PrintStream(this.chatCacheFile, "UTF-8");
            while (this.lines.size() > 200) {
                this.lines.removeFirst();
            }
            ListIterator listIterator = this.lines.listIterator();
            while (listIterator.hasNext()) {
                printStream.println((String)listIterator.next());
            }
            printStream.close();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
        }
    }

    void setCurrent(int n) {
        this.current = n;
    }

    int getCurrent() {
        return this.current;
    }

    void addlinetoCache(String string) {
        this.getLines().add(string);
        this.setCurrent(this.getLines().size());
        if (this.getLines().size() > 50) {
            this.getLines().removeFirst();
            this.setCurrent(this.getCurrent() - 1);
        }
    }

    String current() {
        return this.getLines().get(this.current);
    }

    boolean hasNext() {
        return this.lines.size() > this.current;
    }

    boolean hasPrevious() {
        return this.current > 1;
    }

    String previous() {
        this.current = Math.max(this.current - 1, 0);
        if (!this.lines.isEmpty()) {
            return this.current();
        }
        return "";
    }

    String next() {
        this.current = MathHelper.clamp(this.current + 1, 0, this.lines.size() - 1);
        if (!this.lines.isEmpty()) {
            return this.current();
        }
        return "";
    }
}

