/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.Triple;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2d.entity.Blood2DView;
import games.stendhal.client.gui.j2d.entity.BossCreature2DView;
import games.stendhal.client.gui.j2d.entity.Box2DView;
import games.stendhal.client.gui.j2d.entity.CarrotGrower2DView;
import games.stendhal.client.gui.j2d.entity.Chest2DView;
import games.stendhal.client.gui.j2d.entity.Corpse2DView;
import games.stendhal.client.gui.j2d.entity.Creature2DView;
import games.stendhal.client.gui.j2d.entity.Door2DView;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.j2d.entity.GameBoard2DView;
import games.stendhal.client.gui.j2d.entity.Gate2DView;
import games.stendhal.client.gui.j2d.entity.GrainField2DView;
import games.stendhal.client.gui.j2d.entity.HousePortal2DView;
import games.stendhal.client.gui.j2d.entity.InvisibleEntity2DView;
import games.stendhal.client.gui.j2d.entity.Item2DView;
import games.stendhal.client.gui.j2d.entity.LookableEntity2DView;
import games.stendhal.client.gui.j2d.entity.NPC2DView;
import games.stendhal.client.gui.j2d.entity.Pet2DView;
import games.stendhal.client.gui.j2d.entity.PlantGrower2DView;
import games.stendhal.client.gui.j2d.entity.Player2DView;
import games.stendhal.client.gui.j2d.entity.Portal2DView;
import games.stendhal.client.gui.j2d.entity.Ring2DView;
import games.stendhal.client.gui.j2d.entity.Sheep2DView;
import games.stendhal.client.gui.j2d.entity.SheepFood2DView;
import games.stendhal.client.gui.j2d.entity.ShopSign2DView;
import games.stendhal.client.gui.j2d.entity.Sign2DView;
import games.stendhal.client.gui.j2d.entity.Spell2DView;
import games.stendhal.client.gui.j2d.entity.StackableItem2DView;
import games.stendhal.client.gui.j2d.entity.TradeCenterSign2DView;
import games.stendhal.client.gui.j2d.entity.UseableEntity2DView;
import games.stendhal.client.gui.j2d.entity.UseableItem2DView;
import games.stendhal.client.gui.j2d.entity.UseableRing2DView;
import games.stendhal.client.gui.j2d.entity.User2DView;
import games.stendhal.client.gui.j2d.entity.WalkBlocker2DView;
import games.stendhal.client.gui.j2d.entity.Wall2DView;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntityViewFactory {
    private static final Logger LOGGER = Logger.getLogger(EntityViewFactory.class);
    private static Map<Triple<String, String, String>, Class<? extends EntityView>> viewMap = new HashMap<Triple<String, String, String>, Class<? extends EntityView>>();

    public static EntityView<IEntity> create(IEntity iEntity) {
        try {
            boolean bl;
            String string;
            String string2;
            if (iEntity.isUser()) {
                User2DView<IEntity> user2DView = new User2DView<IEntity>();
                ((Entity2DView)user2DView).initialize(iEntity);
                return user2DView;
            }
            String string3 = iEntity.getType();
            Class<? extends EntityView> clazz = EntityViewFactory.getViewClass(string3, string2 = iEntity.getEntityClass(), string = iEntity.getEntitySubclass());
            if (clazz == null) {
                LOGGER.debug((Object)("No view for this entity. type: " + string3 + " class: " + string2 + " subclass: " + string));
                return null;
            }
            if (clazz == Blood2DView.class && !(bl = Boolean.parseBoolean(WtWindowManager.getInstance().getProperty("gamescreen.blood", "true")))) {
                return null;
            }
            EntityView entityView = clazz.newInstance();
            entityView.initialize(iEntity);
            return entityView;
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error creating entity for object: " + iEntity), (Throwable)exception);
            return null;
        }
    }

    static Class<? extends EntityView> getViewClass(String string, String string2, String string3) {
        Class<? extends EntityView> clazz = viewMap.get(new Triple<String, String, String>(string, string2, string3));
        if (clazz == null) {
            clazz = viewMap.get(new Triple<String, String, Object>(string, string2, null));
        }
        if (clazz == null) {
            clazz = viewMap.get(new Triple<String, Object, Object>(string, null, null));
        }
        return clazz;
    }

    private static void configure() {
        EntityViewFactory.register("area", null, null, InvisibleEntity2DView.class);
        EntityViewFactory.register("block", null, null, LookableEntity2DView.class);
        EntityViewFactory.register("blood", null, null, Blood2DView.class);
        EntityViewFactory.register("creature", "ent", null, BossCreature2DView.class);
        EntityViewFactory.register("growing_entity_spawner", "items/grower/wood_grower", null, CarrotGrower2DView.class);
        EntityViewFactory.register("growing_entity_spawner", "items/grower/carrot_grower", null, CarrotGrower2DView.class);
        EntityViewFactory.register("chest", null, null, Chest2DView.class);
        EntityViewFactory.register("corpse", null, null, Corpse2DView.class);
        EntityViewFactory.register("creature", null, null, Creature2DView.class);
        EntityViewFactory.register("door", null, null, Door2DView.class);
        EntityViewFactory.register("fire", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("fish_source", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("game_board", null, null, GameBoard2DView.class);
        EntityViewFactory.register("gate", null, null, Gate2DView.class);
        EntityViewFactory.register("gold_source", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("growing_entity_spawner", null, null, GrainField2DView.class);
        EntityViewFactory.register("house_portal", null, null, HousePortal2DView.class);
        EntityViewFactory.register("item", "box", null, Box2DView.class);
        EntityViewFactory.register("item", "special", "mithril clasp", Item2DView.class);
        EntityViewFactory.register("item", null, null, Item2DView.class);
        EntityViewFactory.register("npc", null, null, NPC2DView.class);
        EntityViewFactory.register("cat", null, null, Pet2DView.class);
        EntityViewFactory.register("pet", null, null, Pet2DView.class);
        EntityViewFactory.register("baby_dragon", null, null, Pet2DView.class);
        EntityViewFactory.register("purple_dragon", null, null, Pet2DView.class);
        EntityViewFactory.register("plant_grower", null, null, PlantGrower2DView.class);
        EntityViewFactory.register("player", null, null, Player2DView.class);
        EntityViewFactory.register("portal", null, null, Portal2DView.class);
        EntityViewFactory.register("sheep", null, null, Sheep2DView.class);
        EntityViewFactory.register("food", null, null, SheepFood2DView.class);
        EntityViewFactory.register("spell", null, null, Spell2DView.class);
        EntityViewFactory.register("sign", null, null, Sign2DView.class);
        EntityViewFactory.register("blackboard", null, null, Sign2DView.class);
        EntityViewFactory.register("rented_sign", null, null, Sign2DView.class);
        EntityViewFactory.register("shop_sign", null, null, ShopSign2DView.class);
        EntityViewFactory.register("tradecentersign", null, null, TradeCenterSign2DView.class);
        EntityViewFactory.register("item", "jewellery", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "flower", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "resource", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "herb", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "misc", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "money", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "missile", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "ammunition", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "container", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "special", null, StackableItem2DView.class);
        EntityViewFactory.register("item", "club", "wizard_staff", UseableItem2DView.class);
        EntityViewFactory.register("item", "misc", "seed", UseableItem2DView.class);
        EntityViewFactory.register("item", "misc", "bulb", UseableItem2DView.class);
        EntityViewFactory.register("item", "scroll", null, UseableItem2DView.class);
        EntityViewFactory.register("item", "food", null, UseableItem2DView.class);
        EntityViewFactory.register("item", "drink", null, UseableItem2DView.class);
        EntityViewFactory.register("item", "tool", "foodmill", UseableItem2DView.class);
        EntityViewFactory.register("item", "tool", "sugarmill", UseableItem2DView.class);
        EntityViewFactory.register("item", "tool", "scrolleraser", UseableItem2DView.class);
        EntityViewFactory.register("item", "ring", null, Ring2DView.class);
        EntityViewFactory.register("item", "ring", "wedding", UseableRing2DView.class);
        EntityViewFactory.register("useable_entity", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("wall", null, null, Wall2DView.class);
        EntityViewFactory.register("walkblocker", null, null, WalkBlocker2DView.class);
        EntityViewFactory.register("well_source", null, null, UseableEntity2DView.class);
    }

    private static void register(String string, String string2, String string3, Class<? extends EntityView> clazz) {
        viewMap.put(new Triple<String, String, String>(string, string2, string3), clazz);
    }

    static {
        EntityViewFactory.configure();
    }
}

