/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.GrainField;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2d.entity.StateEntity2DView;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class GrainField2DView<T extends GrainField>
extends StateEntity2DView<T> {
    private static final Logger LOGGER = Logger.getLogger(GrainField2DView.class);

    public GrainField2DView() {
        this.setSpriteAlignment(HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM);
    }

    @Override
    protected void buildSprites(T t, Map<Object, Sprite> map) {
        int n = this.getWidth();
        String string = ((Entity)t).getEntityClass();
        if (string == null) {
            LOGGER.warn((Object)"No entity class set");
            string = "grain_field";
        }
        SpriteStore spriteStore = SpriteStore.get();
        ZoneInfo zoneInfo = ZoneInfo.get();
        Sprite sprite = spriteStore.getModifiedSprite(this.translate(string.replace(" ", "_")), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        int n2 = ((GrainField)t).getMaximumRipeness() + 1;
        int n3 = sprite.getHeight();
        int n4 = n3 / n2;
        if (n3 % n2 != 0) {
            LOGGER.warn((Object)("Inconsistent image height in " + this.translate(string.replace(" ", "_")) + ": image height " + n3 + " with " + n2 + " states."));
        }
        int n5 = 0;
        for (int i = 0; i < n3; i += n4) {
            map.put(n5++, spriteStore.getTile(sprite, 0, i, n, n4));
        }
        this.calculateOffset(t, n, n4);
    }

    @Override
    protected Object getState(T t) {
        return ((GrainField)t).getRipeness();
    }

    @Override
    protected void buildActions(List<String> list) {
        if (!((GrainField)this.entity).getRPObject().has("menu")) {
            list.add(ActionType.HARVEST.getRepresentation());
        }
        super.buildActions(list);
    }

    @Override
    public int getHeight() {
        return (int)(((GrainField)this.entity).getHeight() * 32.0);
    }

    @Override
    public int getWidth() {
        return (int)(((GrainField)this.entity).getWidth() * 32.0);
    }

    @Override
    public Rectangle getArea() {
        return new Rectangle(this.getX() + this.getXOffset(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected Rectangle getDrawingArea() {
        return new Rectangle(this.getX() + this.getXOffset(), this.getY() + this.getYOffset(), this.getWidth(), this.getHeight() - this.getYOffset());
    }

    @Override
    public int getZIndex() {
        return 3000;
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        } else if (object == GrainField.PROP_RIPENESS) {
            this.proceedChangedState(this.entity);
        }
    }

    @Override
    public void onAction() {
        this.onAction(ActionType.HARVEST);
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case HARVEST: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.HARVEST;
    }
}

