/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.j2d.entity.helpers.DrawingHelper;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.sprite.TextSprite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

class Spell2DView
extends Entity2DView<IEntity> {
    private static final Logger logger = Logger.getLogger(Spell2DView.class);

    Spell2DView() {
    }

    @Override
    protected void buildRepresentation(IEntity iEntity) {
        String string = this.translate(this.getClassResourcePath());
        logger.debug((Object)("Sprite path: " + string));
        this.setSprite(SpriteStore.get().getSprite(string));
    }

    @Override
    public int getZIndex() {
        return 7000;
    }

    @Override
    protected String translate(String string) {
        String string2 = this.translateName(string);
        return "data/sprites/spells/" + string2 + ".png";
    }

    private String translateName(String string) {
        return string.replaceAll(" ", "_");
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        }
    }

    @Override
    public void onAction() {
        this.onAction(ActionType.USE);
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case USE: {
                j2DClient.get().switchToSpellState(this.entity.getRPObject());
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    protected void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        super.draw(graphics2D, n, n2, n3, n4);
        TextSprite textSprite = TextSprite.createTextSprite(this.getPositionInSlot(), Color.WHITE);
        DrawingHelper.drawAlignedSprite(graphics2D, textSprite, HorizontalAlignment.LEFT, VerticalAlignment.TOP, n, n2, n3, n4);
    }

    private String getPositionInSlot() {
        RPObject rPObject;
        RPSlot rPSlot = this.entity.getRPObject().getContainerSlot();
        Integer n = 1;
        Iterator iterator = rPSlot.iterator();
        while (iterator.hasNext() && !(rPObject = (RPObject)iterator.next()).equals((Object)this.entity.getRPObject())) {
            n = n + 1;
        }
        return n.toString();
    }

    @Override
    public boolean isMovable() {
        return true;
    }
}

