/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.settings;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.settings.SettingsComponentFactory;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.styled.StyledLookAndFeel;
import games.stendhal.client.gui.styled.styles.StyleFactory;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.MathHelper;
import games.stendhal.common.NotificationType;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

class VisualSettings {
    private static final String STYLE_PROPERTY = "ui.style";
    private static final String DEFAULT_STYLE = "Wood (default)";
    private static final String TRANSPARENCY_PROPERTY = "ui.transparency";
    private static final String GAMESCREEN_CREATURESPEECH = "gamescreen.creaturespeech";
    private static final String DEFAULT_FONT = "BlackChancery";
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final int FONT_MIN_SIZE = 8;
    private static final int FONT_MAX_SIZE = 20;
    private static final String FONT_PROPERTY = "ui.logfont";
    private static final String FONT_SIZE_PROPERTY = "ui.font_size";
    private static final String GAMESCREEN_BLOOD = "gamescreen.blood";
    private static final String SCALE_SCREEN_PROPERTY = "ui.scale_screen";
    private static final String MAP_COLOR_PROPERTY = "ui.colormaps";
    private final JComponent page;

    VisualSettings() {
        int n = 5;
        this.page = SBoxLayout.createContainer(false, n);
        this.page.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        this.page.add((Component)this.createStyleTypeSelector(), (Object)SLayout.EXPAND_X);
        this.page.add((Component)this.createTransparencySelector(), (Object)SLayout.EXPAND_X);
        this.toggleComponents(this.page);
        JCheckBox jCheckBox = SettingsComponentFactory.createSettingsToggle(MAP_COLOR_PROPERTY, "true", "Light effects", "Show night time lighting, and other coloring effects");
        this.page.add(jCheckBox);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "enabled" : "disabled";
                String string2 = "Lighting effects are now " + string + ". You may need to change map or relogin for it to take effect.";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        JCheckBox jCheckBox2 = SettingsComponentFactory.createSettingsToggle("ui.draw_weather", "true", "Draw weather", "Draw weather effects.");
        this.page.add(jCheckBox2);
        JCheckBox jCheckBox3 = SettingsComponentFactory.createSettingsToggle(GAMESCREEN_BLOOD, "true", "Show blood and corpses", "Show blood spots on hits during fighting, and corpses.");
        this.page.add(jCheckBox3);
        JCheckBox jCheckBox4 = SettingsComponentFactory.createSettingsToggle(GAMESCREEN_CREATURESPEECH, "true", "Show creature speech bubbles", "Show creature speech bubbles in the client display");
        this.page.add(jCheckBox4);
        JCheckBox jCheckBox5 = SettingsComponentFactory.createSettingsToggle(SCALE_SCREEN_PROPERTY, "true", "Scale view to fit window", "<html>If selected, the game view will scale to fit the available space,<br>otherwise the default sized graphics are used.</html>");
        this.page.add(jCheckBox5);
        this.page.add(Box.createHorizontalStrut(5));
        this.page.add(this.createFontSizeSelector());
        this.page.add((Component)this.createFontSelector(), (Object)SLayout.EXPAND_X);
    }

    JComponent getComponent() {
        return this.page;
    }

    private JComponent createStyleSelector() {
        String string2;
        final JComboBox<String> jComboBox = new JComboBox<String>();
        for (String string2 : StyleFactory.getAvailableStyles()) {
            jComboBox.addItem(string2);
        }
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        string2 = wtWindowManager.getProperty(STYLE_PROPERTY, DEFAULT_STYLE);
        jComboBox.setSelectedItem(string2);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                wtWindowManager.setProperty(VisualSettings.STYLE_PROPERTY, object.toString());
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", "The new style will be used the next time you start the game client.", NotificationType.CLIENT));
            }
        });
        return jComboBox;
    }

    private JComponent createTransparencySelector() {
        JComponent jComponent = SBoxLayout.createContainer(true, 5);
        JLabel jLabel = new JLabel("Transparency mode:");
        jComponent.add(jLabel);
        final JComboBox<Object> jComboBox = new JComboBox<Object>();
        String[][] stringArray = new String[][]{{"Automatic (default)", "auto", "The appropriate mode is decided automatically based on the system speed."}, {"Full translucency", "translucent", "Use semitransparent images where available. This is slow on some systems."}, {"Simple transparency", "bitmask", "Use simple transparency where parts of the image are either fully transparent or fully opaque.<p>Use this setting on old computers, if the game is unresponsive otherwise."}};
        final HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
        for (String[] object2 : stringArray) {
            jComboBox.addItem(object2[0]);
            hashMap.put(object2[0], object2);
            hashMap2.put(object2[1], object2);
        }
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        String string = wtWindowManager.getProperty(TRANSPARENCY_PROPERTY, "auto");
        String[] stringArray2 = (String[])hashMap2.get(string);
        if (stringArray2 == null) {
            stringArray2 = (String[])hashMap2.get("auto");
        }
        jComboBox.setSelectedItem(stringArray2[0]);
        jComboBox.setRenderer(new TooltippedRenderer(stringArray));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                String[] stringArray = (String[])hashMap.get(object);
                wtWindowManager.setProperty(VisualSettings.TRANSPARENCY_PROPERTY, stringArray[1]);
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", "The new transparency mode will be used the next time you start the game client.", NotificationType.CLIENT));
            }
        });
        jComponent.add(jComboBox);
        StringBuilder stringBuilder = new StringBuilder("<html>The transparency mode used for the graphics. The available options are:<dl>");
        for (String[] stringArray3 : stringArray) {
            stringBuilder.append("<dt><b>");
            stringBuilder.append(stringArray3[0]);
            stringBuilder.append("</b></dt>");
            stringBuilder.append("<dd>");
            stringBuilder.append(stringArray3[2]);
            stringBuilder.append("</dd>");
        }
        stringBuilder.append("</dl></html>");
        jComponent.setToolTipText(stringBuilder.toString());
        jComboBox.setToolTipText(stringBuilder.toString());
        return jComponent;
    }

    private void toggleComponents(Container container) {
    }

    private JComponent createStyleTypeSelector() {
        int n = 5;
        JComponent jComponent = SBoxLayout.createContainer(false, n);
        JComponent jComponent2 = SBoxLayout.createContainer(true, n);
        JLabel jLabel = new JLabel("Client style:");
        jLabel.setName("defined");
        jComponent2.add(jLabel);
        JComponent jComponent3 = this.createStyleSelector();
        jComponent3.setName("defined");
        jComponent2.add(jComponent3);
        jComponent2.setToolTipText("<html>The style used to draw the controls in the game client.<p>This affects the look only, and will not change the behavior of the game.</html>");
        jComponent.add(jComponent2);
        return jComponent;
    }

    private JComponent createFontSizeSelector() {
        JComponent jComponent = SBoxLayout.createContainer(true, 5);
        jComponent.add(new JLabel("Text size:"));
        final JComboBox<Object> jComboBox = new JComboBox<Object>();
        int n = WtWindowManager.getInstance().getPropertyInt(FONT_SIZE_PROPERTY, 12);
        jComboBox.addItem("default (12)");
        for (int i = 8; i <= 20; i += 2) {
            Integer n2 = i;
            jComboBox.addItem(n2);
            if (i != n || i == 12) continue;
            jComboBox.setSelectedItem(n2);
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                if ("default (12)".equals(object)) {
                    object = "12";
                }
                WtWindowManager.getInstance().setProperty(VisualSettings.FONT_SIZE_PROPERTY, object.toString());
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                if (lookAndFeel instanceof StyledLookAndFeel) {
                    int n = MathHelper.parseIntDefault(object.toString(), 12);
                    ((StyledLookAndFeel)lookAndFeel).setDefaultFontSize(n);
                }
            }
        });
        jComponent.add(jComboBox);
        jComponent.setToolTipText("Common text size");
        return jComponent;
    }

    private JComponent createFontSelector() {
        int n = 5;
        JComponent jComponent = SBoxLayout.createContainer(false, n);
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(n, n, n, n)));
        Style style = StyleUtil.getStyle();
        if (style != null) {
            jComponent.setBackground(style.getPlainColor());
        }
        JCheckBox jCheckBox = new JCheckBox("Custom Decorative Font");
        jCheckBox.setToolTipText("Set a custom font for the travel log and achievements");
        jComponent.add(jCheckBox);
        JComponent jComponent2 = SBoxLayout.createContainer(true, n);
        SBoxLayout.addSpring(jComponent2);
        jComponent.add((Component)jComponent2, (Object)SLayout.EXPAND_X);
        final JLabel jLabel = new JLabel("Font:");
        jComponent2.add(jLabel);
        final JComboBox<String> jComboBox = new JComboBox<String>();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String string : graphicsEnvironment.getAvailableFontFamilyNames()) {
            jComboBox.addItem(string);
        }
        String string = WtWindowManager.getInstance().getProperty(FONT_PROPERTY, DEFAULT_FONT);
        jComboBox.setSelectedItem(string);
        jComponent2.add(jComboBox);
        int n2 = this.fontChanged() ? 1 : 0;
        jCheckBox.setSelected(n2 != 0);
        jComboBox.setEnabled(n2 != 0);
        jLabel.setEnabled(n2 != 0);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (bl) {
                    String string = jComboBox.getSelectedItem().toString();
                    WtWindowManager.getInstance().setProperty(VisualSettings.FONT_PROPERTY, string);
                } else {
                    WtWindowManager.getInstance().setProperty(VisualSettings.FONT_PROPERTY, VisualSettings.DEFAULT_FONT);
                }
                jComboBox.setEnabled(bl);
                jLabel.setEnabled(bl);
            }
        });
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jComboBox.getSelectedItem().toString();
                WtWindowManager.getInstance().setProperty(VisualSettings.FONT_PROPERTY, string);
            }
        });
        return jComponent;
    }

    private boolean fontChanged() {
        String string = WtWindowManager.getInstance().getProperty(FONT_PROPERTY, DEFAULT_FONT);
        return !string.equals(DEFAULT_FONT);
    }

    private static class TooltippedRenderer
    extends DefaultListCellRenderer {
        private final String[][] data;

        TooltippedRenderer(String[][] stringArray) {
            this.data = stringArray;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            JComponent jComponent = (JComponent)super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (n > -1 && object != null) {
                jList.setToolTipText("<html>" + this.data[n][2] + "</html>");
            }
            return jComponent;
        }
    }
}

