/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.stats;

import games.stendhal.client.gui.LinearScalingModel;
import games.stendhal.client.gui.StatusDisplayBar;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ManaIndicator
extends StatusDisplayBar
implements PropertyChangeListener {
    private static final long serialVersionUID = 3462088641737184898L;
    private static ManaIndicator instance;
    private final LinearScalingModel model;

    static synchronized ManaIndicator create() {
        if (instance != null) {
            throw new IllegalStateException("Instance already created");
        }
        LinearScalingModel linearScalingModel = new LinearScalingModel();
        instance = new ManaIndicator(linearScalingModel);
        return instance;
    }

    private ManaIndicator(LinearScalingModel linearScalingModel) {
        super(linearScalingModel);
        this.model = linearScalingModel;
        this.setVisible(false);
        this.setBarColor(new Color(49, 75, 253));
    }

    public static ManaIndicator get() {
        if (instance == null) {
            throw new IllegalStateException("ManaIndicator not initialized");
        }
        return instance;
    }

    public void setMana(double d) {
        this.model.setValue(d);
    }

    public void setBaseMana(double d) {
        this.model.setMaxValue(d);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Map map;
        if (propertyChangeEvent == null) {
            return;
        }
        Map map2 = (Map)propertyChangeEvent.getOldValue();
        if (map2 != null && map2.containsKey("spells")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManaIndicator.this.setVisible(false);
                }
            });
        }
        if ((map = (Map)propertyChangeEvent.getNewValue()) != null && map.containsKey("spells")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ManaIndicator.this.setVisible(true);
                }
            });
        }
    }
}

