/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.stats;

import games.stendhal.client.entity.StatusID;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.stats.AnimatedIcon;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

class StatusIconPanel
extends JComponent {
    private static final String iconFolder = "data/sprites/status/panel/";
    private static final ImageIcon eatingIcon = new ImageIcon(DataLoader.getResource("data/sprites/ideas/eat.png"));
    private static final ImageIcon chokingIcon = new ImageIcon(DataLoader.getResource("data/sprites/ideas/choking.png"));
    private static final Sprite awaySprite;
    private static final Sprite grumpySprite;
    final JLabel eating;
    final JLabel choking;
    final AnimatedIcon away;
    final AnimatedIcon grumpy;
    private final Map<StatusID, JLabel> statusIDMap;

    protected StatusIconPanel() {
        this.setLayout(new SBoxLayout(true));
        this.setOpaque(false);
        this.eating = new JLabel(eatingIcon);
        this.add(this.eating);
        this.eating.setVisible(false);
        this.choking = new JLabel(chokingIcon);
        this.add(this.choking);
        this.choking.setVisible(false);
        this.away = new AnimatedIcon(awaySprite, 2000);
        this.add(this.away);
        this.away.setVisible(false);
        this.grumpy = new AnimatedIcon(grumpySprite, 2000);
        this.add(this.grumpy);
        this.grumpy.setVisible(false);
        this.statusIDMap = new EnumMap<StatusID, JLabel>(StatusID.class);
        this.statusIDMap.put(StatusID.CONFUSE, this.createStatusIndicator("confuse"));
        this.statusIDMap.put(StatusID.POISON, this.createStatusIndicator("poison"));
        this.statusIDMap.put(StatusID.SHOCK, this.createStatusIndicator("shock"));
        this.statusIDMap.put(StatusID.ZOMBIE, this.createStatusIndicator("zombie"));
        this.statusIDMap.put(StatusID.HEAVY, this.createStatusIndicator("heavy"));
    }

    private JLabel createStatusIndicator(String string) {
        ImageIcon imageIcon = new ImageIcon(DataLoader.getResource(iconFolder + string + ".png"));
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setVisible(false);
        this.add(jLabel);
        return jLabel;
    }

    protected void setEating(boolean bl) {
        if (this.eating.isVisible() != bl) {
            if (bl) {
                if (!this.choking.isVisible()) {
                    this.eating.setVisible(true);
                }
            } else {
                this.eating.setVisible(false);
            }
        }
    }

    protected void setChoking(boolean bl) {
        if (this.choking.isVisible() != bl) {
            this.choking.setVisible(bl);
        }
        if (bl) {
            this.eating.setVisible(false);
        }
    }

    void setStatus(StatusID statusID, boolean bl) {
        JLabel jLabel = this.statusIDMap.get((Object)statusID);
        if (jLabel.isVisible() != bl) {
            jLabel.setVisible(bl);
        }
    }

    void setAway(String string) {
        boolean bl;
        boolean bl2 = bl = string != null;
        if (bl) {
            this.away.setToolTipText("<html>You are away with the message:<br><b>" + string);
        }
        if (this.away.isVisible() != bl) {
            this.away.setVisible(bl);
        }
    }

    void setGrumpy(String string) {
        boolean bl;
        boolean bl2 = bl = string != null;
        if (bl) {
            this.grumpy.setToolTipText("<html>You are grumpy with the message:<br><b>" + string);
        }
        if (this.grumpy.isVisible() != bl) {
            this.grumpy.setVisible(bl);
        }
    }

    static {
        SpriteStore spriteStore = SpriteStore.get();
        awaySprite = spriteStore.getSprite("data/sprites/ideas/away.png");
        grumpySprite = spriteStore.getSprite("data/sprites/ideas/grumpy.png");
    }
}

