/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;

public class StyledTableUI
extends BasicTableUI {
    private final Style style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new StyledTableUI(StyleUtil.getStyle());
    }

    public StyledTableUI(Style style) {
        this.style = style;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setForeground(this.style.getForeground());
        jComponent.setBackground(this.style.getPlainColor());
        jComponent.setFont(this.style.getFont().deriveFont(1));
        this.table.setGridColor(this.style.getShadowColor());
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        StyleUtil.fillBackground(this.style, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        super.paint(graphics, jComponent);
    }
}

