/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled.styles;

import games.stendhal.client.gui.styled.PixmapBorder;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.wt.core.SettingChangeAdapter;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.common.MathHelper;
import java.awt.Color;
import java.awt.Font;
import javax.swing.border.Border;

class PixmapStyle
implements Style {
    private static final int DEFAULT_FONT_SIZE = 12;
    private final Color highLightColor;
    private final Color shadowColor;
    private final Color plainColor;
    private final Color foreground;
    private Sprite background;
    private Border border;
    private Border borderDown;
    private Font font;

    PixmapStyle(String string, boolean bl, Color color, Color color2, Color color3, Color color4) {
        SpriteStore spriteStore = SpriteStore.get();
        this.background = spriteStore.getSprite(string);
        if (bl) {
            this.border = new PixmapBorder(this.background, true);
            this.borderDown = new PixmapBorder(this.background, false);
        }
        this.highLightColor = color;
        this.shadowColor = color2;
        this.plainColor = color3;
        this.foreground = color4;
        WtWindowManager.getInstance().registerSettingChangeListener("ui.font_size", new SettingChangeAdapter("ui.font_size", Integer.toString(12)){

            @Override
            public void changed(String string) {
                int n = MathHelper.parseIntDefault(string, 12);
                PixmapStyle.this.font = new Font("Dialog", 0, n);
            }
        });
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public Sprite getBackground() {
        return this.background;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public Border getBorderDown() {
        return this.borderDown;
    }

    @Override
    public Color getHighLightColor() {
        return this.highLightColor;
    }

    @Override
    public Color getShadowColor() {
        return this.shadowColor;
    }

    @Override
    public Color getPlainColor() {
        return this.plainColor;
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    void setBorder(Border border) {
        this.border = border;
    }

    void setBorderDown(Border border) {
        this.borderDown = border;
    }
}

