/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.facade;

public class Time
implements Cloneable {
    private long mNanoSeconds;

    public Time() {
        this.mNanoSeconds = 0L;
    }

    public Time(long l) {
        this.mNanoSeconds = l;
    }

    public Time(long l, Unit unit) {
        this.set(l, unit);
    }

    public Time(long l, int n) {
        this.set(l, n);
    }

    public final void set(long l, Unit unit) {
        this.mNanoSeconds = l * unit.getNanos();
    }

    public final void set(long l, int n) {
        this.mNanoSeconds = l * Unit.SEC.getNanos() / (long)n;
    }

    public long getInNanoSeconds() {
        return this.mNanoSeconds;
    }

    public double getInMilliSeconds() {
        return (double)this.mNanoSeconds / (double)Unit.MILLI.getNanos();
    }

    public double getInSeconds() {
        return (double)this.mNanoSeconds / (double)Unit.SEC.getNanos();
    }

    public double getInMinutes() {
        return (double)this.mNanoSeconds / (double)Unit.MIN.getNanos();
    }

    public double getInHours() {
        return (double)this.mNanoSeconds / (double)Unit.HOUR.getNanos();
    }

    void add(Time time) {
        this.mNanoSeconds += time.mNanoSeconds;
    }

    void sub(Time time) {
        this.mNanoSeconds -= time.mNanoSeconds;
    }

    void add(long l) {
        this.mNanoSeconds += l;
    }

    void sub(long l) {
        this.mNanoSeconds -= l;
    }

    public double getInSamples(int n) {
        double d = (double)this.mNanoSeconds / (double)Unit.SEC.getNanos();
        return d * (double)n;
    }

    public Time clone() {
        return new Time(this.mNanoSeconds);
    }

    public static enum Unit {
        NANO(1L),
        MILLI(Unit.NANO.mBase * 1000000L),
        SEC(Unit.MILLI.mBase * 1000L),
        MIN(Unit.SEC.mBase * 60L),
        HOUR(Unit.MIN.mBase * 60L);

        private final long mBase;

        private Unit(long l) {
            this.mBase = l;
        }

        public long getNanos() {
            return this.mBase;
        }
    }
}

