/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system.processors;

import games.stendhal.client.sound.system.SignalProcessor;
import java.util.ArrayList;

public class ToneGenerator
extends SignalProcessor {
    private int mSampleRate;
    private int mNumChannels;
    private float[] mSamples;
    private final ArrayList<Tone> mTones = new ArrayList();

    public ToneGenerator(int n, int n2, int n3) {
        this.mNumChannels = n;
        this.mSampleRate = n2;
        this.mSamples = new float[n3 * this.mNumChannels];
    }

    public synchronized void addTone(Tone tone) {
        this.mTones.add(tone);
    }

    @Override
    protected boolean generate() {
        int n = 0;
        for (Tone tone : this.mTones) {
            this.makeTone(tone, this.mSamples, this.mSamples.length / this.mNumChannels, this.mNumChannels, n != 0);
            ++n;
        }
        super.propagate(this.mSamples, this.mSamples.length / this.mNumChannels, this.mNumChannels, this.mSampleRate);
        return true;
    }

    @Override
    protected synchronized void modify(float[] fArray, int n, int n2, int n3) {
        for (Tone tone : this.mTones) {
            this.makeTone(tone, fArray, n, n2, true);
        }
        super.propagate(fArray, n, n2, n3);
    }

    private void makeTone(Tone tone, float[] fArray, int n, int n2, boolean bl) {
        float f = tone.mFrequency / (float)this.mSampleRate;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                int n3 = i * n2;
                float f2 = (float)Math.sin(Math.PI * 2 * (double)f * (double)tone.mPosition);
                f2 *= tone.mVolume;
                for (int j = 0; j < n2; ++j) {
                    fArray[n3 + j] = fArray[n3 + j] + f2 - fArray[n3 + j] * f2;
                }
                ++tone.mPosition;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n4 = i * n2;
                float f3 = (float)Math.sin(Math.PI * 2 * (double)f * (double)tone.mPosition);
                f3 *= tone.mVolume;
                for (int j = 0; j < n2; ++j) {
                    fArray[n4 + j] = f3;
                }
                ++tone.mPosition;
            }
        }
    }

    public static class Tone {
        private float mVolume;
        private float mFrequency;
        private long mPosition = 0L;

        public Tone(float f, float f2) {
            this.mVolume = f;
            this.mFrequency = f2;
        }
    }
}

