/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system.processors;

import games.stendhal.client.sound.facade.Time;
import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.common.math.Algebra;
import games.stendhal.common.math.Numeric;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class VolumeAdjustor
extends SignalProcessor {
    private final AtomicInteger mCurrentVolume = new AtomicInteger();
    private final AtomicInteger mTargetVolume = new AtomicInteger();
    private final AtomicInteger mVolumeBeforeFading = new AtomicInteger();
    private final AtomicLong mFadingDuration = new AtomicLong();

    public VolumeAdjustor() {
        this.mCurrentVolume.set(VolumeAdjustor.floatToInt(1.0f));
        this.mTargetVolume.set(VolumeAdjustor.floatToInt(1.0f));
        this.mVolumeBeforeFading.set(VolumeAdjustor.floatToInt(1.0f));
        this.mFadingDuration.set(0L);
    }

    public VolumeAdjustor(float f) {
        this.mCurrentVolume.set(VolumeAdjustor.floatToInt(f));
        this.mTargetVolume.set(VolumeAdjustor.floatToInt(f));
        this.mVolumeBeforeFading.set(VolumeAdjustor.floatToInt(f));
        this.mFadingDuration.set(0L);
    }

    public void setVolume(float f) {
        this.mCurrentVolume.set(VolumeAdjustor.floatToInt(f));
        this.mVolumeBeforeFading.set(VolumeAdjustor.floatToInt(f));
        this.mFadingDuration.set(0L);
    }

    public float getVolume() {
        return VolumeAdjustor.intToFloat(this.mCurrentVolume.get());
    }

    public void startFading(float f, Time time) {
        this.mVolumeBeforeFading.set(this.mCurrentVolume.get());
        if (time.getInNanoSeconds() <= 0L) {
            this.mCurrentVolume.set(VolumeAdjustor.floatToInt(f));
            this.mFadingDuration.set(0L);
        } else {
            this.mTargetVolume.set(VolumeAdjustor.floatToInt(f));
            this.mFadingDuration.set(time.getInNanoSeconds());
        }
    }

    public void startFading(Time time) {
        if (time.getInNanoSeconds() <= 0L) {
            this.mCurrentVolume.set(this.mVolumeBeforeFading.get());
            this.mFadingDuration.set(0L);
        } else {
            this.mTargetVolume.set(this.mVolumeBeforeFading.get());
            this.mFadingDuration.set(time.getInNanoSeconds());
        }
    }

    @Override
    protected void modify(float[] fArray, int n, int n2, int n3) {
        assert (fArray.length >= n * n2);
        if (this.mFadingDuration.get() <= 0L) {
            float f = VolumeAdjustor.intToFloat(this.mCurrentVolume.get());
            if (Algebra.isEqual_Scalf(f, 0.0f)) {
                return;
            }
            if (!Algebra.isEqual_Scalf(f, 1.0f)) {
                int n4 = 0;
                while (n4 < n * n2) {
                    int n5 = n4++;
                    fArray[n5] = fArray[n5] * f;
                }
            }
        } else {
            int n6;
            Time time = new Time(this.mFadingDuration.get(), Time.Unit.NANO);
            Time time2 = new Time((long)n, n3);
            int n7 = n;
            float f = VolumeAdjustor.intToFloat(this.mCurrentVolume.get());
            float f2 = VolumeAdjustor.intToFloat(this.mTargetVolume.get()) - VolumeAdjustor.intToFloat(this.mCurrentVolume.get());
            if (time2.getInNanoSeconds() > time.getInNanoSeconds()) {
                n7 = (int)time.getInSamples(n3);
            } else {
                f2 *= (float)((double)time2.getInNanoSeconds() / (double)time.getInNanoSeconds());
            }
            for (n6 = 0; n6 < n7; ++n6) {
                int n8 = n6 * n2;
                double d = f + f2 * (float)n6 / (float)n7;
                for (int i = 0; i < n2; ++i) {
                    int n9 = n8 + i;
                    fArray[n9] = (float)((double)fArray[n9] * d);
                }
            }
            n6 = n7 * n2;
            while (n6 < n * n2) {
                int n10 = n6++;
                fArray[n10] = fArray[n10] * (f + f2);
            }
            this.mCurrentVolume.addAndGet(VolumeAdjustor.floatToInt(f2));
            this.mFadingDuration.addAndGet(-time2.getInNanoSeconds());
        }
        super.propagate(fArray, n, n2, n3);
    }

    private static int floatToInt(float f) {
        return Numeric.floatToInt(f, 1.0E7f);
    }

    private static float intToFloat(int n) {
        return Numeric.intToFloat(n, 1.0E7f);
    }
}

