/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.sprite.AnimatedSprite;
import games.stendhal.client.sprite.EmptySprite;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteCache;
import games.stendhal.client.sprite.TileSprite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class CompositeSprite
implements Sprite {
    private static final Logger logger = Logger.getLogger(CompositeSprite.class);
    private boolean composited;
    private List<Sprite> slaves;
    private Composite blend;
    private Sprite adjSprite;
    private final CompositeRef reference;

    public static Sprite getComposite(SpriteCache spriteCache, List<Sprite> list, Composite composite, Sprite sprite) {
        ListIterator<Sprite> listIterator = list.listIterator();
        Sprite sprite2 = null;
        Sprite sprite3 = null;
        if (composite == null || sprite == null || sprite instanceof EmptySprite) {
            composite = null;
        }
        while (listIterator.hasNext()) {
            Sprite sprite4 = listIterator.next();
            if (sprite4 instanceof EmptySprite) {
                listIterator.remove();
                if (sprite2 != null) continue;
                sprite2 = sprite4;
                continue;
            }
            if (sprite4 == sprite3) {
                listIterator.remove();
                continue;
            }
            sprite3 = sprite4;
        }
        int n = list.size();
        switch (n) {
            case 0: {
                return sprite2;
            }
            case 1: {
                Sprite sprite5 = list.get(0);
                if (composite != null) break;
                return sprite5;
            }
        }
        CompositeRef compositeRef = new CompositeRef(list, composite, sprite);
        Sprite sprite6 = spriteCache.get(compositeRef);
        if (sprite6 == null) {
            sprite6 = new CompositeSprite(list, composite, sprite, compositeRef);
            spriteCache.add(sprite6);
        }
        return sprite6;
    }

    private CompositeSprite(List<Sprite> list, Composite composite, Sprite sprite, CompositeRef compositeRef) {
        this.slaves = new ArrayList<Sprite>(list);
        this.reference = compositeRef;
        if (composite != null) {
            this.adjSprite = sprite;
            this.blend = composite;
        }
    }

    @Override
    public Sprite createRegion(int n, int n2, int n3, int n4, Object object) {
        return new TileSprite(this, n, n2, n3, n4, object);
    }

    @Override
    public void draw(Graphics graphics, int n, int n2) {
        if (!this.composited) {
            this.composite();
        }
        for (int i = 0; i < this.slaves.size(); ++i) {
            this.slaves.get(i).draw(graphics, n, n2);
        }
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.composited) {
            this.composite();
        }
        for (int i = 0; i < this.slaves.size(); ++i) {
            this.slaves.get(i).draw(graphics, n, n2, n3, n4, n5, n6);
        }
    }

    @Override
    public int getHeight() {
        return this.slaves.get(0).getHeight();
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    @Override
    public int getWidth() {
        return this.slaves.get(0).getWidth();
    }

    private void composite() {
        ArrayList<Sprite> arrayList = new ArrayList<Sprite>(this.slaves.size());
        ImageSprite imageSprite = null;
        ListIterator<Sprite> listIterator = this.slaves.listIterator();
        boolean bl = false;
        while (listIterator.hasNext()) {
            Sprite sprite = listIterator.next();
            if (sprite instanceof ImageSprite) {
                if (imageSprite != null) {
                    if (!bl) {
                        imageSprite = new ImageSprite(imageSprite);
                        bl = true;
                    }
                    Graphics graphics = imageSprite.getGraphics();
                    sprite.draw(graphics, 0, 0);
                    graphics.dispose();
                    continue;
                }
                imageSprite = (ImageSprite)sprite;
                if (this.blend == null) continue;
                imageSprite = new ImageSprite(imageSprite);
                bl = true;
                continue;
            }
            if (imageSprite != null) {
                arrayList.add(imageSprite);
                imageSprite = null;
            }
            arrayList.add(sprite);
        }
        if (imageSprite != null) {
            arrayList.add(imageSprite);
        }
        arrayList.trimToSize();
        this.slaves = arrayList;
        if (this.blend != null) {
            this.applyBlend(arrayList);
            this.blend = null;
            this.adjSprite = null;
        }
        this.composited = true;
    }

    private void applyBlend(List<Sprite> list) {
        ListIterator<Sprite> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            Sprite sprite = listIterator.next();
            if (sprite instanceof ImageSprite) {
                object = ((ImageSprite)sprite).getGraphics();
                if (!(object instanceof Graphics2D)) continue;
                ((Graphics2D)object).setComposite(this.blend);
                this.adjSprite.draw((Graphics)object, 0, 0);
                ((Graphics)object).dispose();
                listIterator.set(new ImageSprite(sprite));
                continue;
            }
            if (sprite instanceof AnimatedSprite) {
                object = (AnimatedSprite)sprite;
                Sprite[] spriteArray = ((AnimatedSprite)object).frames;
                Sprite[] spriteArray2 = new Sprite[spriteArray.length];
                ArrayList<Sprite> arrayList = new ArrayList<Sprite>(1);
                for (int i = 0; i < spriteArray.length; ++i) {
                    arrayList.add(spriteArray[i]);
                    spriteArray2[i] = new CompositeSprite(arrayList, this.blend, this.adjSprite, null);
                    arrayList.clear();
                }
                listIterator.set(new AnimatedSprite(spriteArray2, ((AnimatedSprite)object).delays, true, null));
                continue;
            }
            logger.error((Object)("Unhandled sprite with a blend: " + sprite));
        }
    }

    private static class CompositeRef {
        private final Object[] refs;
        private final int hash;

        CompositeRef(List<Sprite> list, Composite composite, Sprite sprite) {
            int n = 0;
            if (composite == null) {
                this.refs = new Object[list.size()];
            } else {
                this.refs = new Object[list.size() + 1];
                Object object = sprite.getReference();
                this.refs[list.size()] = object + "@" + composite.toString();
                n = object == null ? 42 : object.hashCode();
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                this.refs[i] = object = list.get(i).getReference();
                if (object == null) continue;
                n ^= object.hashCode();
            }
            this.hash = n;
        }

        public boolean equals(Object object) {
            if (object instanceof CompositeRef) {
                return Arrays.equals(this.refs, ((CompositeRef)object).refs);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

