/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.sprite.AnimatedSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.Tileset;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TilesetAnimationMap {
    static final int DEFAULT_DELAY = 500;
    private static final Logger LOGGER = Logger.getLogger(TilesetAnimationMap.class);
    private Map<Integer, Mapping> animations = new HashMap<Integer, Mapping>();

    void add(int n, int[] nArray, int[] nArray2) {
        this.animations.put(n, new Mapping(nArray, nArray2));
    }

    void add(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Mismatched number of frame indexes and delays");
        }
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray3 = new int[nArray.length];
            int[] nArray4 = new int[nArray.length];
            int n = i;
            for (int j = 0; j < nArray.length; ++j) {
                nArray3[j] = nArray[n];
                nArray4[j] = nArray2[n];
                if (++n < nArray.length) continue;
                n = 0;
            }
            this.add(nArray[i], nArray3, nArray4);
        }
    }

    public Sprite getSprite(Tileset tileset, int n) {
        Mapping mapping = this.animations.get(n);
        if (mapping == null) {
            return null;
        }
        int[] nArray = mapping.getIndices();
        int[] nArray2 = mapping.getDelays();
        Sprite[] spriteArray = new Sprite[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            spriteArray[i] = tileset.getSprite(nArray[i]);
            if (spriteArray[i] != null) continue;
            LOGGER.error((Object)("Invalid animation mapping. Tileset does not have tile index " + nArray[i] + "."));
            return null;
        }
        Object object = null;
        Sprite sprite = spriteArray[0];
        if (sprite != null) {
            object = sprite.getReference();
        }
        return new AnimatedSprite(spriteArray, nArray2, true, object);
    }

    private static class Mapping {
        private int[] indices;
        private int[] delays;

        private Mapping(int[] nArray, int[] nArray2) {
            this.indices = nArray;
            this.delays = nArray2;
        }

        private int[] getDelays() {
            return this.delays;
        }

        private int[] getIndices() {
            return this.indices;
        }
    }
}

