/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common;

import games.stendhal.common.Version;
import java.awt.Color;

public enum NotificationType {
    CLIENT("client"){

        @Override
        public Color getColor() {
            return COLOR_CLIENT;
        }
    }
    ,
    ERROR("error"){

        @Override
        public Color getColor() {
            return COLOR_ERROR;
        }
    }
    ,
    HEAL("heal"){

        @Override
        public Color getColor() {
            return COLOR_POSITIVE;
        }

        @Override
        public String getStyleDescription() {
            return NotificationType.REGULAR;
        }
    }
    ,
    INFORMATION("information"){

        @Override
        public Color getColor() {
            return COLOR_INFORMATION;
        }
    }
    ,
    NEGATIVE("negative"){

        @Override
        public Color getColor() {
            return COLOR_NEGATIVE;
        }

        @Override
        public String getStyleDescription() {
            return NotificationType.REGULAR;
        }
    }
    ,
    NORMAL("normal"){

        @Override
        public Color getColor() {
            return COLOR_NORMAL;
        }
    }
    ,
    POISON("poison"){

        @Override
        public Color getColor() {
            return COLOR_NEGATIVE;
        }

        @Override
        public String getStyleDescription() {
            return NotificationType.REGULAR;
        }
    }
    ,
    POSITIVE("positive"){

        @Override
        public Color getColor() {
            return COLOR_POSITIVE;
        }

        @Override
        public String getStyleDescription() {
            return NotificationType.REGULAR;
        }
    }
    ,
    EMOTE("emote"){

        @Override
        public Color getColor() {
            return COLOR_EMOTE;
        }
    }
    ,
    GROUP("group"){

        @Override
        public Color getColor() {
            return COLOR_GROUP;
        }
    }
    ,
    PRIVMSG("privmsg"){

        @Override
        public Color getColor() {
            return COLOR_PRIVMSG;
        }
    }
    ,
    RESPONSE("response"){

        @Override
        public Color getColor() {
            return COLOR_RESPONSE;
        }
    }
    ,
    SCENE_SETTING("scene_setting"){

        @Override
        public Color getColor() {
            return COLOR_SCENE_SETTING;
        }
    }
    ,
    SERVER("server"){

        @Override
        public Color getColor() {
            return COLOR_PRIVMSG;
        }
    }
    ,
    SIGNIFICANT_NEGATIVE("significant_negative"){

        @Override
        public Color getColor() {
            return COLOR_SIGNIFICANT_NEGATIVE;
        }
    }
    ,
    SIGNIFICANT_POSITIVE("significant_positive"){

        @Override
        public Color getColor() {
            return COLOR_SIGNIFICANT_POSITIVE;
        }
    }
    ,
    TUTORIAL("tutorial"){

        @Override
        public Color getColor() {
            return COLOR_TUTORIAL;
        }
    }
    ,
    SUPPORT("support"){

        @Override
        public Color getColor() {
            return COLOR_SUPPORT;
        }
    }
    ,
    DETAILED("detailed"){

        @Override
        public String getStyleDescription() {
            return NotificationType.REGULAR;
        }
    }
    ,
    WARNING("warning"){

        @Override
        public Color getColor() {
            return COLOR_WARNING;
        }
    };

    public static final Color COLOR_CLIENT;
    public static final Color COLOR_ERROR;
    public static final Color COLOR_INFORMATION;
    public static final Color COLOR_NEGATIVE;
    public static final Color COLOR_NORMAL;
    public static final Color COLOR_POSITIVE;
    public static final Color COLOR_GROUP;
    public static final Color COLOR_EMOTE;
    public static final Color COLOR_PRIVMSG;
    public static final Color COLOR_RESPONSE;
    public static final Color COLOR_SCENE_SETTING;
    public static final Color COLOR_SIGNIFICANT_NEGATIVE;
    public static final Color COLOR_SIGNIFICANT_POSITIVE;
    public static final Color COLOR_TUTORIAL;
    public static final Color COLOR_SUPPORT;
    public static final Color COLOR_WARNING;
    public static final String NORMALSTYLE = "normal";
    public static final String REGULAR = "regular";
    protected String mnemonic;

    private NotificationType(String string2) {
        this.mnemonic = string2;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public Color getColor() {
        return COLOR_NORMAL;
    }

    public String getStyleDescription() {
        return NORMALSTYLE;
    }

    public static NotificationType getServerNotificationType(String string) {
        if (string != null && Version.compare(string, "1.00") > 0) {
            return SERVER;
        }
        return PRIVMSG;
    }

    static {
        COLOR_CLIENT = Color.gray;
        COLOR_ERROR = Color.red;
        COLOR_INFORMATION = Color.orange;
        COLOR_NEGATIVE = Color.red;
        COLOR_NORMAL = Color.black;
        COLOR_POSITIVE = Color.green;
        COLOR_GROUP = new Color(0, 0, 160);
        COLOR_EMOTE = new Color(99, 61, 139);
        COLOR_PRIVMSG = Color.darkGray;
        COLOR_RESPONSE = new Color(25600);
        COLOR_SCENE_SETTING = new Color(5709826);
        COLOR_SIGNIFICANT_NEGATIVE = Color.pink;
        COLOR_SIGNIFICANT_POSITIVE = new Color(65, 105, 225);
        COLOR_TUTORIAL = new Color(172, 0, 172);
        COLOR_SUPPORT = new Color(16740864);
        COLOR_WARNING = new Color(0xA00000);
    }
}

