/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.filter;

import games.stendhal.common.filter.FilterCriteria;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CollectionFilter<T> {
    private static Logger logger = Logger.getLogger(CollectionFilter.class);
    private final ArrayList<FilterCriteria<T>> allFilterCriteria = new ArrayList();

    public void addFilterCriteria(FilterCriteria<T> filterCriteria) {
        this.allFilterCriteria.add(filterCriteria);
    }

    public void filter(Collection<T> collection) {
        if (collection != null) {
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                if (this.passesAllCriteria(t)) continue;
                iterator.remove();
            }
        }
    }

    public Collection<? extends T> filterCopy(Collection<? extends T> collection) {
        Collection collection2 = null;
        if (collection != null) {
            collection2 = (Collection)this.createObjectSameClass(collection);
            for (T t : collection) {
                if (!this.passesAllCriteria(t)) continue;
                collection2.add(t);
            }
        }
        return collection2;
    }

    private boolean passesAllCriteria(T t) {
        for (int i = 0; i < this.allFilterCriteria.size(); ++i) {
            FilterCriteria<T> filterCriteria = this.allFilterCriteria.get(i);
            if (filterCriteria.passes(t)) continue;
            return false;
        }
        return true;
    }

    private Object createObjectSameClass(Object object) {
        Class[] classArray = new Class[]{};
        Object var3_3 = null;
        try {
            if (object != null) {
                Constructor<?> constructor = object.getClass().getConstructor(classArray);
                var3_3 = constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error((Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error((Object)noSuchMethodException, (Throwable)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            logger.error((Object)instantiationException, (Throwable)instantiationException);
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
        return var3_3;
    }
}

