/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.parser.Expression;
import games.stendhal.common.parser.ExpressionType;
import games.stendhal.common.parser.Sentence;
import java.util.AbstractList;
import java.util.ArrayList;

public class CompoundName
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    private ExpressionType type;

    public CompoundName(Sentence sentence, String string) {
        assert (sentence.expressions.size() >= 2);
        boolean bl = false;
        for (Expression expression : sentence.expressions) {
            this.add(expression.getOriginal().toLowerCase());
            if (!expression.isDynamic()) continue;
            bl = true;
        }
        if (bl) {
            string = string + "-DYN";
        }
        this.type = new ExpressionType(string);
    }

    public boolean matches(AbstractList<Expression> abstractList, int n) {
        for (int i = 0; i < this.size(); ++i) {
            if (n >= abstractList.size()) {
                return false;
            }
            Expression expression = abstractList.get(n);
            String string = (String)this.get(i);
            if (!expression.getOriginal().equalsIgnoreCase(string)) {
                return false;
            }
            if (i < this.size() - 1 && expression.getBreakFlag()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public ExpressionType getType() {
        return this.type;
    }
}

