/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.ErrorBuffer;
import games.stendhal.common.parser.ConvCtxForMatcher;
import games.stendhal.common.parser.ConvCtxForMatchingSource;
import games.stendhal.common.parser.ConversationContext;
import games.stendhal.common.parser.Expression;
import games.stendhal.common.parser.ExpressionMatcher;
import games.stendhal.common.parser.PunctuationParser;
import games.stendhal.common.parser.Sentence;
import games.stendhal.common.parser.SentenceImplementation;
import games.stendhal.common.parser.TypeExprMatcher;
import games.stendhal.common.parser.WordEntry;
import games.stendhal.common.parser.WordList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public final class ConversationParser
extends ErrorBuffer {
    private static final Logger LOGGER = Logger.getLogger(ConversationParser.class);
    private static Map<String, Expression> triggerExpressionsCache = new HashMap<String, Expression>();
    private static Map<String, Sentence> matchingSentenceCache = new HashMap<String, Sentence>();
    private final transient StringTokenizer tokenizer;

    protected ConversationParser(SentenceImplementation sentenceImplementation) {
        String string = sentenceImplementation.getOriginalText();
        if (string == null) {
            string = "";
        } else if (string.startsWith("_")) {
            string = "";
        }
        String string2 = ConversationParser.detectSentenceType(string, sentenceImplementation);
        this.tokenizer = new StringTokenizer(string2);
    }

    public static String normalize(String string) {
        return ConversationParser.parse(string).getNormalized();
    }

    public static Expression createTriggerExpression(String string) {
        Expression expression = triggerExpressionsCache.get(string);
        if (expression == null) {
            expression = ConversationParser.createTriggerExpression(string, null);
            triggerExpressionsCache.put(string, expression);
        }
        return expression;
    }

    public static Expression createTriggerExpression(String string, ExpressionMatcher expressionMatcher) {
        Expression expression;
        ConvCtxForMatcher convCtxForMatcher = new ConvCtxForMatcher();
        convCtxForMatcher.setIgnoreIgnorable(false);
        if (expressionMatcher == null) {
            WordEntry wordEntry;
            expression = ConversationParser.parse(string, convCtxForMatcher).getTriggerExpression();
            if (expression.getMatcher() == null && !expression.getNormalized().equals(expression.getOriginal()) && (wordEntry = WordList.getInstance().find(expression.getNormalized())) != null && !expression.getTypeString().equals(wordEntry.getTypeString())) {
                expression.setMatcher(new TypeExprMatcher());
            }
        } else {
            expression = expressionMatcher.parseSentence(string, convCtxForMatcher).getTriggerExpression();
        }
        return expression;
    }

    public static Sentence parse(String string) {
        return ConversationParser.parse(string, new ConversationContext());
    }

    public static Sentence parseAsMatchingSource(String string) {
        Sentence sentence = ConversationParser.parse(string, new ConvCtxForMatchingSource());
        return sentence;
    }

    public static Sentence parseAsMatcher(String string) {
        Sentence sentence = matchingSentenceCache.get(string);
        if (sentence == null) {
            sentence = ConversationParser.parse(string, new ConvCtxForMatcher());
            matchingSentenceCache.put(string, sentence);
        }
        return sentence;
    }

    public static Sentence parse(String string, ExpressionMatcher expressionMatcher) {
        Sentence sentence = expressionMatcher == null ? ConversationParser.parse(string, new ConversationContext()) : expressionMatcher.parseSentence(string, new ConvCtxForMatcher());
        return sentence;
    }

    public static Sentence parse(String string, ConversationContext conversationContext, ExpressionMatcher expressionMatcher) {
        Sentence sentence = expressionMatcher == null ? ConversationParser.parse(string, conversationContext) : expressionMatcher.parseSentence(string, conversationContext);
        return sentence;
    }

    public static Sentence parse(String string, ConversationContext conversationContext) {
        Object object;
        String string2;
        if (string == null) {
            string2 = "";
        } else if (conversationContext != null && conversationContext.isForMatching()) {
            object = new ExpressionMatcher();
            string2 = ((ExpressionMatcher)object).readMatchingFlags(string);
            if (((ExpressionMatcher)object).isAnyFlagSet()) {
                return ((ExpressionMatcher)object).parseSentence(string2, conversationContext);
            }
        } else {
            string2 = string;
        }
        string2 = string2.trim();
        object = new SentenceImplementation(conversationContext, string2);
        try {
            ConversationParser conversationParser = new ConversationParser((SentenceImplementation)object);
            ((SentenceImplementation)object).parse(conversationParser);
            ((SentenceImplementation)object).classifyWords(conversationParser);
            if (conversationContext != null && conversationContext.getMergeExpressions()) {
                ((SentenceImplementation)object).evaluateSentenceType();
                ((SentenceImplementation)object).mergeWords();
                if (!conversationContext.isForMatching()) {
                    ((SentenceImplementation)object).standardizeSentenceType();
                    ((SentenceImplementation)object).performaAliasing();
                }
            }
            ((ErrorBuffer)object).setError(conversationParser.getErrorString());
        }
        catch (Exception exception) {
            LOGGER.error((Object)("ConversationParser.parse(): caught Exception while parsing '" + string + '\''));
            ((ErrorBuffer)object).setError(exception.getMessage());
            exception.printStackTrace();
        }
        return object;
    }

    public String readNextWord() {
        if (this.tokenizer.hasMoreTokens()) {
            return this.tokenizer.nextToken();
        }
        return null;
    }

    public static String detectSentenceType(String string, Sentence sentence) {
        String string2;
        PunctuationParser punctuationParser = new PunctuationParser(string);
        String string3 = punctuationParser.getTrailingPunctuation();
        if (string3.contains("?")) {
            sentence.setType(Sentence.SentenceType.QUESTION);
            string2 = punctuationParser.getText();
        } else if (string3.contains("!")) {
            sentence.setType(Sentence.SentenceType.IMPERATIVE);
            string2 = punctuationParser.getText();
        } else if (string3.contains(".")) {
            sentence.setType(Sentence.SentenceType.STATEMENT);
            string2 = punctuationParser.getText();
        } else {
            string2 = string;
        }
        return string2;
    }
}

