/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.AI;
import mikera.tyrant.Coin;
import mikera.tyrant.Damage;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Hero;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Quest;
import mikera.tyrant.RPG;
import mikera.tyrant.RangedWeapon;
import mikera.tyrant.Skill;
import mikera.tyrant.Spell;
import mikera.tyrant.Thing;

public class Being {
    private static final String[] stats = new String[]{"SK", "ST", "AG", "TG", "IN", "WP", "CH", "CR"};
    public static final double statLevelGain = 0.15;
    private static final String[] commonSkills = new String[]{"Attack", "Attack", "Defence", "Defence", "Ferocity", "Athletics", "Bravery", "Spellcasting", "Focus"};

    protected static void setStats(Thing thing, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            thing.set(RPG.stats[i], nArray[i]);
        }
    }

    public static boolean tryDrop(Thing thing, Thing thing2) {
        if (thing2.place != thing) {
            throw new Error("Thing in wrong place!");
        }
        if (thing2.y > 0 && thing2.getFlag("IsCursed")) {
            thing.message("You are unable to remove " + thing2.getYourName() + "!");
            return false;
        }
        int n = thing2.getStat("Number");
        if (thing == Game.hero() && n > 1) {
            int n2 = Game.getNumber("Drop how many (Enter=All)? ", n);
            if (n2 > 0) {
                thing2 = thing2.remove(n2);
            } else {
                Game.message("");
                return false;
            }
        }
        String string = thing2.getName(thing);
        Item.drop(thing, thing2);
        thing.message("Dropped " + string);
        thing.incStat("APS", -Being.actionCost(thing));
        return true;
    }

    public static boolean tryPickup(Thing thing, Thing thing2) {
        boolean bl = true;
        if (Item.isOwned(thing2)) {
            int n;
            int n2 = RPG.max(1, Item.value(thing2));
            if (thing2.getFlag("IsShopOwned") && !thing2.getFlag("IsMoney")) {
                Thing thing3 = Item.findShopkeeper(thing2);
                if (thing3 != null) {
                    n2 = Item.shopPrice(thing2, thing, thing3);
                }
                Game.message(thing2.getTheName() + " " + thing2.verb("cost") + " " + Coin.valueString(n2));
                Game.message("Buy, Shoplift or Leave? (b/s/l)");
                n = Game.getOption("sbl");
            } else {
                Game.message(thing2.getTheName() + " " + thing2.is() + " not yours");
                Game.message("Steal? (y/n)");
                n = Game.getOption("synl");
                if (n == 121) {
                    n = 115;
                }
            }
            Game.message("");
            if (n == 108) {
                bl = false;
            }
            if (n == 98) {
                int n3 = Coin.getMoney(thing);
                if (n2 > n3) {
                    Game.message("You can't afford that!");
                    Game.message("You only have " + Coin.valueString(n3));
                    bl = false;
                } else {
                    Game.message("You pay " + Coin.valueString(n2));
                    Coin.removeMoney(thing, n2);
                    Item.clearOwnership(thing2);
                }
            } else {
                bl = n == 115;
            }
        }
        if (bl) {
            thing.incStat("APS", -Being.actionCost(thing));
            Item.pickup(thing, thing2);
        }
        return bl;
    }

    public static int actionCost(Thing thing) {
        return 200 / (2 + thing.getStat("Sleight Of Hand"));
    }

    public static int maxCarryingWeight(Thing thing) {
        int n = (int)((double)thing.getStat("ST") * (1.0 + 0.25 * (double)thing.getStat("Trading")));
        int n2 = n * 10000 + 20000;
        n2 = n2 * thing.getStat("CarryFactor") / 100;
        return n2;
    }

    public static boolean feelsFear(Thing thing) {
        return thing.getFlag("IsLiving") && !thing.getFlag("Bravery");
    }

    public static int calcInventoryWeight(Thing thing) {
        Thing[] thingArray = thing.getItems();
        int n = 0;
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing2 = thingArray[i];
            int n2 = thing2.getWeight();
            n += n2;
        }
        return n;
    }

    public static void calcEncumberance(Thing thing) {
        int n;
        Thing[] thingArray = thing.getItems();
        int n2 = 0;
        int n3 = thing.getStat("ST");
        int n4 = 0;
        for (n = 0; n < thingArray.length; ++n) {
            Thing thing2 = thingArray[n];
            int n5 = thing2.getWeight();
            if (thing2.y > 0 && thing2.y != 21) {
                n2 += n5 / (n3 * 40);
            }
            n4 += n5;
        }
        n2 += n4 * 100 / Being.maxCarryingWeight(thing);
        n = thing.getStat("HungerThreshold");
        int n6 = 0;
        if (n > 0) {
            n6 = 100 * thing.getStat("Hunger") / n;
        }
        if (n6 < 0) {
            n2 += -n6 / 2;
        }
        n2 = RPG.middle(0, n2 - (20 + 3 * thing.getStat("Trading")), 100);
        thing.set("Encumberance", n2);
    }

    public static double getHealth(Thing thing) {
        double d = (double)thing.getStat("HPS") / (double)thing.getStat("HPSMAX");
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        return d;
    }

    public static void heal(Thing thing, int n) {
        if (!thing.getFlag("IsBeing")) {
            return;
        }
        if (thing.getFlag("IsUndead")) {
            n = -n;
        }
        int n2 = thing.getStat("HPS");
        int n3 = thing.getStat("HPSMAX");
        int n4 = RPG.min(n, n3 - n2);
        if (n4 > 0) {
            if (n4 > n2) {
                thing.message("You feel much better!");
            } else if (n4 + n2 == n3) {
                thing.message("You feel superb");
            } else {
                thing.message("You feel better");
            }
        } else if (n2 == n3) {
            thing.message("You feel great!");
        } else if (n4 < 0) {
            thing.message("You feel strangely worse");
        }
        thing.incStat("HPS", n4);
    }

    public static void gainLevel(Thing thing, int n) {
        while (thing.getStat("Level") < n) {
            Being.gainLevel(thing);
        }
    }

    public static void gainStat(Thing thing, String string) {
        Being.gainStat(thing, string, 1);
    }

    public static void gainStat(Thing thing, String string, int n) {
        thing.incStat(string, n);
        if (n == 0) {
            return;
        }
        if (string.equals("SK")) {
            thing.message("You feel your reflexes sharpening");
        }
        if (string.equals("ST")) {
            thing.message("You feel stronger now. What bulging muscles!");
        }
        if (string.equals("AG")) {
            thing.message("You feel nimble and quick");
        }
        if (string.equals("TG")) {
            thing.message("You feel healthier");
        }
        if (string.equals("IN")) {
            thing.message("You feel thoughtful");
        }
        if (string.equals("WP")) {
            thing.message("You feel more determined");
        }
        if (string.equals("CH")) {
            thing.message("You feel good about yourself");
        }
        if (string.equals("CR")) {
            thing.message("You feel inspiration coming on");
        }
    }

    public static int statIndex(String string) {
        return RPG.index(string, stats);
    }

    public static int averageStat(Thing thing) {
        int n = 0;
        for (int i = 0; i < stats.length; ++i) {
            n += thing.getBaseStat(stats[i]);
        }
        return n / 8;
    }

    public static String[] statNames() {
        return stats;
    }

    public static void registerKill(Thing thing, Thing thing2) {
        if (thing != null && thing2.getFlag("IsBeing")) {
            int n = thing2.getLevel();
            if (thing.isHero()) {
                Hero.gainKillExperience(thing, thing2);
            }
            if (thing.getStat("BestKillLevel") < n) {
                thing.set("BestKillLevel", n);
            }
            thing.incStat("KillCount", 1);
        }
        Event event = new Event("Kill");
        event.set("Killer", thing);
        event.set("Target", thing2);
        Quest.notifyKill(event);
    }

    public static void gainLevel(Thing thing) {
        int n = thing.getBaseStat("TG") / 3;
        int n2 = thing.getBaseStat("WP") / 3;
        thing.multiplyStat("HPS", 1.0 + (double)n / (double)thing.getStat("HPSMAX"));
        thing.multiplyStat("MPS", 1.0 + (double)n2 / (double)thing.getStat("MPSMAX"));
        thing.incStat("HPSMAX", n);
        thing.incStat("MPSMAX", n2);
        int n3 = thing.getStat("Level") + 1;
        thing.set("Level", n3);
        thing.incStat("SkillPoints", 1);
        if (thing.isHero()) {
            Game.message("You have achieved level " + n3);
            if (thing.getBaseStat("FatePoints") <= 0) {
                thing.set("FatePoints", 1);
            }
        } else {
            Being.autoLearnSkills(thing);
        }
        for (int i = 0; i < 8; ++i) {
            int n4 = thing.getBaseStat(RPG.stats[i]);
            double d = 0.15;
            if (RPG.d(2) != 1) continue;
            Being.gainStat(thing, RPG.stats[i], RPG.round((double)n4 * d));
        }
    }

    public static void utiliseItems(Thing thing) {
        if (!thing.getFlag("IsIntelligent")) {
            return;
        }
        Thing[] thingArray = thing.getWieldableContents();
        if (thingArray != null) {
            for (int i = 0; i < thingArray.length; ++i) {
                Thing thing2 = thingArray[i];
                if (thing2.place != thing) continue;
                thing.wield(thing2, thing2.getStat("WieldType"));
            }
        }
    }

    public static int calcViewRange(Thing thing) {
        int n;
        int n2 = thing.getStat("VisionRange");
        Map map = thing.getMap();
        if (map != null && (n = map.getStat("VisionRange")) > 0 && n < n2) {
            n2 = n;
        }
        return n2;
    }

    public static void autoLearnSkills(Thing thing) {
        while (thing.getStat("SkillPoints") > 0) {
            Thing thing2;
            thing.incStat("SkillPoints", -1);
            String[] stringArray = RPG.d(3) == 1 ? Skill.fullList() : commonSkills;
            String string = stringArray[RPG.r(stringArray.length)];
            thing.incStat(string, 1);
            if (!thing.getFlag("IsIntelligent") || !thing.getFlag("IsLiving")) continue;
            int n = thing.getLevel();
            if (Spell.isOrder(string)) {
                thing.addThing(Spell.randomSpell(string, thing.getLevel()));
                continue;
            }
            if (string.equals("Throwing") && RPG.d(3) == 1) {
                thing.addThing(Lib.createType("IsThrowingWeapon", n));
                continue;
            }
            if (string.equals("Archery") && RPG.d(2) == 1) {
                thing2 = Lib.createType("IsRangedWeapon", n);
                thing.addThing(thing2);
                thing.addThing(RangedWeapon.createAmmo(thing2, n));
                continue;
            }
            if (string.equals("Throwing") && RPG.d(2) == 1) {
                thing2 = Lib.createType("IsThrowingWeapon", n);
                thing.addThing(thing2);
                continue;
            }
            if (!string.equals("Alchemy") || RPG.d(3) != 1) continue;
            thing.addThing(Lib.createType("IsPotion", n));
        }
    }

    public static void recover(Thing thing, int n) {
        int n2;
        int n3;
        int n4 = thing.getStat("MPS");
        if (n4 < 0) {
            thing.incStat("MPS", -n4);
            Damage.inflict(thing, n4, "special");
            n4 = 0;
        }
        boolean bl = false;
        if (thing.isHero()) {
            n3 = thing.getStat("Hunger");
            boolean bl2 = bl = n3 > (n2 = thing.getStat("HungerThreshold"));
        }
        if (!bl) {
            int n5;
            n3 = thing.getStat("RegenerationRate");
            n2 = thing.getStat("Healing");
            int n6 = 0;
            int n7 = thing.getStat("HPSMAX");
            int n8 = thing.getStat("HPS");
            if (n3 > 0) {
                n5 = thing.getStat("TG");
                n6 += RPG.round((float)n * (float)n3 * (float)n5 / 1000000.0f);
            }
            if (n2 > 0) {
                n6 += RPG.round((float)n * (float)n2 * 50.0f * (float)n7 / 1000000.0f);
            }
            thing.set("HPS", RPG.middle(n8, n8 + n6, n7));
            n5 = thing.getStat("RechargeRate");
            if (n5 > 0) {
                int n9 = thing.getStat("MPSMAX");
                thing.set("MPS", RPG.middle(n4, n4 + RPG.round((float)n * (float)n5 * (float)n9 / 1000000.0f), n9));
            }
            if (thing.getFlag("Spellcasting")) {
                Spell.rechargeSpells(thing, n);
            }
        }
    }

    public static void init() {
        Thing thing = Lib.extend("base being", "base thing");
        thing.set("HPS", 1);
        thing.set("ImageSource", "Creatures");
        thing.set("Image", 340);
        thing.set("IsBeing", 1);
        thing.set("IsMobile", 1);
        thing.set("IsLiving", 1);
        thing.set("IsActive", 1);
        thing.set("IsPhysical", 1);
        thing.set("IsJumpable", 1);
        thing.set("IsDestructible", 1);
        thing.set("IsDisplaceable", 1);
        thing.set("IsRegenerating", 1);
        thing.set("CarryFactor", 100);
        thing.set("VisionRange", 6);
        thing.set("RechargeRate", 200);
        thing.set("RegenerationRate", 40);
        thing.set("Speed", 100);
        thing.set("MoveSpeed", 100);
        thing.set("AttackSpeed", 100);
        thing.set("Frequency", 50);
        thing.set("Alignment", "N");
        thing.set("IsBlocking", 1);
        thing.set("MoveCost", 100);
        thing.addHandler("OnAction", new AI.AIScript());
        thing.set("DeathDecoration", "blood pool");
        thing.set("RES:water", 35);
        thing.set("NameType", 0);
        thing.set("Z", 40);
        Lib.add(thing);
    }
}

