/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.Graphics;
import java.util.ArrayList;
import mikera.tyrant.Armour;
import mikera.tyrant.Coin;
import mikera.tyrant.Combat;
import mikera.tyrant.Describer;
import mikera.tyrant.Game;
import mikera.tyrant.Movement;
import mikera.tyrant.QuestApp;
import mikera.tyrant.RPG;
import mikera.tyrant.Screen;
import mikera.tyrant.Skill;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;
import mikera.tyrant.Weapon;

public class CharacterScreen
extends Screen {
    private static final long serialVersionUID = 3257845463519868464L;
    public Thing character;

    public CharacterScreen(Thing thing) {
        super(Game.getQuestapp());
        this.setForeground(QuestApp.INFOTEXTCOLOUR);
        this.setBackground(QuestApp.INFOSCREENCOLOUR);
        this.setFont(QuestApp.mainfont);
        this.character = thing;
    }

    private String statString(String string) {
        int n = this.character.getBaseStat(string);
        int n2 = this.character.getStat(string) - n;
        return Text.centrePad(new Integer(n).toString(), (n2 >= 0 ? "(+" + n2 : "(" + n2) + ")", 8);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Thing thing = this.character;
        graphics.setColor(QuestApp.INFOTEXTCOLOUR);
        String string = thing.getString("HeroName");
        if (string == null) {
            string = thing.name();
        }
        graphics.drawString(string, 40, 20);
        graphics.drawString(Text.capitalise(thing.getString("Race")) + " " + Text.capitalise(thing.getString("Profession")), 240, 20);
        int n = thing.getImage();
        int n2 = n % 20 * 32;
        int n3 = n / 20 * 32;
        int n4 = 4;
        int n5 = 4;
        graphics.drawImage(QuestApp.creatures, n4, n5, n4 + 32, n5 + 32, n2, n3, n2 + 32, n3 + 32, null);
        graphics.drawString("SK: " + this.statString("SK"), 40, 40);
        graphics.drawString("ST: " + this.statString("ST"), 40, 56);
        graphics.drawString("AG: " + this.statString("AG"), 40, 72);
        graphics.drawString("TG: " + this.statString("TG"), 40, 88);
        graphics.drawString("IN: " + this.statString("IN"), 40, 104);
        graphics.drawString("WP: " + this.statString("WP"), 40, 120);
        graphics.drawString("CH: " + this.statString("CH"), 40, 136);
        graphics.drawString("CR: " + this.statString("CR"), 40, 152);
        graphics.drawString("Hit Points    : " + thing.getStat("HPS") + "/" + this.character.getStat("HPSMAX"), 40, 184);
        graphics.drawString("Magic Points  : " + thing.getStat("MPS") + "/" + this.character.getStat("MPSMAX"), 40, 200);
        graphics.drawString("Base Speed    : " + thing.getStat("Speed"), 40, 216);
        graphics.drawString("Move Speed    : " + Movement.calcMoveSpeed(thing), 40, 232);
        graphics.drawString("Attack Speed  : " + Combat.calcAttackSpeed(thing), 40, 248);
        graphics.drawString("Current Level : " + thing.getStat("Level"), 40, 264);
        graphics.drawString("Current Exp.  : " + thing.getStat("Experience"), 40, 280);
        graphics.drawString("Skill Points  : " + thing.getStat("SkillPoints"), 40, 296);
        graphics.drawString("Hunger level  : " + RPG.percentile(thing.getStat("Hunger"), thing.getStat("HungerThreshold")) + "%", 40, 312);
        if (Game.isDebug()) {
            n = 100;
            n2 = 40;
            Thing thing2 = thing.getWielded(1);
            if (thing2 == null) {
                graphics.drawString("Right Hand    : ", n, n2 + 304);
            } else {
                graphics.drawString("Right Hand    : " + Describer.describe(thing, thing2, 0), n, n2 + 304);
            }
            thing2 = thing.getWielded(2);
            if (thing2 == null) {
                graphics.drawString("Left Hand     : ", n, n2 + 320);
            } else {
                graphics.drawString("Left Hand     : " + Describer.describe(thing, thing2, 0), n, n2 + 320);
            }
            thing2 = thing.getWielded(3);
            if (thing2 == null) {
                graphics.drawString("Both Hands    : ", n, n2 + 336);
            } else {
                graphics.drawString("Both Hands    : " + Describer.describe(thing, thing2, 0), n, n2 + 336);
            }
            thing2 = thing.getWielded(20);
            if (thing2 == null) {
                graphics.drawString("Ranged Weapon : ", n, n2 + 352);
            } else {
                graphics.drawString("Ranged Weapon : " + Describer.describe(thing, thing2, 0), n, n2 + 352);
            }
            thing2 = thing.getWielded(21);
            if (thing2 == null) {
                graphics.drawString("Missile       : ", n, n2 + 368);
            } else {
                graphics.drawString("Missile       : " + Describer.describe(thing, thing2, 0), n, n2 + 368);
            }
            thing2 = thing.getWielded(9);
            if (thing2 == null) {
                graphics.drawString("Torso         : ", n, n2 + 384);
            } else {
                graphics.drawString("Torso         : " + Describer.describe(thing, thing2, 0), n, n2 + 384);
            }
            thing2 = thing.getWielded(10);
            if (thing2 == null) {
                graphics.drawString("Legs          : ", n, n2 + 400);
            } else {
                graphics.drawString("Legs          : " + Describer.describe(thing, thing2, 0), n, n2 + 400);
            }
            thing2 = thing.getWielded(11);
            if (thing2 == null) {
                graphics.drawString("Head          : ", n, n2 + 416);
            } else {
                graphics.drawString("Head          : " + Describer.describe(thing, thing2, 0), n, n2 + 416);
            }
            thing2 = thing.getWielded(8);
            if (thing2 == null) {
                graphics.drawString("Boots         : ", n, n2 + 432);
            } else {
                graphics.drawString("Boots         : " + Describer.describe(thing, thing2, 0), n, n2 + 432);
            }
            thing2 = thing.getWielded(7);
            if (thing2 == null) {
                graphics.drawString("Hands         : ", n, n2 + 448);
            } else {
                graphics.drawString("Hands         : " + Describer.describe(thing, thing2, 0), n, n2 + 448);
            }
            thing2 = thing.getWielded(12);
            if (thing2 == null) {
                graphics.drawString("Cloak         : ", n, n2 + 464);
            } else {
                graphics.drawString("Cloak         : " + Describer.describe(thing, thing2, 0), n, n2 + 464);
            }
            thing2 = thing.getWielded(13);
            if (thing2 == null) {
                graphics.drawString("Full Body     : ", n, n2 + 480);
            } else {
                graphics.drawString("Full Body     : " + Describer.describe(thing, thing2, 0), n, n2 + 480);
            }
            thing2 = thing.getWielded(14);
            if (thing2 == null) {
                graphics.drawString("Bracers       : ", n, n2 + 496);
            } else {
                graphics.drawString("Bracers       : " + Describer.describe(thing, thing2, 0), n, n2 + 496);
            }
            thing2 = thing.getWielded(15);
            if (thing2 == null) {
                graphics.drawString("Belt          : ", n, n2 + 512);
            } else {
                graphics.drawString("Belt          : " + Describer.describe(thing, thing2, 0), n, n2 + 512);
            }
            thing2 = thing.getWielded(4);
            if (thing2 == null) {
                graphics.drawString("Right Ring    : ", n, n2 + 528);
            } else {
                graphics.drawString("Right Ring    : " + Describer.describe(thing, thing2, 0), n, n2 + 528);
            }
            thing2 = thing.getWielded(5);
            if (thing2 == null) {
                graphics.drawString("Left Ring     : ", n, n2 + 544);
            } else {
                graphics.drawString("Left Ring     : " + Describer.describe(thing, thing2, 0), n, n2 + 544);
            }
            thing2 = thing.getWielded(6);
            if (thing2 == null) {
                graphics.drawString("Neck          : ", n, n2 + 560);
            } else {
                graphics.drawString("Neck          : " + Describer.describe(thing, thing2, 0), n, n2 + 560);
            }
        }
        if (Game.isDebug()) {
            n = 100;
            n2 = 40;
            graphics.drawString("Normal        : " + thing.getStat("RES:normal"), n, n2 + 704);
            graphics.drawString("Impact        : " + thing.getStat("RES:impact"), n, n2 + 720);
            graphics.drawString("Piercing      : " + thing.getStat("RES:piercing"), n, n2 + 736);
            graphics.drawString("Water         : " + thing.getStat("RES:water"), n, n2 + 752);
            graphics.drawString("Poison        : " + thing.getStat("RES:poison"), n, n2 + 768);
            graphics.drawString("Fire          : " + thing.getStat("RES:fire"), n, n2 + 784);
            graphics.drawString("Ice           : " + thing.getStat("RES:ice"), n, n2 + 800);
            graphics.drawString("Chill         : " + thing.getStat("RES:chill"), n, n2 + 816);
            graphics.drawString("Acid          : " + thing.getStat("RES:acid"), n, n2 + 832);
            graphics.drawString("Shock         : " + thing.getStat("RES:shock"), n, n2 + 848);
            graphics.drawString("Drain         : " + thing.getStat("RES:drain"), n, n2 + 864);
            graphics.drawString("Disintegrate  : " + thing.getStat("RES:disintegrate"), n, n2 + 880);
        }
        graphics.drawString("Game Turns: " + Game.hero().getStat("TurnCount"), 240, 40);
        graphics.drawString("Kill Count: " + Game.hero().getStat("KillCount"), 240, 56);
        graphics.drawString("Game Time:  " + Game.hero().getStat("GameTime") / 100, 240, 72);
        Thing thing3 = thing.getWielded(1);
        if (thing3 != null && thing3.getFlag("IsWeapon")) {
            graphics.drawString("Wielding " + thing3.getName(Game.hero()), 240, 184);
        } else {
            graphics.drawString("Unarmed", 240, 184);
            thing3 = Combat.unarmedWeapon(thing);
        }
        graphics.drawString("Attack Cost     : " + Combat.attackCost(thing, thing3), 240, 200);
        graphics.drawString("Attack Skill    : " + Weapon.calcASK(thing3, thing, null), 240, 216);
        graphics.drawString("Attack Strength : " + Weapon.calcAST(thing3, thing, null), 240, 232);
        graphics.drawString("Defence Skill   : " + Weapon.calcDSK(thing), 240, 248);
        graphics.drawString("Armour Class    : " + Armour.calcArmour(thing, "normal"), 240, 264);
        graphics.drawString("Encumberance    : " + RPG.middle(0, thing.getStat("Encumberance"), 100) + "%", 240, 280);
        graphics.drawString("Wealth          : " + Integer.toString(Coin.getMoney(thing)), 240, 296);
        String string2 = thing.getString("Religion");
        graphics.drawString("You worship " + (string2 == null ? "no god" : string2), 240, 312);
        graphics.drawString("Your skills:", 450, 20);
        ArrayList arrayList = Skill.getList(thing);
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            graphics.drawString((String)arrayList.get(n4), 460, 40 + n4 * 16);
        }
        String string3 = "ESC=Exit";
        graphics.drawString(string3, 20, this.getSize().height - 10);
    }
}

