/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.Poison;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;

public class Effect {
    public static void init() {
        Thing thing = Lib.extend("base effect", "base thing");
        thing.set("IsEffect", 1);
        thing.set("NoStack", 1);
        thing.set("ImageSource", "Effects");
        thing.set("Image", 45);
        thing.set("LevelMin", 1);
        thing.set("EffectName", "effect");
        Lib.add(thing);
        thing = Lib.extend("temporary effect", "base effect");
        thing.set("IsTemporaryEffect", 1);
        thing.set("IsActive", 1);
        thing.addHandler("OnAction", Scripts.decay(true));
        Lib.add(thing);
        Poison.init();
        Effect.initCurses();
        Effect.initBlessings();
        Effect.initBadEffects();
    }

    private static void initCurses() {
        Thing thing = Lib.extend("base curse", "temporary effect");
        thing.set("IsCurse", 1);
        thing.set("EffectName", "cursed");
        thing.set("AttributeAddMessage", "You feel like this is going to be a bad day");
        Lib.add(thing);
        thing = Lib.extend("curse", "base curse");
        thing.set("LifeTime", 10000);
        thing.add("CarriedModifiers", Modifier.linear("Luck", 100, -50));
        Lib.add(thing);
        thing = Lib.extend("hex", "base curse");
        thing.set("LifeTime", 3000);
        thing.add("CarriedModifiers", Modifier.linear("Luck", 100, -100));
        thing.set("AttributeAddMessage", "You feel like this is going to be a terrible day");
        Lib.add(thing);
        thing = Lib.extend("curse of doom", "base curse");
        thing.set("LifeTime", 30000);
        thing.set("EffectName", "doomed");
        thing.add("CarriedModifiers", Modifier.linear("Luck", 100, -150));
        Lib.add(thing);
        thing = Lib.extend("curse of blindness", "base curse");
        thing.set("DecayRate", 100);
        thing.set("EffectName", "blinded");
        thing.add("CarriedModifiers", Modifier.linear("IsBlind", 0, 1));
        thing.set("AttributeAddMessage", "You are blinded!");
        Lib.add(thing);
    }

    private static void initBadEffects() {
        Thing thing = Lib.extend("base bad effect", "temporary effect");
        thing.set("IsBadEffect", 1);
        thing.set("EffectName", "bad effect");
        Lib.add(thing);
        thing = Lib.extend("confusion", "base bad effect");
        thing.set("IsActive", 20000);
        thing.set("LifeTime", 2000);
        thing.set("ResistStat", "WP");
        thing.set("ResistDifficulty", 30);
        thing.set("EffectName", "confused");
        thing.set("AttributeAddMessage", "You feel very confused!");
        thing.set("ResistMessage", "You feel dizzy but manage to stay clear-headed");
        thing.add("CarriedModifiers", Modifier.linear("IsConfused", 0, 1));
        Lib.add(thing);
        thing = Lib.extend("slow", "base bad effect");
        thing.set("LifeTime", 3000);
        thing.set("EffectName", "slowed");
        thing.set("CancelEffect", "haste");
        thing.add("CarriedModifiers", Modifier.linear("Speed", 66, 0));
        Lib.add(thing);
        thing = Lib.extend("web", "base bad effect");
        thing.set("LifeTime", 4000);
        thing.set("EffectName", "webbed");
        thing.add("CarriedModifiers", Modifier.linear("MoveSpeed", 80, 0));
        thing.add("CarriedModifiers", Modifier.linear("AttackSpeed", 80, 0));
        thing.add("CarriedModifiers", Modifier.linear("AG", 50, 0));
        thing.add("CarriedModifiers", Modifier.linear("SK", 75, 0));
        Lib.add(thing);
    }

    private static void initBlessings() {
        Thing thing = Lib.extend("base blessing", "temporary effect");
        thing.set("IsBlessing", 1);
        thing.set("IsActive", 1);
        thing.set("EffectName", "blessed");
        Lib.add(thing);
        thing = Lib.extend("blessing", "base blessing");
        thing.set("LifeTime", 5000);
        thing.add("CarriedModifiers", Modifier.linear("Luck", 100, 30));
        Lib.add(thing);
        thing = Lib.extend("stone skin", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "stone skinned");
        thing.add("CarriedModifiers", Modifier.bonus("ARM", 30));
        thing.set("AttributeAddMessage", "Your skin seems to harden");
        Lib.add(thing);
        thing = Lib.extend("fire protection", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "fire protected");
        thing.add("CarriedModifiers", Modifier.bonus("ARM:fire", 30));
        thing.add("CarriedModifiers", Modifier.bonus("RES:fire", 15));
        thing.set("AttributeAddMessage", "Your blood starts to boil");
        Lib.add(thing);
        thing = Lib.extend("ice protection", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "ice protected");
        thing.add("CarriedModifiers", Modifier.bonus("ARM:ice", 30));
        thing.add("CarriedModifiers", Modifier.bonus("RES:ice", 15));
        thing.set("AttributeAddMessage", "You feel seriously cool");
        Lib.add(thing);
        thing = Lib.extend("poison resistance", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "poison protected");
        thing.add("CarriedModifiers", Modifier.bonus("RES:poison", 20));
        thing.set("AttributeAddMessage", "You feel fit and healthy");
        Lib.add(thing);
        thing = Lib.extend("haste", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "hasted");
        thing.set("CancelEffect", "slow");
        thing.add("CarriedModifiers", Modifier.linear("Speed", 100, 80));
        thing.set("AttributeAddMessage", "You feel very energetic");
        Lib.add(thing);
        thing = Lib.extend("accelerate", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "accelerated");
        thing.set("CancelEffect", "slow");
        thing.add("CarriedModifiers", Modifier.linear("MoveSpeed", 150, 0));
        thing.set("AttributeAddMessage", "You feel like running around");
        Lib.add(thing);
        thing = Lib.extend("berserk", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "berserk");
        thing.set("CancelEffect", "calm");
        thing.add("CarriedModifiers", Modifier.bonus("Attack", 2));
        thing.add("CarriedModifiers", Modifier.bonus("Ferocity", 1));
        thing.add("CarriedModifiers", Modifier.linear("Defence", 50, -1));
        thing.add("CarriedModifiers", Modifier.constant("IsBerserk", 1));
        thing.set("AttributeAddMessage", "You are filled with rage!");
        Lib.add(thing);
        thing = Lib.extend("calm", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "calm");
        thing.set("CancelEffect", "berserk");
        thing.add("CarriedModifiers", Modifier.linear("CH", 110, 3));
        thing.add("CarriedModifiers", Modifier.linear("IN", 110, 3));
        thing.set("AttributeAddMessage", "You feel calm");
        Lib.add(thing);
        thing = Lib.extend("fearsome", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "fearsome");
        thing.add("CarriedModifiers", Modifier.linear("FearFactor", 100, 2));
        thing.add("CarriedModifiers", Modifier.linear("CH", 60, 0));
        thing.set("AttributeAddMessage", "You feel the will to dominate weaker beings");
        Lib.add(thing);
        thing = Lib.extend("ethereality", "base blessing");
        thing.set("LifeTime", 1000);
        thing.set("EffectName", "ethereal");
        thing.add("CarriedModifiers", Modifier.linear("IsEthereal", 0, 1));
        thing.set("AttributeAddMessage", "You feel that you are disconnected from the world");
        Lib.add(thing);
        thing = Lib.extend("flight", "base blessing");
        thing.set("LifeTime", 5000);
        thing.set("EffectName", "flying");
        thing.add("CarriedModifiers", Modifier.linear("IsFlying", 0, 1));
        thing.set("AttributeAddMessage", "You start to fly");
        Lib.add(thing);
    }

    public static Thing temporary(Modifier modifier, int n) {
        Thing thing = Lib.create("temporary effect");
        thing.set("LifeTime", n);
        thing.add("CarriedModifiers", modifier);
        return thing;
    }
}

