/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Being;
import mikera.tyrant.Damage;
import mikera.tyrant.Dungeon;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Spell;
import mikera.tyrant.Text;
import mikera.tyrant.Theme;
import mikera.tyrant.Thing;
import mikera.tyrant.ThingOwner;
import mikera.tyrant.Tile;
import mikera.tyrant.WorldMap;
import mikera.tyrant.test.MapHelper;

public final class Map
extends BaseObject
implements ThingOwner,
Serializable {
    private static final long serialVersionUID = 2476911722567644463L;
    protected int[] tiles;
    protected Thing[] objects;
    protected int width;
    protected int height;
    private int size;
    private Game game;
    public transient int[] path;
    private static final int LOS_DETAIL = 26;
    private static final double DLOS_DETAIL = 26.0;
    public static final int DIR_NONE = 0;
    public static final int DIR_N = 1;
    public static final int DIR_NE = 2;
    public static final int DIR_E = 3;
    public static final int DIR_SE = 4;
    public static final int DIR_S = 5;
    public static final int DIR_SW = 6;
    public static final int DIR_W = 7;
    public static final int DIR_NW = 8;
    public static final int[] DX = new int[]{0, 0, 1, 1, 1, 0, -1, -1, -1};
    public static final int[] DY = new int[]{0, -1, -1, 0, 1, 1, 1, 0, -1};
    public static final int FILTER_MONSTER = 1;
    public static final int FILTER_ITEM = 2;
    private static final Thing[] emptyThings = new Thing[0];

    public Map(int n, int n2) {
        this.size = n * n2;
        this.tiles = new int[this.size];
        this.path = new int[this.size];
        this.objects = new Thing[this.size];
        this.width = n;
        this.height = n2;
        this.set("HashName", "unknown");
        this.set("FloorTile", 1);
        this.set("WallTile", 10);
        this.set("Description", "Unknown Area");
        this.set("Level", 1);
        this.set("MonsterType", "IsHostile");
        this.set("WanderingRate", 100);
    }

    public Thing entrance() {
        return this.getEntrance();
    }

    public void setTheme(String string) {
        this.setTheme(Theme.getTheme(string));
    }

    public void setTheme(Theme theme) {
        java.util.Map map = theme.getCollapsedMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("Name")) continue;
            this.set(string, map.get(string));
        }
        this.set("Theme", theme.getString("Name"));
    }

    public int wall() {
        return this.getStat("WallTile");
    }

    public int floor() {
        return this.getStat("FloorTile");
    }

    public void setSize(int n, int n2) {
        this.size = n * n2;
        this.tiles = new int[this.size];
        this.path = new int[this.size];
        this.objects = new Thing[this.size];
        this.width = n;
        this.height = n2;
    }

    public boolean canExit() {
        Thing thing = Game.hero();
        if (thing.x == 0 || thing.y == 0 || thing.x == this.width - 1 || thing.y == this.height - 1) {
            return true;
        }
        Game.message("There is no way to exit here");
        return false;
    }

    public void setAngry(boolean bl) {
        boolean bl2 = this.getFlag("IsHostile");
        if (!bl2) {
            this.set("IsHostile", bl);
        }
    }

    public boolean isAngry() {
        return this.getFlag("IsHostile");
    }

    public void clearPath() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.path[i + j * this.width] = 0;
            }
        }
    }

    public void calcPath(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        for (n11 = 0; n11 < this.width; ++n11) {
            for (n10 = 0; n10 < this.height; ++n10) {
                this.path[n11 + n10 * this.width] = -1;
            }
        }
        this.path[n + n2 * this.height] = 0;
        for (n11 = 1; n11 < n3; ++n11) {
            n10 = RPG.max(1, n - n11);
            n9 = RPG.max(1, n2 - n11);
            n8 = RPG.min(this.width - 2, n + n11);
            n7 = RPG.min(this.width - 2, n2 + n11);
            for (n6 = n10; n6 <= n8; ++n6) {
                for (n5 = n9; n5 <= n7; ++n5) {
                    n4 = n6 + n5 * this.width;
                    if (this.path[n4] != -1 || (this.getTile(n6, n5) & 0x10000) != 0 || this.path[n4 - this.width - 1] != n11 && this.path[n4 - this.width] != n11 && this.path[n4 - this.width + 1] != n11 && this.path[n4 - 1] != n11 && this.path[n4 + 1] != n11 && this.path[n4 + this.width - 1] != n11 && this.path[n4 + this.width] != n11 && this.path[n4 + this.width + 1] != n11) continue;
                    this.path[n4] = n11 + 1;
                }
            }
        }
        n11 = RPG.max(1, n - n3);
        n10 = RPG.max(1, n2 - n3);
        n9 = RPG.min(this.width - 2, n + n3);
        n8 = RPG.min(this.width - 2, n2 + n3);
        for (n7 = n11; n7 <= n9; ++n7) {
            for (n6 = n10; n6 <= n8; ++n6) {
                n5 = n7 + n6 * this.width;
                n4 = this.path[n5];
                if (n4 <= 0) continue;
                for (int i = 1; i <= 8; ++i) {
                    if (this.path[n5 + DX[i] + this.width * DY[i]] != n4 - 1) continue;
                    this.setTile(n7, n6, this.getTileFull(n7, n6) & 0xF87FFFFF | i * 0x800000);
                }
            }
        }
    }

    public void fractalize(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        n3 = n + (n3 - n) / n5 * n5 - 1;
        n4 = n2 + (n4 - n2) / n5 * n5 - 1;
        int n8 = n5 / 2;
        if (n8 < 1) {
            return;
        }
        for (n7 = n2; n7 <= n4; n7 += n5) {
            for (n6 = n; n6 <= n3; n6 += n5) {
                if (RPG.r(2) == 0) {
                    this.setTile(n6 + n8, n7, this.getTileFull(n6, n7));
                } else {
                    this.setTile(n6 + n8, n7, this.getTileFull(n6 + n5, n7));
                }
                if (RPG.r(2) == 0) {
                    this.setTile(n6, n7 + n8, this.getTileFull(n6, n7));
                    continue;
                }
                this.setTile(n6, n7 + n8, this.getTileFull(n6, n7 + n5));
            }
        }
        for (n7 = n2; n7 <= n4; n7 += n5) {
            for (n6 = n; n6 <= n3; n6 += n5) {
                int n9;
                switch (RPG.d(4)) {
                    case 1: {
                        n9 = this.getTileFull(n6 + n8, n7);
                        break;
                    }
                    case 2: {
                        n9 = this.getTileFull(n6 + n8, n7 + n5);
                        break;
                    }
                    case 3: {
                        n9 = this.getTileFull(n6, n7 + n8);
                        break;
                    }
                    default: {
                        n9 = this.getTileFull(n6 + n5, n7 + n8);
                    }
                }
                this.setTile(n6 + n8, n7 + n8, n9);
            }
        }
        if (n8 > 1) {
            this.fractalize(n, n2, n3, n4, n8);
        }
    }

    public void fractalizeBlock(int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 / 2;
        int n7 = ~(n5 - 1);
        if (n6 < 1) {
            return;
        }
        for (int i = n2; i <= n4; i += n6) {
            for (int j = n; j <= n3; j += n6) {
                int n8 = RPG.r(2) == 0 ? j : j + n6;
                int n9 = RPG.r(2) == 0 ? i : i + n6;
                n8 = (n8 - n & n7) + n;
                n9 = (n9 - n2 & n7) + n2;
                this.setTile(j, i, this.getTileFull(n8, n9));
            }
        }
        if (n6 > 1) {
            this.fractalizeBlock(n, n2, n3, n4, n6);
        }
    }

    public void calcReachable(int n, int n2) {
        int n3;
        int n4;
        for (n4 = 0; n4 < this.width; ++n4) {
            for (n3 = 0; n3 < this.height; ++n3) {
                this.path[n4 + n3 * this.width] = 0;
            }
        }
        this.path[n + n2 * this.height] = 1;
        n4 = 1;
        n3 = 1;
        while (n4 != 0) {
            ++n3;
            n4 = 0;
            for (int i = 1; i < this.width - 1; ++i) {
                for (int j = 1; j < this.height - 1; ++j) {
                    if (this.path[i + j * this.width] != 0 || (this.getTile(i, j) & 0x10000) != 0 || this.path[i + (j - 1) * this.width] != n3 && this.path[i + 1 + (j - 1) * this.width] != n3 && this.path[i + 1 + j * this.width] != n3 && this.path[i + 1 + (j + 1) * this.width] != n3 && this.path[i + (j + 1) * this.width] != n3 && this.path[i - 1 + (j + 1) * this.width] != n3 && this.path[i - 1 + j * this.width] != n3 && this.path[i - 1 + (j - 1) * this.width] != n3) continue;
                    this.path[i + j * this.width] = n3;
                    n4 = 1;
                }
            }
        }
    }

    public void replaceTiles(int n, int n2) {
        this.replaceTiles(0, 0, this.width - 1, this.height - 1, n, n2);
    }

    public void replaceTiles(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                if (this.getTile(i, j) != n5) continue;
                this.setTile(i, j, n6);
            }
        }
    }

    public boolean isBlank(int n, int n2) {
        return this.getTile(n, n2) == 0;
    }

    public boolean isBlank(int n, int n2, int n3, int n4) {
        int n5;
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        for (n5 = n; n5 <= n3; ++n5) {
            for (int i = n2; i <= n4; ++i) {
                if (this.getTile(n5, i) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public void setLevel(int n) {
        this.set("Level", n);
    }

    public int getLevel() {
        return this.getStat("Level");
    }

    public int countTiles(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                if (this.getTile(i, j) != n5) continue;
                ++n6;
            }
        }
        return n6;
    }

    public void fillArea(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n > n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 > n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        for (n6 = n; n6 <= n3; ++n6) {
            for (int i = n2; i <= n4; ++i) {
                this.setTile(n6, i, n5);
            }
        }
    }

    public void spray(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n3 + n2) / 2;
        int n8 = (n4 + n2) / 2;
        this.setTile(n7, n8, n5);
        int n9 = n3 - n + 1;
        int n10 = n4 - n2 + 1;
        for (int i = (n9 + n10) * n6 / 100; i > 0; --i) {
            int n11 = RPG.rspread(n, n3);
            int n12 = RPG.rspread(n2, n4);
            this.makeRandomPath(n7, n8, n11, n12, n, n2, n3, n4, n5, false);
        }
    }

    public void fillOval(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n > n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 > n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        double d = (double)(n + n3) / 2.0;
        double d2 = (double)(n2 + n4) / 2.0;
        double d3 = (d - (double)n) * 1.005;
        double d4 = (d2 - (double)n2) * 1.005;
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                if (!(((double)i - d) * ((double)i - d) / (d3 * d3) + ((double)j - d2) * ((double)j - d2) / (d4 * d4) < 1.0)) continue;
                this.setTile(i, j, n5);
            }
        }
    }

    public void fillRoom(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, n6);
        this.fillBorder(n, n2, n3, n4, n5);
    }

    public void clearArea(int n, int n2, int n3, int n4) {
        Thing[] thingArray = this.getThings(n, n2, n3, n4);
        for (int i = 0; i < thingArray.length; ++i) {
            thingArray[i].remove();
        }
    }

    public void clearArea(int n, int n2, int n3, int n4, int n5) {
        this.clearArea(n, n2, n3, n4);
        this.fillArea(n, n2, n3, n4, n5);
    }

    public void spreadTiles(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                if (this.getTile(i, j) != n6) continue;
                for (int k = -1; k <= 1; ++k) {
                    for (int i2 = -1; i2 <= 1; ++i2) {
                        if (this.getTile(i + k, j + i2) != n5) continue;
                        this.setTile(i, j, 65535);
                    }
                }
            }
        }
        this.replaceTiles(65535, n5);
    }

    public void blurArea(int n, int n2, int n3, int n4) {
        for (int i = 0; i < (n3 - n + 1) * (n4 - n2 + 1) / 4; ++i) {
            int n5 = RPG.rspread(n + 1, n3 - 1);
            int n6 = RPG.rspread(n2 + 1, n4 - 1);
            int n7 = n5 + RPG.r(3) - 1;
            int n8 = n6 + RPG.r(3) - 1;
            int n9 = this.getTileFull(n5, n6);
            this.setTile(n5, n5, this.getTileFull(n7, n8));
            this.setTile(n7, n8, n9);
        }
    }

    public void rotateArea(int n, int n2, int n3, int n4) {
        int n5;
        if ((n4 &= 3) == 0) {
            return;
        }
        if (n4 > 1) {
            this.rotateArea(n, n2, n3, n4 - 1);
        }
        for (int i = 0; i < (n3 + 1) / 2; ++i) {
            for (n5 = 0; n5 < n3 / 2; ++n5) {
                int n6 = this.getTileFull(n + i, n2 + n5);
                this.setTile(n + i, n2 + n5, this.getTileFull(n + n5, n2 + n3 - 1 - i));
                this.setTile(n + n5, n2 + n3 - 1 - i, this.getTileFull(n + n3 - 1 - i, n2 + n3 - 1 - n5));
                this.setTile(n + n3 - 1 - i, n2 + n3 - 1 - n5, this.getTileFull(n + n3 - 1 - n5, n2 + i));
                this.setTile(n + n3 - 1 - n5, n2 + i, n6);
            }
        }
        Thing[] thingArray = this.getThings(n, n2, n + n3 - 1, n2 + n3 - 1);
        for (n5 = 0; n5 < thingArray.length; ++n5) {
            Thing thing = thingArray[n5];
            int n7 = n + n3 - 1 - (thing.y - n2);
            int n8 = n2 + (thing.x - n);
            this.addThing(thing, n7, n8);
        }
    }

    public void copyArea(int n, int n2, Map map) {
        this.copyArea(n, n2, map, 0, 0, map.width, map.height);
    }

    public void copyArea(int n, int n2, Map map, int n3, int n4, int n5, int n6) {
        this.clearArea(n, n2, n + n3, n2 + n4);
        for (int i = n; i < n + n5; ++i) {
            for (int j = n2; j < n2 + n6; ++j) {
                this.setTile(i, j, map.getTileFull(i - n + n3, j - n2 + n4));
                Thing[] thingArray = map.getThings(i - n + n3, j - n2 + n4);
                for (int k = 0; k < thingArray.length; ++k) {
                    this.addThing((Thing)thingArray[k].clone(), i, j);
                }
            }
        }
    }

    public void fillBorder(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n > n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 > n4) {
            n6 = n2;
            n = n4;
            n4 = n6;
        }
        for (n6 = n; n6 <= n3; ++n6) {
            this.setTile(n6, n2, n5);
            this.setTile(n6, n4, n5);
        }
        for (n6 = n2; n6 <= n4; ++n6) {
            this.setTile(n, n6, n5);
            this.setTile(n3, n6, n5);
        }
    }

    public void completeArea(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n > n3) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n2 > n4) {
            n6 = n2;
            n = n4;
            n4 = n6;
        }
        for (n6 = n; n6 <= n3; ++n6) {
            for (int i = n2; i <= n4; ++i) {
                if (this.getTile(n6, i) != 0) continue;
                this.setTile(n6, i, n5);
            }
        }
    }

    public boolean completeTile(int n, int n2, int n3) {
        if (this.getTile(n, n2) == 0) {
            this.setTile(n, n2, n3);
            return true;
        }
        return false;
    }

    public void makeRandomPath(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        while (n != n3 || n2 != n4) {
            int n10;
            int n11;
            this.setTile(n, n2, n9);
            if (RPG.d(3) == 1) {
                n11 = RPG.sign(n3 - n);
                n10 = RPG.sign(n4 - n2);
            } else {
                n11 = RPG.r(3) - 1;
                n10 = RPG.r(3) - 1;
            }
            switch (RPG.d(bl ? 3 : 2)) {
                case 1: {
                    n11 = 0;
                    break;
                }
                case 2: {
                    n10 = 0;
                }
            }
            n += n11;
            n2 += n10;
            n = RPG.middle(n5, n, n7);
            n2 = RPG.middle(n6, n2, n8);
        }
        this.setTile(n3, n4, n9);
    }

    public Point findClearTile() {
        for (int i = 0; i < this.width * this.height; ++i) {
            int n;
            int n2 = RPG.r(this.width);
            if (!this.isClear(n2, n = RPG.r(this.height))) continue;
            return new Point(n2, n);
        }
        return null;
    }

    public Point findTile(int n) {
        n &= 0xFFFF;
        for (int i = 0; i < 10 * this.width * this.height; ++i) {
            int n2;
            int n3 = RPG.r(this.width);
            if ((this.getTile(n3, n2 = RPG.r(this.height)) & 0xFFFF) != n) continue;
            return new Point(n3, n2);
        }
        return null;
    }

    public Thing find(String string) {
        return this.find(string, 0, 0, this.width - 1, this.height - 1);
    }

    public Thing find(String string, int n, int n2, int n3, int n4) {
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                Thing thing = this.objects[j + i * this.width];
                while (thing != null) {
                    if (thing.name().equals(string)) {
                        return thing;
                    }
                    thing = thing.next;
                }
            }
        }
        return null;
    }

    public Point findFreeArea(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = n2;
        int n9 = (n3 - n) * (n4 - n2);
        if (n9 > 0) {
            n7 = RPG.rspread(n, n3 - n5 + 1);
            n8 = RPG.rspread(n2, n4 - n6 + 1);
            for (int i = n7; i < n7 + n5; ++i) {
                for (int j = n8; j < n8 + n6; ++j) {
                    if (this.isClear(i, j)) continue;
                }
            }
            return new Point(n7, n8);
        }
        return null;
    }

    public Point findFreeSquare(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        for (n7 = 5 * (n3 - n + 2) * (n4 - n2 + 2); n7 > 0; --n7) {
            n6 = RPG.rspread(n, n3);
            int n8 = this.getTile(n6, n5 = RPG.rspread(n2, n4));
            if (n8 == 0 || this.getObjects(n6, n5) != null || !Tile.isPassable(n8)) continue;
            return new Point(n6, n5);
        }
        for (n7 = 2 * (n3 - n + 2) * (n4 - n2 + 2); n7 > 0; --n7) {
            n6 = RPG.rspread(n, n3);
            if (this.getTile(n6, n5 = RPG.rspread(n2, n4)) == 0 || this.isBlocked(n6, n5)) continue;
            return new Point(n6, n5);
        }
        return null;
    }

    public Point findFreeSquare() {
        return this.findFreeSquare(0, 0, this.width - 1, this.height - 1);
    }

    public Point findEdgeSquare(int n, int n2, int n3) {
        for (int i = 0; i < 10 * this.width * this.height; ++i) {
            int n4;
            int n5 = RPG.r(this.width - 2) + 1;
            if (this.getTile(n5, n4 = RPG.r(this.height - 2) + 1) == 0 || this.isBlocked(n5, n4) || this.getTile(n5 + n, n4 + n2) != n3) continue;
            return new Point(n5, n4);
        }
        return null;
    }

    public List findStuff(Thing thing, int n) {
        if (thing.place != this) {
            return null;
        }
        int n2 = thing.x;
        int n3 = thing.y;
        int n4 = Being.calcViewRange(thing);
        List list = new LinkedList();
        for (int i = 1; i <= n4; ++i) {
            int n5 = n2 - i;
            int n6 = n2 + i;
            int n7 = n3 - i;
            int n8 = n3 + i;
            for (int j = -i; j < i; ++j) {
                if (n8 < this.height && n2 + j < this.width && n2 + j >= 0) {
                    list = this.findStuffPoint(n2 + j + n8 * this.width, thing, n, list);
                }
                if (n7 >= 0 && n2 - j < this.width && n2 - j >= 0) {
                    list = this.findStuffPoint(n2 - j + n7 * this.width, thing, n, list);
                }
                if (n6 < this.width && n3 + j < this.height && n3 + j >= 0) {
                    list = this.findStuffPoint(n6 + (n3 + j) * this.width, thing, n, list);
                }
                if (n5 < 0 || n3 - j >= this.height || n3 - j < 0) continue;
                list = this.findStuffPoint(n5 + (n3 - j) * this.width, thing, n, list);
            }
        }
        return list;
    }

    public List findStuffPoint(int n, Thing thing, int n2, List list) {
        Thing thing2 = this.getMobileChecked(n);
        Thing thing3 = this.getFlaggedObject(n, "ValueBase");
        if ((n2 & 1) == 1 && thing2 != null && thing.canSee(thing2)) {
            list.add(new Point(thing2));
            return list;
        }
        if ((n2 & 2) == 2 && thing3 != null && thing.canSee(thing3)) {
            list.add(new Point(thing3));
            return list;
        }
        return list;
    }

    public Thing findNearestFoe(Thing thing) {
        if (thing.place != this) {
            return null;
        }
        int n = thing.x;
        int n2 = thing.y;
        int n3 = Being.calcViewRange(thing);
        for (int i = 1; i <= n3; ++i) {
            int n4 = n - i;
            int n5 = n + i;
            int n6 = n2 - i;
            int n7 = n2 + i;
            for (int j = -i; j < i; ++j) {
                Thing thing2;
                if (n7 < this.height && n + j < this.width && n + j >= 0 && (thing2 = this.getMobileChecked(n + j + n7 * this.width)) != null && thing.isHostile(thing2) && thing.canSee(thing2)) {
                    return thing2;
                }
                if (n6 >= 0 && n - j < this.width && n - j >= 0 && (thing2 = this.getMobileChecked(n - j + n6 * this.width)) != null && thing.isHostile(thing2) && thing.canSee(thing2)) {
                    return thing2;
                }
                if (n5 < this.width && n2 + j < this.height && n2 + j >= 0 && (thing2 = this.getMobileChecked(n5 + (n2 + j) * this.width)) != null && thing.isHostile(thing2) && thing.canSee(thing2)) {
                    return thing2;
                }
                if (n4 < 0 || n2 - j >= this.height || n2 - j < 0 || (thing2 = this.getMobileChecked(n4 + (n2 - j) * this.width)) == null || !thing.isHostile(thing2) || !thing.canSee(thing2)) continue;
                return thing2;
            }
        }
        return null;
    }

    public int getMoveCost(int n, int n2) {
        return Tile.getMoveCost(this.getTile(n, n2));
    }

    public final Thing addThing(Thing thing, int n, int n2) {
        if (thing == null) {
            return null;
        }
        if (thing.getFlag("IsSpell")) {
            Spell.castAtLocation(thing, null, this, n, n2);
            return null;
        }
        thing.remove();
        if (thing.getFlag("NoStack") && this.getNamedObject(n, n2, thing.getString("Name")) != null) {
            return null;
        }
        return this.addObject(thing, n, n2);
    }

    public final Thing addThingWithLevel(String string, int n, int n2, int n3) {
        Thing thing = null;
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            Thing thing2 = string2.charAt(0) == '[' ? Lib.createType(string2.substring(1, string2.length() - 1), n3) : Lib.create(string2, n3);
            thing = this.addThing(thing2, n, n2);
        }
        return thing;
    }

    public final Thing addThing(String string, int n, int n2) {
        return this.addThingWithLevel(string, n, n2, this.getLevel());
    }

    public final Thing addThing(String string, int n, int n2, int n3, int n4) {
        Thing thing = null;
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            thing = this.addThing(Lib.create(stringArray[i]), n, n2, n3, n4);
        }
        return thing;
    }

    public final Thing addThing(Thing thing) {
        return this.addThing(thing, 0, 0, this.width - 1, this.height - 1);
    }

    public final Thing addThing(Thing thing, int n, int n2, int n3, int n4) {
        Point point = this.findFreeSquare(n, n2, n3, n4);
        if (point != null) {
            return this.addThing(thing, point.x, point.y);
        }
        return this.addThing(thing, RPG.rspread(n, n3), RPG.rspread(n2, n4));
    }

    public final boolean addBlockingThing(Thing thing, int n, int n2) {
        return this.addBlockingThing(thing, n, n2, n, n2);
    }

    public final boolean addBlockingThing(Thing thing, int n, int n2, int n3, int n4) {
        Point point = this.findFreeSquare(n, n2, n3, n4);
        if (point == null) {
            return false;
        }
        this.addThing(thing, point.x, point.y);
        return true;
    }

    public void moveThing(Thing thing, int n, int n2) {
        this.addThing(thing, n, n2);
    }

    public void removeThing(Thing thing) {
        if (thing.place != this) {
            throw new Error("Thing in wrong place!");
        }
        int n = thing.x + thing.y * this.width;
        if (this.objects[n] == thing) {
            this.objects[n] = thing.next;
            thing.next = null;
            thing.place = null;
            return;
        }
        Thing thing2 = this.objects[n];
        while (thing2 != null) {
            if (thing2.next == thing) {
                thing2.next = thing.next;
                thing.next = null;
                thing.place = null;
                return;
            }
            thing2 = thing2.next;
        }
    }

    public final Map getMap() {
        return this;
    }

    public boolean isTransparent(int n, int n2) {
        int n3 = n + n2 * this.width;
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return false;
        }
        if ((this.tiles[n3] & 0x20000) == 0) {
            return false;
        }
        Thing thing = this.objects[n3];
        while (thing != null) {
            if (!thing.isTransparent()) {
                return false;
            }
            thing = thing.next;
        }
        return true;
    }

    public final boolean isValid(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.width && n2 < this.height;
    }

    public final boolean isLOS(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (!this.isValid(n, n2) || !this.isValid(n3, n4)) {
            return false;
        }
        int n8 = (n << 8) + 128;
        int n9 = (n2 << 8) + 128;
        int n10 = n3 - n;
        int n11 = n4 - n2;
        if (RPG.abs(n10) <= RPG.abs(n11)) {
            if (n11 == 0) {
                return true;
            }
            n7 = (n10 << 8) / RPG.abs(n11);
            n6 = RPG.sign(n11) << 8;
            n5 = RPG.abs(n11);
        } else {
            n7 = RPG.sign(n10) << 8;
            n6 = (n11 << 8) / RPG.abs(n10);
            n5 = RPG.abs(n10);
        }
        while (n5 > 0) {
            if ((n8 += n7) >> 8 == n3 && (n9 += n6) >> 8 == n4) {
                return true;
            }
            if (!this.isTransparent(n8 >> 8, n9 >> 8)) {
                return false;
            }
            --n5;
        }
        return true;
    }

    public void calcVisible(Thing thing, int n) {
        int n2;
        int n3;
        int n4 = thing.x;
        int n5 = thing.y;
        int n6 = 0;
        while (n6 < this.size) {
            int n7 = n6++;
            this.tiles[n7] = this.tiles[n7] & 0xEFDFFFFF;
        }
        this.setTileFull(n4, n5, this.getTileFull(n4, n5) | 0x10000000 | 0x40000);
        n6 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n3 = -26; n3 <= 26; ++n3) {
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            for (n2 = 1; n2 <= n && !((double)(n2 * n2) + (double)(n2 * n3) / 26.0 * ((double)(n2 * n3) / 26.0) > ((double)n + 0.5) * ((double)n + 0.5)); ++n2) {
                if (bl) {
                    n6 = n4 + n2;
                    n8 = (26 * n5 + n3 * n2 + 13) / 26;
                    n9 = this.getTileFull(n6, n8) | 0x10000000;
                    this.setTileFull(n6, n8, n9);
                    if (!this.isTransparent(n6, n8)) {
                        bl = false;
                    }
                }
                if (bl2) {
                    n6 = n4 - n2;
                    n8 = (26 * n5 + n3 * n2 + 13) / 26;
                    n9 = this.getTileFull(n6, n8) | 0x10000000;
                    this.setTileFull(n6, n8, n9);
                    if (!this.isTransparent(n6, n8)) {
                        bl2 = false;
                    }
                }
                if (bl3) {
                    n8 = n5 + n2;
                    n6 = (26 * n4 + n3 * n2 + 13) / 26;
                    n9 = this.getTileFull(n6, n8) | 0x10000000;
                    this.setTileFull(n6, n8, n9);
                    if (!this.isTransparent(n6, n8)) {
                        bl3 = false;
                    }
                }
                if (!bl4) continue;
                n8 = n5 - n2;
                n6 = (26 * n4 + n3 * n2 + 13) / 26;
                n9 = this.getTileFull(n6, n8) | 0x10000000;
                this.setTileFull(n6, n8, n9);
                if (this.isTransparent(n6, n8)) continue;
                bl4 = false;
            }
        }
        n3 = thing.getStat("IsBlind");
        n2 = thing.getStat("TrueView");
        for (int i = n4 - n; i <= n4 + n; ++i) {
            for (int j = n5 - n; j <= n5 + n; ++j) {
                if ((double)((i - n4) * (i - n4) + (j - n5) * (j - n5)) > ((double)n + 0.5) * ((double)n + 0.5)) continue;
                if (n2 > 0) {
                    this.setVisible(i, j);
                }
                if (n3 > 0 || (this.getTileFull(i, j) & 0x10000000) <= 0) continue;
                this.setVisible(i, j);
            }
        }
    }

    public void setAllVisible() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.setVisible(i, j);
            }
        }
    }

    public void setVisible(int n, int n2) {
        int n3 = n + n2 * this.width;
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        if ((this.tiles[n3] & 0x200000) == 0) {
            int n4 = n3;
            this.tiles[n4] = this.tiles[n4] | 0x240000;
            Thing thing = this.getMobile(n, n2);
            if (thing != null) {
                thing.notify(2, 0, null);
                if (thing.isHostile(Game.hero())) {
                    Game.hero().isRunning(false);
                }
            }
        }
    }

    public boolean isVisible(int n, int n2) {
        return (this.getTileFlags(n, n2) & 0x200000) > 0;
    }

    public boolean isHeroLOS(int n, int n2) {
        return (this.getTileFlags(n, n2) & 0x10000000) > 0;
    }

    public boolean isVisibleChecked(int n) {
        return (this.tiles[n] & 0x200000) > 0;
    }

    public boolean isDiscovered(int n, int n2) {
        return (this.getTileFlags(n, n2) & 0x40000) > 0;
    }

    public boolean isEmpty(int n, int n2) {
        return this.getObjects(n, n2) == null;
    }

    public boolean isClear(int n, int n2) {
        return this.isEmpty(n, n2) && !this.isBlocked(n, n2);
    }

    public Point tracePath(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 == 0 && n6 == 0) {
            return new Point(n, n2);
        }
        double d = Math.sqrt(n5 * n5 + n6 * n6);
        double d2 = (double)n5 / d;
        double d3 = (double)n6 / d;
        double d4 = (double)n + 0.5 + d2;
        double d5 = (double)n2 + 0.5 + d3;
        for (int i = 0; i < 100 && (int)d4 != n3 || (int)d5 != n4; ++i) {
            int n7 = (int)(d4 += d2);
            int n8 = (int)(d5 += d3);
            if ((this.getTileFull(n7, n8) & 0x10000) != 0) {
                return new Point((int)(d4 - d2), (int)(d5 - d3));
            }
            if (!this.isBlocked(n7, n8)) continue;
            return new Point(n7, n8);
        }
        return new Point(n3, n4);
    }

    public boolean isBlocked(int n, int n2) {
        if (this.isTileBlocked(n, n2)) {
            return true;
        }
        Thing thing = this.objects[n + n2 * this.width];
        while (thing != null) {
            if (thing.isBlocking()) {
                return true;
            }
            thing = thing.next;
        }
        return false;
    }

    public final boolean isTileBlocked(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return true;
        }
        return (this.tiles[n + n2 * this.width] & 0x10000) != 0;
    }

    public boolean isObjectBlocked(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return true;
        }
        int n3 = n + n2 * this.width;
        Thing thing = this.objects[n3];
        while (thing != null) {
            if (thing.isBlocking()) {
                return true;
            }
            thing = thing.next;
        }
        return false;
    }

    public final boolean isTileAdjacent(int n, int n2, int n3) {
        if (this.getTile(n - 1, n2) == n3) {
            return true;
        }
        if (this.getTile(n + 1, n2) == n3) {
            return true;
        }
        if (this.getTile(n, n2 - 1) == n3) {
            return true;
        }
        return this.getTile(n, n2 + 1) == n3;
    }

    public int getPath(int n, int n2) {
        if (this.path == null) {
            this.path = new int[this.size];
        }
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return -1;
        }
        return this.path[n + n2 * this.width];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Game getGame() {
        return this.game;
    }

    public final int getTile(int n, int n2) {
        int n3 = n + this.width * n2;
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        return this.tiles[n3] & 0xFFFF;
    }

    protected final int getTileFull(int n, int n2) {
        int n3 = n + this.width * n2;
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 65536;
        }
        return this.tiles[n3];
    }

    public final int getTileFlags(int n, int n2) {
        int n3 = n + this.width * n2;
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 65536;
        }
        return this.tiles[n3] & 0xFFFF0000;
    }

    public Thing getObjects(int n, int n2) {
        int n3 = n + this.width * n2;
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return null;
        }
        return this.objects[n3];
    }

    public Thing getObjectsChecked(int n) {
        return this.objects[n];
    }

    public Thing getFlaggedObject(int n, int n2, String string) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return null;
        }
        int n3 = n + this.width * n2;
        return this.getFlaggedObject(n3, string);
    }

    public Thing getFlaggedObject(int n, String string) {
        Thing thing = this.objects[n];
        while (thing != null) {
            if (thing.getFlag(string)) {
                return thing;
            }
            thing = thing.next;
        }
        return null;
    }

    public Thing getNamedObject(int n, int n2, String string) {
        int n3 = n + this.width * n2;
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return null;
        }
        Thing thing = this.objects[n3];
        while (thing != null) {
            if (string.equals(thing.get("Name"))) {
                return thing;
            }
            thing = thing.next;
        }
        return null;
    }

    private final Thing addObject(Thing thing, int n, int n2) {
        if (thing == null) {
            return null;
        }
        if (n >= this.width || n < 0) {
            return null;
        }
        if (n2 >= this.height || n2 < 0) {
            return null;
        }
        Thing thing2 = this.objects[n + n2 * this.width];
        if (thing.getFlag("IsItem")) {
            Thing thing3 = thing2;
            while (thing3 != null) {
                if (thing.stackWith(thing3)) {
                    return thing3;
                }
                thing3 = thing3.next;
            }
        }
        thing.next = this.objects[n + n2 * this.width];
        this.objects[n + n2 * this.width] = thing;
        thing.place = this;
        thing.x = n;
        thing.y = n2;
        return thing;
    }

    public final void setTile(int n, int n2, int n3) {
        int n4 = n + n2 * this.width;
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        this.tiles[n4] = n3 | Tile.getMask(n3);
    }

    public final void setTileFull(int n, int n2, int n3) {
        int n4 = n + n2 * this.width;
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        this.tiles[n4] = n3;
    }

    public Thing getMobile(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return null;
        }
        int n3 = n + n2 * this.width;
        Thing thing = this.objects[n3];
        while (thing != null) {
            if (thing.isMobile()) {
                return thing;
            }
            thing = thing.next;
        }
        return null;
    }

    public Thing getMobileChecked(int n) {
        Thing thing = this.objects[n];
        while (thing != null) {
            if (thing.isMobile()) {
                return thing;
            }
            thing = thing.next;
        }
        return null;
    }

    public int countNearby(String string, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n - n3; i <= n + n3; ++i) {
            for (int j = n2 - n3; j <= n2 + n3; ++j) {
                if (this.getFlaggedObject(i, j, string) == null) continue;
                ++n4;
            }
        }
        return n4;
    }

    public Thing getNearby(String string, int n, int n2, int n3) {
        for (int i = n - n3; i <= n + n3; ++i) {
            for (int j = n2 - n3; j <= n2 + n3; ++j) {
                Thing thing;
                if (i == n && j == n2 || (thing = this.getFlaggedObject(i, j, string)) == null) continue;
                return thing;
            }
        }
        return this.getFlaggedObject(n, n2, string);
    }

    public void areaDamage(int n, int n2, int n3, int n4, String string) {
        int n5 = 0;
        n5 = 0;
        while (n5 * n5 <= n3) {
            ++n5;
        }
        Thing[] thingArray = this.getThings(n - --n5, n2 - n5, n + n5, n2 + n5);
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing = thingArray[i];
            if ((thing.x - n) * (thing.x - n) + (thing.y - n2) * (thing.y - n2) > n3) continue;
            Damage.inflict(thing, RPG.a(n4), string);
        }
    }

    public void areaDamage(int n, int n2, int n3, String string) {
        Thing[] thingArray = this.getThings(n, n2);
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing = thingArray[i];
            if (!thing.getFlag("IsPhysical")) continue;
            Damage.inflict(thing, RPG.a(n3), string);
        }
    }

    public void areaNotify(int n, int n2, int n3, int n4, int n5, Object object) {
        for (int i = n - n3; i <= n + n3; ++i) {
            for (int j = n2 - n3; j <= n2 + n3; ++j) {
                Thing thing = this.getMobile(i, j);
                if (thing == null) continue;
                thing.notify(n4, n5, object);
            }
        }
    }

    public Thing sortZ(int n, int n2) {
        Thing thing = this.objects[n + n2 * this.width];
        if (thing == null) {
            return null;
        }
        Thing thing2 = this.sortZGetFirst(thing);
        this.objects[n + n2 * this.width] = thing2;
        return thing2;
    }

    private Thing sortZGetFirst(Thing thing) {
        if (thing.next == null) {
            return thing;
        }
        thing.next = this.sortZGetFirst(thing.next);
        if (thing.getZ() <= thing.next.getZ()) {
            return thing;
        }
        Thing thing2 = thing.next;
        thing.next = thing2.next;
        thing2.next = this.sortZGetFirst(thing);
        return thing2;
    }

    public Thing[] getThings() {
        return this.getThings(0, 0, this.width - 1, this.height - 1);
    }

    public Thing[] getThings(int n, int n2) {
        return this.getThings(n, n2, n, n2);
    }

    public Thing[] getObjects(int n, int n2, int n3, int n4, String string) {
        int n5;
        if (n < 0) {
            n = 0;
        }
        if (n3 >= this.width) {
            n3 = this.width - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 >= this.height) {
            n4 = this.height - 1;
        }
        int n6 = 0;
        for (int i = n2; i <= n4; ++i) {
            for (n5 = n; n5 <= n3; ++n5) {
                Thing thing = this.objects[n5 + i * this.width];
                while (thing != null) {
                    if (thing.getFlag(string)) {
                        ++n6;
                    }
                    thing = thing.next;
                }
            }
        }
        if (n6 == 0) {
            return emptyThings;
        }
        Thing[] thingArray = new Thing[n6];
        n6 = 0;
        for (n5 = n2; n5 <= n4; ++n5) {
            for (int i = n; i <= n3; ++i) {
                Thing thing = this.objects[i + n5 * this.width];
                while (thing != null) {
                    if (thing.getFlag(string)) {
                        thingArray[n6] = thing;
                        ++n6;
                    }
                    thing = thing.next;
                }
            }
        }
        return thingArray;
    }

    public Thing[] getThings(int n, int n2, int n3, int n4) {
        int n5;
        if (n < 0) {
            n = 0;
        }
        if (n3 >= this.width) {
            n3 = this.width - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 >= this.height) {
            n4 = this.height - 1;
        }
        int n6 = 0;
        for (int i = n2; i <= n4; ++i) {
            for (n5 = n; n5 <= n3; ++n5) {
                Thing thing = this.objects[n5 + i * this.width];
                while (thing != null) {
                    ++n6;
                    thing = thing.next;
                }
            }
        }
        if (n6 == 0) {
            return emptyThings;
        }
        Thing[] thingArray = new Thing[n6];
        n6 = 0;
        for (n5 = n2; n5 <= n4; ++n5) {
            for (int i = n; i <= n3; ++i) {
                Thing thing = this.objects[i + n5 * this.width];
                while (thing != null) {
                    thingArray[n6] = thing;
                    ++n6;
                    thing = thing.next;
                }
            }
        }
        return thingArray;
    }

    public void action(Event event) {
        int n;
        Game.instance().addMapObjects(this);
        Thing[] thingArray = this.getThings();
        int n2 = event.getStat("Time");
        Script script = (Script)this.get("OnAction");
        if (script != null && script.handle(null, event)) {
            return;
        }
        for (n = 0; n < thingArray.length; ++n) {
            Thing thing = thingArray[n];
            if (thing.place != this) continue;
            thing.action(event);
        }
        for (n = 0; n < this.height; ++n) {
            for (int i = 0; i < this.width; ++i) {
                if ((this.tiles[i + n * this.width] & 0x8000000) <= 0) continue;
                Tile.action(this, i, n, n2);
            }
        }
        n = this.getStat("WanderingRate");
        if (RPG.test(n * n2, 1000000)) {
            Dungeon.addWandering(this);
        }
    }

    public Thing[] getPortals(int n, int n2) {
        return this.getObjects(n, n2, n, n2, "IsPortal");
    }

    public ArrayList getAllPortals() {
        Thing thing;
        ArrayList<Thing> arrayList = new ArrayList<Thing>();
        Thing[] thingArray = this.getObjects(0, 0, this.width - 1, this.height - 1, "IsPortal");
        for (int i = 0; i < thingArray.length; ++i) {
            arrayList.add(thingArray[i]);
        }
        Thing thing2 = this.getEntrance();
        if (thing2 != null && !arrayList.contains(thing2)) {
            arrayList.add(thing2);
        }
        if ((thing = this.getExit()) != null && !arrayList.contains(thing)) {
            arrayList.add(thing);
        }
        return arrayList;
    }

    public void exitMap(int n, int n2) {
        if (this.getFlag("IsWorldMap")) {
            WorldMap.exitWorldMap(this, n, n2);
        } else {
            Thing thing = Game.hero();
            Thing thing2 = null;
            Thing[] thingArray = this.getPortals(n, n2);
            if (thingArray.length == 1) {
                thing2 = thingArray[0];
            } else if (thingArray.length > 1) {
                thing2 = Game.selectItem("Select a route:", thingArray);
            }
            if (thing2 == null && this.canExit()) {
                thing2 = this.getEntrance();
            }
            if (thing2 != null) {
                Portal.travel(thing2, thing);
            }
        }
    }

    public String getEnterMessage() {
        String string = this.getString("EnterMessageFirst");
        if (string != null) {
            this.set("EnterMessageFirst", null);
        } else {
            string = this.getString("EnterMessage");
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getDescription() {
        int n;
        String string = this.getString("Description");
        if (string == null) {
            string = "Unknown area";
            Game.warn("No map Description!");
        }
        if ((n = this.getStat("DungeonLevel")) > 0) {
            string = string + " Lv. " + n;
        }
        return string;
    }

    public void setEntrance(Thing thing) {
        this.setPortal("entrance", thing);
    }

    public Thing addEntrance(String string) {
        return this.addEntrance(Portal.create(string));
    }

    public Thing addEntrance(Thing thing) {
        this.addThing(thing);
        this.setEntrance(thing);
        return thing;
    }

    public Thing getEntrance() {
        return this.getPortal("entrance");
    }

    public void setPortal(String string, Thing thing) {
        this.set("Portal:" + string, thing);
        if (thing != null) {
            thing.set("PortalName", string);
        }
    }

    public Thing getPortal(String string) {
        return this.getThing("Portal:" + string);
    }

    public void setExit(Thing thing) {
        this.setPortal("exit", thing);
    }

    public Thing getExit() {
        return this.getPortal("exit");
    }

    public String getTileXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tiles>\n");
        for (int i = 0; i < this.height; ++i) {
            stringBuffer.append("<row>");
            for (int j = 0; j < this.width; ++j) {
                String string = Text.leftPad(Integer.toString(this.getTile(j, i) & 0xFFFF), 4);
                stringBuffer.append(string + " ");
            }
            stringBuffer.append("</row>\n");
        }
        stringBuffer.append("</tiles>\n");
        return stringBuffer.toString();
    }

    public String getLevelXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<map width=\"" + this.width + "\" height=\"" + this.height + "\">");
        stringBuffer.append(this.getTileXML());
        stringBuffer.append("</map>");
        return stringBuffer.toString();
    }

    public String toString() {
        return new MapHelper().mapToString(this);
    }

    public String name() {
        return this.getString("HashName");
    }

    public void visitPath(int n, int n2) {
        if (this.path == null) {
            this.path = new int[this.size];
        }
        this.path[n + n2 * this.width] = 1;
    }

    public int[] getTiles() {
        return this.tiles;
    }

    public void setTiles(int[] nArray) {
        this.tiles = nArray;
    }

    public Thing[] getObjects() {
        return this.objects;
    }

    public void setObjects(Thing[] thingArray) {
        this.objects = thingArray;
    }
}

