/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.io.Serializable;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public final class Point
implements Serializable {
    private static final long serialVersionUID = 3256720701829165623L;
    public int x = 0;
    public int y = 0;

    public Point() {
    }

    public Point(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point(Thing thing) {
        this.x = thing.x;
        this.y = thing.y;
    }

    public int hvDistance(Point point) {
        return RPG.max(RPG.abs(this.x - point.x), RPG.abs(this.y - point.y));
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public void offset(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public String toString() {
        return this.x + "@" + this.y;
    }

    public static Point randomDirection(boolean bl) {
        if (!bl) {
            return Point.randomDirection4();
        }
        return Point.randomDirection8();
    }

    public static Point randomDirection4() {
        int n = 0;
        int n2 = 0;
        switch (RPG.d(4)) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = -1;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = -1;
            }
        }
        return new Point(n, n2);
    }

    public static Point randomDirection8() {
        int n = 0;
        int n2 = 0;
        switch (RPG.d(8)) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = -1;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = -1;
                break;
            }
            case 5: {
                n = 1;
                n2 = 1;
                break;
            }
            case 6: {
                n = -1;
                n2 = -1;
                break;
            }
            case 7: {
                n2 = 1;
                n = -1;
                break;
            }
            case 8: {
                n2 = -1;
                n = 1;
            }
        }
        return new Point(n, n2);
    }

    public boolean equals(Object object) {
        if (object instanceof Point) {
            Point point = (Point)object;
            return this.x == point.x && this.y == point.y;
        }
        return super.equals(object);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        return (int)(l ^= Double.doubleToLongBits(this.y) * 31L) ^ (int)(l >> 32);
    }
}

