/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.Random;
import mikera.tyrant.Describer;
import mikera.tyrant.Description;
import mikera.tyrant.Game;
import mikera.tyrant.Thing;

public class RPG {
    public static final String DT_SPECIAL = "special";
    public static final String DT_NORMAL = "normal";
    public static final String DT_UNARMED = "unarmed";
    public static final String DT_FIRE = "fire";
    public static final String DT_ICE = "ice";
    public static final String DT_WATER = "water";
    public static final String DT_PIERCING = "piercing";
    public static final String DT_ACID = "acid";
    public static final String DT_SHOCK = "shock";
    public static final String DT_MAGIC = "magic";
    public static final String DT_IMPACT = "impact";
    public static final String DT_CHILL = "chill";
    public static final String DT_POISON = "poison";
    public static final String DT_DRAIN = "drain";
    public static final String DT_DISPELL = "dispell";
    public static final String DT_DISINTEGRATE = "disintegrate";
    public static final int WT_ERROR = -1;
    public static final int WT_NONE = 0;
    public static final int WT_MAINHAND = 1;
    public static final int WT_SECONDHAND = 2;
    public static final int WT_TWOHANDS = 3;
    public static final int WT_RIGHTRING = 4;
    public static final int WT_LEFTRING = 5;
    public static final int WT_NECK = 6;
    public static final int WT_HANDS = 7;
    public static final int WT_BOOTS = 8;
    public static final int WT_TORSO = 9;
    public static final int WT_LEGS = 10;
    public static final int WT_HEAD = 11;
    public static final int WT_CLOAK = 12;
    public static final int WT_FULLBODY = 13;
    public static final int WT_BRACERS = 14;
    public static final int WT_BELT = 15;
    public static final int WT_RANGEDWEAPON = 20;
    public static final int WT_MISSILE = 21;
    public static final int WT_BOOKBAG = 70;
    public static final int WT_FOODSACK = 71;
    public static final int WT_HOLDING = 72;
    public static final int WT_INGREDIENTPOUCH = 73;
    public static final int WT_JEWELRYCASE = 74;
    public static final int WT_KEYRING = 75;
    public static final int WT_POTIONCASE = 76;
    public static final int WT_QUIVER = 77;
    public static final int WT_RUNEBAG = 78;
    public static final int WT_SCROLLCASE = 79;
    public static final int WT_WANDCASE = 80;
    public static final int[] WT_BAGS = new int[]{70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80};
    public static final int WT_EFFECT = 100;
    public static final int ST_STATE = 0;
    public static final String ST_SK = "SK";
    public static final String ST_ST = "ST";
    public static final String ST_AG = "AG";
    public static final String ST_TG = "TG";
    public static final String ST_IN = "IN";
    public static final String ST_WP = "WP";
    public static final String ST_CH = "CH";
    public static final String ST_CR = "CR";
    public static final String ST_LEVEL = "Level";
    public static final String ST_EXP = "Experience";
    public static final String ST_FATE = "FatePoints";
    public static final String ST_FAME = "Fame";
    public static final String ST_HUNGER = "Hunger";
    public static final String ST_HUNGERTHRESHOLD = "HungerThreshold";
    public static final String ST_SKILLPOINTS = "SkillPoints";
    public static final String ST_SKILLPOINTSSPENT = "SkillPointsSpent";
    public static final int ST_RANGER = 21;
    public static final int ST_FIGHTER = 22;
    public static final int ST_THIEF = 23;
    public static final int ST_PRIEST = 24;
    public static final int ST_SCHOLAR = 25;
    public static final int ST_MAGE = 26;
    public static final int ST_BARD = 27;
    public static final int ST_ARTISAN = 28;
    public static final String ST_ENCUMBERANCE = "Encumberance";
    public static final String ST_ALIGNMENT = "Alignment";
    public static final String ST_ORDER = "Order";
    public static final String ST_SPEED = "Speed";
    public static final String ST_MOVESPEED = "MoveSpeed";
    public static final String ST_ATTACKSPEED = "AttackSpeed";
    public static final String ST_MAGICSPEED = "CastSpeed";
    public static final String ST_MOVECOST = "MoveCost";
    public static final String ST_ATTACKCOST = "AttackCost";
    public static final int ST_ETHEREAL = 3001;
    public static final String ST_UNDEAD = "IsUndead";
    public static final String ST_FEARFACTOR = "FearFactor";
    public static final String ST_APS = "APS";
    public static final String ST_HPS = "HPS";
    public static final String ST_HPSMAX = "HPSMAX";
    public static final String ST_MPS = "MPS";
    public static final String ST_MPSMAX = "MPSMAX";
    public static final String ST_ASK = "ASK";
    public static final String ST_ASKMULTIPLIER = "ASKMul";
    public static final String ST_ASKBONUS = "ASKBonus";
    public static final String ST_AST = "AST";
    public static final String ST_ASTMULTIPLIER = "ASTMul";
    public static final String ST_ASTBONUS = "ASTBonus";
    public static final String ST_DSK = "DSK";
    public static final String ST_DSKMULTIPLIER = "DSKMul";
    public static final String ST_DSKBONUS = "DSKBonus";
    public static final int ST_DODGEMULTIPLIER = 10040;
    public static final int ST_DSKPARRY = 10041;
    public static final String ST_REGENERATE = "RegenerationRate";
    public static final String ST_RECHARGE = "RechargeRate";
    public static final String ST_RSKBONUS = "RSKBonus";
    public static final String ST_RSKMULTIPLIER = "RSKMul";
    public static final String ST_RSTBONUS = "RSTBonus";
    public static final String ST_RSTMULTIPLIER = "RSTMul";
    public static final String ST_RANGE = "Range";
    public static final String ST_ANTIMAGIC = "AntiMagic";
    public static final String ST_SCORE = "Score";
    public static final String ST_SCORE_BESTKILL = "BestKillLevel";
    public static final String ST_SCORE_BESTLEVEL = "BestLevel";
    public static final String ST_SCORE_KILLS = "KillCount";
    public static final String ST_FREQUENCY = "Frequency";
    public static final String ST_ITEMVALUE = "Value";
    public static final String ST_MISSILETYPE = "MissileType";
    public static final String ST_AIMODE = "AIMode";
    public static final String ST_TARGETX = "TargetX";
    public static final String ST_TARGETY = "TargetY";
    public static final String ST_CASTCHANCE = "CastChance";
    public static final String ST_SIDE = "Side";
    public static final int ST_QUESTNUMBER = 31000;
    public static final int ST_QUESTSTATE = 31001;
    public static final int ST_IMMOBILIZED = 32001;
    public static final String ST_CONFUSED = "IsConfused";
    public static final String ST_BLIND = "IsBlind";
    public static final String ST_PANICKED = "IsPanicked";
    public static final int ST_NON_DISPLACEABLE = 32005;
    public static final String ST_TRUEVIEW = "TrueView";
    public static final int MF_EDIBLE = 65536;
    public static final int MF_MAGICAL = 131072;
    public static final int MF_RESISTANT = 262144;
    public static final int MF_LIVING = 524288;
    public static final int MF_DIVINE = 0x100000;
    public static final int MF_SKIN = 0x200000;
    public static final int MF_STONE = 0x400000;
    public static final int MF_GLASS = 0x800000;
    public static final int MF_GEMSTONE = 0x1000000;
    public static final int MF_METAL = 0x2000000;
    public static final int MF_PLANT = 0x4000000;
    public static final int MF_CLOTH = 0x8000000;
    public static final int MF_INDESTRUCTIBLE = 0x10000000;
    public static final int MF_LIQUID = 0x20000000;
    public static final int MF_GASEOUS = 0x40000000;
    public static final int MF_ETHEREAL = Integer.MIN_VALUE;
    public static final int MF_PLASTIC = 0;
    public static final int MISSILE_THROWN = 0;
    public static final int MISSILE_ARROW = 1;
    public static final int MISSILE_BOLT = 2;
    public static final int MISSILE_STONE = 3;
    public static final Description DESC_GENERIC = new Describer("thing", "A generic thing. Don't ask.");
    public static final int[] POWER = new int[]{2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 11, 13, 14, 16, 18, 20, 22, 25, 28, 32, 36, 40, 45, 51, 57, 64, 72, 81, 91, 102, 114, 128, 144, 161, 181, 203, 228, 256, 287, 323, 362, 406, 456, 512, 575, 645, 724, 813, 912, 1024, 1149, 1290, 1448, 1625, 1825, 2048, 2299, 2580, 2896, 3251, 3649, 4096};
    private static Random rand = new Random();
    public static final int Z_ELSEWHERE = -10;
    public static final String[] stats = new String[]{"SK", "ST", "AG", "TG", "IN", "WP", "CH", "CR"};

    public static float random() {
        return rand.nextFloat();
    }

    public static float luckRandom(Thing thing, Thing thing2) {
        int n = 0;
        if (thing != null) {
            n += thing.getStat("Luck");
        }
        if (thing2 != null) {
            n -= thing2.getStat("Luck");
        }
        return RPG.luckRandom(n);
    }

    public static float luckRandom(int n) {
        float f;
        int n2;
        float f2 = rand.nextFloat();
        if (n > 0) {
            for (n2 = RPG.r(100); n2 < n; n2 += 100) {
                f = RPG.random();
                if (!(f < f2)) continue;
                f2 = f;
            }
        }
        if (n < 0) {
            n = -n;
            for (n2 = RPG.r(100); n2 < n; n2 += 100) {
                f = RPG.random();
                if (!(f > f2)) continue;
                f2 = f;
            }
        }
        return f2;
    }

    public static boolean test(int n, int n2) {
        if (n <= 0) {
            return false;
        }
        if (n2 <= 0) {
            return true;
        }
        return rand.nextInt(n + n2) < n;
    }

    public static boolean test(int n, int n2, Thing thing, Thing thing2) {
        int n3 = 0;
        if (thing != null) {
            n3 += thing.getStat("Luck");
        }
        if (thing2 != null) {
            n3 -= thing2.getStat("Luck");
        }
        return RPG.test(n, n2, n3);
    }

    public static boolean test(int n, int n2, int n3) {
        if (n <= 0) {
            return false;
        }
        if (n2 <= 0) {
            return true;
        }
        return RPG.luckRandom(n3) * (float)(n + n2) < (float)n;
    }

    public static int hitFactor(int n, int n2, Thing thing, Thing thing2) {
        int n3 = 0;
        while (RPG.test(n, RPG.max(1, n2), thing, thing2)) {
            ++n3;
            n /= 2;
        }
        return n3;
    }

    public static int power(int n) {
        if (n < 0 || n > 66) {
            return (int)Math.pow(2.0, 1.0 + (double)n / 6.0);
        }
        return POWER[n];
    }

    public static int level(int n) {
        if (n < 1) {
            return -1000000;
        }
        if (n == 1) {
            return -6;
        }
        if (n > 66) {
            return (int)Math.round(Math.log(n) * 8.656170245 - 6.0);
        }
        int n2 = 0;
        while (POWER[n2] < n) {
            ++n2;
        }
        return n2;
    }

    public static void setRandSeed(long l) {
        rand.setSeed(l);
    }

    public static final int d(int n) {
        if (n <= 0) {
            return 0;
        }
        return rand.nextInt(n) + 1;
    }

    public static final int distSquared(int n, int n2, int n3, int n4) {
        return (n - n3) * (n - n3) + (n2 - n4) * (n2 - n4);
    }

    public static final double dist(int n, int n2, int n3, int n4) {
        return Math.sqrt((n - n3) * (n - n3)) + (double)((n2 - n4) * (n2 - n4));
    }

    public static final int radius(int n) {
        int n2 = 0;
        while (n2 * n2 <= n) {
            ++n2;
        }
        return n2 - 1;
    }

    public static final int pick(int[] nArray) {
        return nArray[RPG.r(nArray.length)];
    }

    public static final String pick(String[] stringArray) {
        return stringArray[RPG.r(stringArray.length)];
    }

    public static final char pick(String string) {
        return string.charAt(RPG.r(string.length()));
    }

    public static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final int middle(int n, int n2, int n3) {
        if (n > n2) {
            if (n2 > n3) {
                return n2;
            }
            if (n > n3) {
                return n3;
            }
            return n;
        }
        if (n > n3) {
            return n;
        }
        if (n2 > n3) {
            return n3;
        }
        return n2;
    }

    public static final int niceNumber(int n) {
        int n2 = 1;
        while (n >= 100) {
            n /= 10;
            n2 *= 10;
        }
        if (n > 30) {
            n = 5 * (n / 5);
        }
        return n * n2;
    }

    public static int e(int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = 0;
        while (rand.nextInt() % (n + 1) != 0) {
            ++n2;
        }
        return n2;
    }

    public static int ln(double d) {
        return RPG.ln(d, 1.0);
    }

    public static int ln(double d, double d2) {
        double d3 = rand.nextGaussian();
        return (int)Math.round(d * Math.exp(d3 *= d2));
    }

    public static int po(double d) {
        int n = 0;
        double d2 = rand.nextDouble();
        if (d2 >= 0.99999999) {
            return 0;
        }
        double d3 = Math.exp(-d);
        while (d2 >= d3) {
            d2 -= d3;
            d3 = d3 * d / (double)(++n);
        }
        return n;
    }

    public static int po(int n, int n2) {
        return RPG.po((double)n / (double)n2);
    }

    public static boolean sometimes() {
        return (double)rand.nextFloat() < 0.1;
    }

    public static boolean often() {
        return (double)rand.nextFloat() < 0.4;
    }

    public static boolean rarely() {
        return (double)rand.nextFloat() < 0.01;
    }

    public static boolean usually() {
        return (double)rand.nextFloat() < 0.8;
    }

    public static int rspread(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        return rand.nextInt(n2 - n + 1) + n;
    }

    public static final int sign(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static final int sign(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public static final int abs(int n) {
        return n >= 0 ? n : -n;
    }

    public static final int r(int n) {
        if (n <= 0) {
            return 0;
        }
        return rand.nextInt(n);
    }

    public static final int r(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = n4 - n3;
        Game.assertTrue(n5 >= 0);
        int n6 = n3 + rand.nextInt(n5 + 1);
        Game.assertTrue(n6 <= n4);
        return n6;
    }

    public static boolean p(double d) {
        Game.assertTrue(d >= 0.0);
        Game.assertTrue(d <= 1.0);
        if (d == 0.0) {
            return false;
        }
        return rand.nextDouble() <= d;
    }

    public static final int round(double d) {
        int n = (int)d;
        if (rand.nextDouble() < d - (double)n) {
            ++n;
        }
        return n;
    }

    public static final int a(int n) {
        return RPG.r(n + 1) + RPG.r(n + 1);
    }

    public static final int d3() {
        return RPG.d(3);
    }

    public static final int d4() {
        return RPG.d(4);
    }

    public static final int d6() {
        return RPG.d(6);
    }

    public static final int d8() {
        return RPG.d(8);
    }

    public static final int d10() {
        return RPG.d(10);
    }

    public static final int d12() {
        return RPG.d(12);
    }

    public static final int d20() {
        return RPG.d(20);
    }

    public static final int d100() {
        return RPG.d(100);
    }

    public static int best(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n2 <= 0 || n < 0 || n > n2 || n3 < 0) {
            return 0;
        }
        int[] nArray = new int[n2];
        for (n6 = 0; n6 < n2; ++n6) {
            nArray[n6] = RPG.d(n3);
        }
        do {
            n6 = 0;
            for (n5 = 0; n5 < n2 - 1; ++n5) {
                if (nArray[n5] >= nArray[n5 + 1]) continue;
                n4 = nArray[n5];
                nArray[n5] = nArray[n5 + 1];
                nArray[n5 + 1] = n4;
                n6 = 1;
            }
        } while (n6 != 0);
        n5 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            n5 += nArray[n4];
        }
        return n5;
    }

    public static int d(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 += RPG.d(n2);
        }
        return n3;
    }

    public static final int index(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int index(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int percentile(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = n * 100 / n2;
        if (n > 0 && n3 == 0) {
            n3 = 1;
        }
        return n3;
    }

    public static Object[] subList(Object[] objectArray, Class clazz) {
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!clazz.isInstance(object)) continue;
            objectArray2[n] = object;
            ++n;
        }
        Object[] objectArray3 = new Object[n];
        if (n > 0) {
            System.arraycopy(objectArray2, 0, objectArray3, 0, n);
        }
        return objectArray3;
    }
}

