/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.RPG;
import mikera.tyrant.Recipe;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;

public class Rune {
    protected static final String[] runes = new String[]{"Ait", "Ber", "Ciz", "Dar", "Erg", "Futh", "Gu", "Hok", "Ik", "Jos", "Kaz", "Llam", "Mon", "Ni", "Om", "Puk", "Qor", "Rux", "Si", "Tux", "Uth", "Vorg", "Wei", "Xu", "Yrg", "Zyk"};

    public static void init() {
        Thing thing = Lib.extend("base runestone", "base item");
        thing.set("ItemWeight", 50);
        thing.set("IsRunestone", 1);
        thing.set("ValueBase", 100);
        thing.set("LevelMin", 1);
        thing.set("IsRune", 1);
        thing.set("HPS", 3);
        thing.set("Image", 500);
        thing.set("Frequency", 50);
        thing.set("OnUse", new RuneUseScript());
        thing.set("IsRuneIngredient", 1);
        thing.set("ASCII", "~");
        Lib.add(thing);
        thing = Lib.extend("base rune", "base thing");
        thing.set("IsRune", 1);
        thing.set("IsAlteration", 1);
        thing.set("NoStack", 1);
        thing.set("LevelMin", 1);
        thing.add("CarriedModifiers", Modifier.constant("IsRunic", 1));
        Lib.add(thing);
        thing = Lib.extend("blank runestone", "base runestone");
        thing.set("IsRuneIngredient", 0);
        thing.set("OnUse", new RuneScribeScript());
        Lib.add(thing);
        Rune.initRuneStones();
        Rune.initWeaponRunes();
        Rune.initArmourRunes();
        Rune.initItemRunes();
        Rune.initShieldRunes();
        Rune.initMissileRunes();
    }

    private static void addRuneStone(Thing thing) {
        Lib.add(thing);
    }

    public static String runeStoneName(int n) {
        return runes[n] + " runestone";
    }

    private static void initRuneStones() {
        for (int i = 0; i < runes.length; ++i) {
            Thing thing = Lib.extend(Rune.runeStoneName(i), "base runestone");
            thing.set("UName", "strange runestone");
            thing.set("LevelMin", i + 6 + i / 3 + RPG.r(i / 2));
            thing.set("Frequency", 55 - 2 * i);
            thing.set("Image", 501 + i % 3);
            thing.set("RuneIndex", i);
            if (runes[i].equals("Si")) {
                thing.set("IsActive", 1);
                thing.addHandler("OnAction", Scripts.generator("Si rune", 5));
            } else if (runes[i].equals("Rux")) {
                thing.set("IsDestructible", 0);
            } else if (runes[i].equals("Wei")) {
                thing.set("IsActive", 1);
                thing.addHandler("OnAction", Scripts.generator("flutterby", 100));
            } else if (runes[i].equals("Llam")) {
                thing.set("DeathDecoration", "Blaze");
            }
            Rune.addRuneStone(thing);
        }
    }

    protected static int countExistingRunes(Thing thing) {
        Thing[] thingArray = thing.getFlaggedContents("IsRune");
        int n = 0;
        for (int i = 0; i < thingArray.length; ++i) {
            n += thingArray[i].getStat("RuneCount");
        }
        return n;
    }

    protected static int destroyExistingRunes(Thing thing, int n) {
        Thing[] thingArray = thing.getFlaggedContents("IsRune");
        int n2 = 0;
        for (int i = 0; i < thingArray.length; ++i) {
            if (RPG.r(100) >= n) continue;
            ++n2;
            thingArray[i].remove();
        }
        return n2;
    }

    private static void addRune(Thing thing) {
        Lib.add(thing);
        String string = thing.name().replaceFirst("rune", "runestone");
        Thing thing2 = Lib.extend(string, "base runestone");
        thing2.set("Frequency", 15);
        thing2.set("LevelMin", thing.get("LevelMin"));
        thing2.set("UName", "weird runestone");
        thing2.set("AlterationType", thing.get("AlterationType"));
        thing2.set("IsWeaponRunestone", thing.get("IsWeaponRune"));
        thing2.set("Image", 501 + RPG.r(3));
        thing2.set("ValueBase", 1000);
        thing2.set("OnApply", Scripts.addThing("Target", thing.name()));
        Lib.add(thing2);
        Recipe.register("Rune Lore", thing2, thing2.getStat("RuneCount"));
    }

    private static void initItemRunes() {
        Thing thing = Lib.extend("base item rune", "base rune");
        thing.set("IsItemRune", 1);
        thing.set("Frequency", 20);
        thing.set("AlterationType", "IsItem");
        thing.set("ValueBase", 1000);
        Lib.add(thing);
        thing = Lib.extend("permacurse rune", "base item rune");
        thing.set("LevelMin", 5);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.bonus("IsCursed", 1));
        Rune.addRune(thing);
        thing = Lib.extend("lightness rune", "base item rune");
        thing.set("LevelMin", 15);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.linear("ItemWeight", 80, 0));
        Rune.addRune(thing);
        thing = Lib.extend("featherweight rune", "base item rune");
        thing.set("LevelMin", 25);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.linear("ItemWeight", 60, 0));
        Rune.addRune(thing);
    }

    private static void initArmourRunes() {
        Thing thing = Lib.extend("base armour rune", "base rune");
        thing.set("IsArmourRune", 1);
        thing.set("Frequency", 30);
        thing.set("AlterationType", "IsArmour");
        thing.set("ValueBase", 500);
        Lib.add(thing);
        thing = Lib.extend("light armour rune", "base armour rune");
        thing.set("LevelMin", 7);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.linear("ItemWeight", 90, 0));
        Rune.addRune(thing);
        thing = Lib.extend("armour rune", "base armour rune");
        thing.set("LevelMin", 6);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.bonus("Armour", 4));
        Rune.addRune(thing);
        thing = Lib.extend("toughness rune", "base armour rune");
        thing.set("LevelMin", 11);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.linear("TG", 100, RPG.d(3))));
        Rune.addRune(thing);
        thing = Lib.extend("advanced armour rune", "base armour rune");
        thing.set("LevelMin", 16);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.bonus("Armour", 16));
        Rune.addRune(thing);
        thing = Lib.extend("fire defence rune", "base armour rune");
        thing.set("LevelMin", 7);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.bonus("ARM:fire", 16)));
        Rune.addRune(thing);
        thing = Lib.extend("ice defence rune", "base armour rune");
        thing.set("LevelMin", 9);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.bonus("ARM:fire", 20)));
        Rune.addRune(thing);
        thing = Lib.extend("poison resistance rune", "base armour rune");
        thing.set("LevelMin", 12);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.bonus("RES:poison", 2)));
        Rune.addRune(thing);
        thing = Lib.extend("bravery rune", "base armour rune");
        thing.set("LevelMin", 14);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.bonus("Bravery", 1)));
        Rune.addRune(thing);
        thing = Lib.extend("speed rune", "base armour rune");
        thing.set("LevelMin", 17);
        thing.set("RuneCount", 4);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.bonus("MoveSpeed", 20)));
        Rune.addRune(thing);
        thing = Lib.extend("greater armour rune", "base armour rune");
        thing.set("LevelMin", 26);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.linear("Armour", 110, 30));
        Rune.addRune(thing);
        thing = Lib.extend("fire immunity rune", "base armour rune");
        thing.set("LevelMin", 33);
        thing.set("RuneCount", 4);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.bonus("RES:fire", 12)));
        Rune.addRune(thing);
        thing = Lib.extend("poison immunity rune", "base armour rune");
        thing.set("LevelMin", 37);
        thing.set("RuneCount", 4);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.bonus("RES:poison", 12)));
        Rune.addRune(thing);
        thing = Lib.extend("ultimate armour rune", "base armour rune");
        thing.set("LevelMin", 45);
        thing.set("RuneCount", 4);
        thing.add("CarriedModifiers", Modifier.linear("Armour", 140, 120));
        Rune.addRune(thing);
    }

    private static void initShieldRunes() {
        Thing thing = Lib.extend("base shield rune", "base rune");
        thing.set("IsShieldRune", 1);
        thing.set("Frequency", 40);
        thing.set("AlterationType", "IsShield");
        thing.set("ValueBase", 600);
        Lib.add(thing);
        thing = Lib.extend("shield enhancement rune", "base shield rune");
        thing.set("LevelMin", 1);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.bonus("Armour", 4));
        Rune.addRune(thing);
        thing = Lib.extend("willpower rune", "base shield rune");
        thing.set("LevelMin", 5);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.linear("WP", 100, RPG.d(3))));
        Rune.addRune(thing);
        thing = Lib.extend("defensive shield rune", "base shield rune");
        thing.set("LevelMin", 13);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.linear("Defence", 0, 1)));
        Rune.addRune(thing);
    }

    private static void initMissileRunes() {
        Thing thing = Lib.extend("base missile rune", "base rune");
        thing.set("IsMissileRune", 1);
        thing.set("Frequency", 40);
        thing.set("AlterationType", "IsItem");
        Lib.add(thing);
        thing = Lib.extend("returning tendency rune", "base weapon rune");
        thing.set("LevelMin", 1);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.bonus("MissileReturns", 15));
        Rune.addRune(thing);
        thing = Lib.extend("returning rune", "base weapon rune");
        thing.set("LevelMin", 25);
        thing.set("RuneCount", 4);
        thing.add("CarriedModifiers", Modifier.bonus("MissileReturns", 100));
        Rune.addRune(thing);
    }

    private static void initWeaponRunes() {
        Thing thing = Lib.extend("base weapon rune", "base rune");
        thing.set("IsWeaponRune", 1);
        thing.set("Frequency", 40);
        thing.set("AlterationType", "IsWeapon");
        thing.set("ValueBase", 500);
        Lib.add(thing);
        thing = Lib.extend("flame damage rune", "base weapon rune");
        thing.set("LevelMin", 1);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "smouldering"));
        thing.add("CarriedModifiers", Modifier.constant("ExtraDamageType", "fire"));
        thing.add("CarriedModifiers", Modifier.bonus("ExtraASTBonus", RPG.d(2, 4)));
        Rune.addRune(thing);
        thing = Lib.extend("defence rune", "base weapon rune");
        thing.set("LevelMin", 4);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.bonus("DSKBonus", RPG.d(2, 4)));
        Rune.addRune(thing);
        thing = Lib.extend("strength rune", "base weapon rune");
        thing.set("LevelMin", 14);
        thing.set("RuneCount", 4);
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.linear("ST", 100, RPG.d(3))));
        Rune.addRune(thing);
        thing = Lib.extend("ice damage rune", "base weapon rune");
        thing.set("LevelMin", 6);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "icy"));
        thing.add("CarriedModifiers", Modifier.constant("ExtraDamageType", "ice"));
        thing.add("CarriedModifiers", Modifier.bonus("ExtraASTBonus", RPG.d(2, 5)));
        Rune.addRune(thing);
        thing = Lib.extend("flaming rune", "base weapon rune");
        thing.set("LevelMin", 5);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "flaming"));
        thing.add("CarriedModifiers", Modifier.constant("ExtraDamageType", "fire"));
        thing.add("CarriedModifiers", Modifier.bonus("ExtraASTBonus", RPG.d(3, 6)));
        Rune.addRune(thing);
        thing = Lib.extend("poison tip rune", "base weapon rune");
        thing.set("LevelMin", 8);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "poison-dripping"));
        thing.add("CarriedModifiers", Modifier.constant("ExtraDamageType", "poison"));
        thing.add("CarriedModifiers", Modifier.bonus("ExtraASTBonus", RPG.d(3, 6)));
        Rune.addRune(thing);
        thing = Lib.extend("accuracy rune", "base weapon rune");
        thing.set("LevelMin", 10);
        thing.set("RuneCount", 1);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "glowing"));
        thing.add("CarriedModifiers", Modifier.linear("ASKMul", 200, 0));
        Rune.addRune(thing);
        thing = Lib.extend("smiting rune", "base weapon rune");
        thing.set("LevelMin", 15);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "glowing"));
        thing.add("CarriedModifiers", Modifier.linear("ASTMul", 200, 0));
        Rune.addRune(thing);
        thing = Lib.extend("rune of quick striking", "base weapon rune");
        thing.set("LevelMin", 20);
        thing.set("RuneCount", 2);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "glowing"));
        thing.add("CarriedModifiers", Modifier.linear("AttackCost", 80, 0));
        Rune.addRune(thing);
        thing = Lib.extend("rune of fearsome appearance", "base weapon rune");
        thing.set("LevelMin", 20);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "glowing"));
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.linear("FearFactor", 0, 1)));
        Rune.addRune(thing);
        thing = Lib.extend("rune of terror", "base weapon rune");
        thing.set("LevelMin", 35);
        thing.set("RuneCount", 4);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "shrieking"));
        thing.add("CarriedModifiers", Modifier.addModifier("WieldedModifiers", Modifier.linear("FearFactor", 0, 3)));
        Rune.addRune(thing);
        thing = Lib.extend("whirlwind rune", "base weapon rune");
        thing.set("LevelMin", 30);
        thing.set("RuneCount", 3);
        thing.add("CarriedModifiers", Modifier.constant("Adjective", "smoking"));
        thing.add("CarriedModifiers", Modifier.linear("AttackCost", 60, 0));
        Rune.addRune(thing);
    }

    private static class RuneUseScript
    extends Script {
        private static final long serialVersionUID = 3258688810429592888L;

        private RuneUseScript() {
        }

        public boolean handle(Thing thing, Event event) {
            int n;
            String string;
            Thing thing2 = event.getThing("User");
            Thing thing3 = Game.selectItem("Select an item to apply the rune to:", thing2.getItems());
            if (thing3 == null) {
                return false;
            }
            if (thing3.getStat("Number") > 1) {
                thing3 = thing3.separate(RPG.d(4));
            }
            if ((string = thing.getString("AlterationType")) == null) {
                Game.message("Nothing seems to happen");
                Game.warn("No AlterationType for " + thing.name());
                return true;
            }
            if (!thing3.getFlag(string)) {
                Game.message("You do not seem to be able to use " + thing.getTheName() + " with " + thing3.getTheName());
                return true;
            }
            thing.remove(1);
            if (thing3.getFlag("IsArtifact")) {
                Game.message(thing3.getTheName() + " seems totally unaffected");
                return true;
            }
            int n2 = Rune.countExistingRunes(thing3);
            if (n2 > 0 && (n = Rune.destroyExistingRunes(thing3, 50)) > 0) {
                Game.message("Some existing runes are destroyed!");
            }
            if (thing.handles("OnApply")) {
                Game.message(thing3.getTheName() + " shines brightly for a second");
                Event event2 = new Event("Apply");
                event2.set("Target", thing3);
                event2.set("User", thing2);
                thing.handle(event2);
            }
            return true;
        }
    }

    private static class RuneScribeScript
    extends Script {
        private static final long serialVersionUID = 3762820367848585273L;

        private RuneScribeScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("User");
            int n = thing2.getStat("Rune Lore") - 1;
            if (n < 0) {
                Game.message("You don't know how to scribe runes");
                return false;
            }
            if (n == 0) {
                Game.message("You must further improve your Rune Lore skill in order to scribe runes");
            }
            String[] stringArray = new String[RPG.min(runes.length, n)];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = runes[i];
            }
            String string = Game.selectString("Select a rune to scribe: ", stringArray);
            string = string + " runestone";
            if (stringArray != null) {
                thing.remove(1);
                Thing thing3 = Lib.create(string);
                int n2 = thing3.getStat("RuneIndex");
                int n3 = RPG.middle(0, 50 - 3 * n2 + thing2.getStat("CR") * (n - n2) / RPG.round(Math.pow(1.15, n2)), 100);
                Game.warn("Success chance = " + n3);
                if (RPG.r(100) < n3) {
                    Item.identify(thing3);
                    thing2.message("You successfully scribe " + thing3.getAName());
                    thing2.addThingWithStacking(thing3);
                } else {
                    thing2.message("You fail to scribe the " + string + " correctly");
                }
            }
            return false;
        }
    }
}

