/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class Score {
    private static final double SCORE_HALFLIFE = 3000000.0;

    public static void scoreIdentify(Thing thing, Thing thing2) {
        if (!Item.isDisguisedName(thing2)) {
            Score.addScore(thing, Lib.getDefaultStat(thing2, "Level") * 2);
        }
    }

    public static void scoreExplore(Thing thing) {
        int n = thing.getStat("ExploreScore");
        if (n > 0) {
            Score.addScore(Game.hero(), n);
            thing.incStat("ExploreScore", -n);
        }
    }

    public static void scoreFirstKill(Thing thing) {
        Score.addScore(Game.hero(), Lib.getDefaultStat(thing, "Level") * 5);
    }

    public static void scoreSecretDoor(int n) {
        Score.addScore(Game.hero(), n * 10);
    }

    private static void addScore(Thing thing, int n) {
        int n2 = RPG.round((double)n * Math.pow(0.5, (double)thing.getStat("GameTime") / 3000000.0));
        thing.incStat("Score", n2);
    }
}

