/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import mikera.tyrant.util.LibMetaDataHandler;
import mikera.tyrant.util.MetaData;
import mikera.tyrant.util.MetaDataEntry;

public class LibMetaData {
    private static LibMetaData instance = null;
    private TreeMap metaData = new TreeMap();

    private LibMetaData() {
    }

    protected static LibMetaData instance() {
        if (instance == null) {
            instance = new LibMetaData();
            LibMetaDataHandler.createLibMetaData(instance);
        }
        return instance;
    }

    protected void add(String string, MetaData metaData) {
        this.metaData.put(string, metaData);
    }

    protected TreeMap getAll() {
        return this.metaData;
    }

    protected MetaData get(String string) {
        return (MetaData)this.metaData.get(string);
    }

    protected String describes(TreeMap treeMap) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.metaData.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            MetaData metaData = (MetaData)this.metaData.get(string);
            if (!metaData.describes(treeMap, false)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() == 0) {
            System.out.println(" The item doesn't match any library meta data");
        }
        if (arrayList.size() == 1) {
            System.out.println(" The item matches the library meta data \"" + (String)arrayList.get(0) + "\"");
            return (String)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            System.out.println(" The item is ambiguous, " + arrayList.size() + " matching descriptions were found: " + arrayList);
            System.out.println(" Reasons: Faulty plug-in data or faulty meta data inside the program");
            System.out.println(" Please contact the Tyrant developers if you're not sure and provide your plug-in file");
        }
        return null;
    }

    public static boolean isKnownProperty(String string) {
        TreeMap treeMap = LibMetaData.instance().getAll();
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            MetaData metaData = (MetaData)treeMap.get(string2);
            if (metaData.get(string) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidProperty(String string, Object object) {
        TreeMap treeMap = LibMetaData.instance().getAll();
        Iterator iterator = treeMap.keySet().iterator();
        MetaDataEntry metaDataEntry = null;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            MetaData metaData = (MetaData)treeMap.get(string2);
            if (metaData.get(string) == null) continue;
            System.out.println(metaData.getAll().keySet());
            metaDataEntry = metaData.get(string);
            System.out.println(metaDataEntry.getValue());
            break;
        }
        if (metaDataEntry != null) {
            return metaDataEntry.describes(object);
        }
        System.out.println("No meta data for " + string + " available");
        return false;
    }

    public static String getPropertyDescription(String string) {
        return (String)LibMetaDataHandler.createPropertyDescriptions().get(string);
    }
}

