/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.Quaqua14TitlePane;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.color.PaintableColor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.ComponentPeer;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class Quaqua14RootPaneUI
extends BasicRootPaneUI {
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int BORDER_DRAG_THICKNESS = 15;
    private Window window;
    private JComponent titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private AncestorListener ancestorListener;
    private ComponentListener componentListener;
    private static boolean isWindowModifiedSupported = true;
    private static Method setWindowModifiedMethod = null;
    private JRootPane root;
    private static WeakHashMap allRootPanes = new WeakHashMap();
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);

    public static ComponentUI createUI(JComponent c) {
        return new Quaqua14RootPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.root = (JRootPane)c;
        c.putClientProperty("apple.awt.draggableWindowBackground", UIManager.get("RootPane.draggableWindowBackground"));
        c.putClientProperty("apple.awt.windowShadow", UIManager.get("RootPane.windowShadow"));
        Window window = SwingUtilities.getWindowAncestor(c);
        int style = this.root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this.root);
        }
        allRootPanes.put(c, null);
    }

    public void paint(Graphics g, JComponent c) {
        int style = this.getRootPane().getWindowDecorationStyle();
        if (style != 0) {
            boolean needsResizeIcon = false;
            if (this.window instanceof Frame) {
                Frame frame = (Frame)this.window;
                needsResizeIcon = frame.isResizable();
            } else if (this.window instanceof Dialog) {
                Dialog dialog = (Dialog)this.window;
                needsResizeIcon = dialog.isResizable();
            }
            if (needsResizeIcon) {
                Icon resizeIcon = UIManager.getIcon("InternalFrame.resizeIcon");
                int w = c.getWidth();
                int h = c.getHeight();
                Insets insets = c.getInsets();
                resizeIcon.paintIcon(c, g, w - resizeIcon.getIconWidth() - insets.right, h - resizeIcon.getIconHeight() - insets.bottom);
            }
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
        allRootPanes.remove(c);
    }

    protected void installDefaults(JRootPane c) {
        super.installDefaults(c);
        LookAndFeel.installColorsAndFont(c, "RootPane.background", "RootPane.foreground", "RootPane.font");
        LookAndFeel.installBorder(c, "RootPane.border");
        c.setOpaque(true);
    }

    public void update(Graphics gr, JComponent c) {
        if (c.isOpaque()) {
            Graphics2D g = (Graphics2D)gr;
            g.setPaint(PaintableColor.getPaint(c.getBackground(), c));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(gr, c);
    }

    protected void installListeners(JRootPane root) {
        super.installListeners(root);
        this.ancestorListener = this.createAncestorListener();
        if (this.ancestorListener != null) {
            root.addAncestorListener(this.ancestorListener);
        }
        this.componentListener = this.createComponentListener();
        if (this.componentListener != null) {
            root.addComponentListener(this.componentListener);
        }
    }

    protected void uninstallListeners(JRootPane root) {
        super.uninstallListeners(root);
        if (this.ancestorListener != null) {
            root.removeAncestorListener(this.ancestorListener);
        }
        if (this.componentListener != null) {
            root.removeComponentListener(this.componentListener);
        }
    }

    protected ComponentListener createComponentListener() {
        return new ComponentAdapter(){

            public void componentResized(final ComponentEvent e) {
                Timer t = new Timer(200, new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        e.getComponent().repaint();
                    }
                });
                t.setRepeats(false);
                t.start();
            }
        };
    }

    protected AncestorListener createAncestorListener() {
        return new RootPaneAncestorListener();
    }

    private JComponent createTitlePane(JRootPane root) {
        return new Quaqua14TitlePane(root, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager() {
        return new QuaquaRootLayout();
    }

    private static void updateWindowModified(JRootPane rootpane) {
        ComponentPeer peer;
        Container parent;
        if (isWindowModifiedSupported && (parent = rootpane.getParent()) != null && parent instanceof Window && (peer = parent.getPeer()) != null) {
            if (setWindowModifiedMethod == null) {
                try {
                    setWindowModifiedMethod = peer.getClass().getMethod("setDocumentEdited", Boolean.TYPE);
                }
                catch (NoSuchMethodException ex1) {
                    try {
                        setWindowModifiedMethod = peer.getClass().getMethod("setModified", Boolean.TYPE);
                    }
                    catch (NoSuchMethodException ex2) {
                        isWindowModifiedSupported = false;
                    }
                }
                catch (AccessControlException ex1) {
                    isWindowModifiedSupported = false;
                }
            }
            if (setWindowModifiedMethod != null) {
                try {
                    Object value = rootpane.getClientProperty("Window.documentModified");
                    if (value == null) {
                        value = rootpane.getClientProperty("windowModified");
                    }
                    if (value == null) {
                        value = Boolean.FALSE;
                    }
                    setWindowModifiedMethod.invoke((Object)peer, value);
                }
                catch (IllegalAccessException ex) {
                    isWindowModifiedSupported = false;
                }
                catch (InvocationTargetException ex) {
                    isWindowModifiedSupported = false;
                }
            }
        }
    }

    void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, borderKeys[style]);
        }
    }

    private void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        root.putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        root.putClientProperty("apple.awt.windowShadow", Boolean.TRUE);
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
        root.putClientProperty("apple.awt.windowShadow.revalidateNow", new Object());
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(root);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private boolean isVertical(JRootPane root) {
        return root.getClientProperty("Quaqua.RootPane.isVertical") == Boolean.TRUE;
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    private void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String name = e.getPropertyName();
        JRootPane rootpane = (JRootPane)e.getSource();
        if (name.equals("Window.windowModified") || name.equals("windowModified")) {
            Quaqua14RootPaneUI.updateWindowModified(rootpane);
        } else if (name.equals("windowDecorationStyle")) {
            int style = this.root.getWindowDecorationStyle();
            this.uninstallClientDecorations(this.root);
            if (style != 0) {
                this.installClientDecorations(this.root);
            }
        } else if (name.equals("JComponent.sizeVariant")) {
            QuaquaUtilities.applySizeVariant(rootpane);
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private Rectangle cachedScreenBounds;

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = Quaqua14RootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = (Window)ev.getSource();
            if (w != null) {
                w.toFront();
            }
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, Quaqua14RootPaneUI.this.getTitlePane());
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int n = frameState = f != null ? f.getExtendedState() : 0;
            if (Quaqua14RootPaneUI.this.getTitlePane() != null && Quaqua14RootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                if (f != null && (frameState & 6) == 0 || d != null) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                }
            } else if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
                this.dragCursor = dragWindowOffset.x >= this.dragWidth - 15 && dragWindowOffset.y >= this.dragHeight - 15 ? 5 : 0;
            }
        }

        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && Quaqua14RootPaneUI.this.window != null && !Quaqua14RootPaneUI.this.window.isValid()) {
                Quaqua14RootPaneUI.this.window.validate();
                Quaqua14RootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
            this.cachedScreenBounds = null;
        }

        public void mouseMoved(MouseEvent ev) {
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        public void mouseDragged(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                if (w.isShowing()) {
                    Point windowPt = w.getLocationOnScreen();
                    windowPt.x += pt.x - this.dragOffsetX;
                    windowPt.y += pt.y - this.dragOffsetY;
                    boolean isOnDefaultScreen = w.getGraphicsConfiguration().getDevice() == GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                    int snap = UIManager.getInt("RootPane.windowSnapDistance");
                    if (snap > 0 && (ev.getModifiersEx() & 0x200) == 0) {
                        LinkedList<Rectangle> snapBounds;
                        do {
                            snapBounds = new LinkedList<Rectangle>();
                            try {
                                Iterator i = allRootPanes.keySet().iterator();
                                while (i.hasNext()) {
                                    JRootPane otherRootPane = (JRootPane)i.next();
                                    Window other = SwingUtilities.getWindowAncestor(otherRootPane);
                                    if (other == null || !other.isShowing() || other == w) continue;
                                    snapBounds.add(other.getBounds());
                                }
                            }
                            catch (ConcurrentModificationException e) {
                                snapBounds = null;
                            }
                        } while (snapBounds == null);
                        snapBounds.add(w.getGraphicsConfiguration().getBounds());
                        if (isOnDefaultScreen) {
                            Rectangle r = w.getGraphicsConfiguration().getBounds();
                            Insets insets = w.getToolkit().getScreenInsets(w.getGraphicsConfiguration());
                            r.x += insets.left;
                            r.y += insets.top;
                            r.width -= insets.left + insets.right;
                            r.height -= insets.top + insets.bottom;
                            snapBounds.add(r);
                        }
                        Dimension windowDim = w.getSize();
                        Rectangle windowRect = new Rectangle(windowPt.x, windowPt.y, windowDim.width, windowDim.height);
                        Rectangle snapper = new Rectangle();
                        Iterator i = snapBounds.iterator();
                        while (i.hasNext()) {
                            Rectangle r = (Rectangle)i.next();
                            snapper.setBounds(r);
                            snapper.grow(snap, snap);
                            if (!snapper.intersects(windowRect)) continue;
                            if (windowPt.x > r.x - snap && windowPt.x < r.x + snap) {
                                windowPt.x = r.x;
                            } else if (windowPt.x > r.x + r.width - snap && windowPt.x < r.x + r.width + snap) {
                                windowPt.x = r.x + r.width;
                            } else if (windowPt.x + windowDim.width > r.x - snap && windowPt.x + windowDim.width < r.x + snap) {
                                windowPt.x = r.x - windowDim.width;
                            } else if (windowPt.x + windowDim.width > r.x + r.width - snap && windowPt.x + windowDim.width < r.x + r.width + snap) {
                                windowPt.x = r.x + r.width - windowDim.width;
                            }
                            if (windowPt.y > r.y - snap && windowPt.y < r.y + snap) {
                                windowPt.y = r.y;
                                continue;
                            }
                            if (windowPt.y > r.y + r.height - snap && windowPt.y < r.y + r.height + snap) {
                                windowPt.y = r.y + r.height;
                                continue;
                            }
                            if (windowPt.y + windowDim.height > r.y - snap && windowPt.y + windowDim.height < r.y + snap) {
                                windowPt.y = r.y - windowDim.height;
                                continue;
                            }
                            if (windowPt.y + windowDim.height <= r.y + r.height - snap || windowPt.y + windowDim.height >= r.y + r.height + snap) continue;
                            windowPt.y = r.y + r.height - windowDim.height;
                        }
                    }
                    if (isOnDefaultScreen) {
                        if (this.cachedScreenBounds == null) {
                            this.cachedScreenBounds = w.getGraphicsConfiguration().getBounds();
                            Insets screenInsets = w.getToolkit().getScreenInsets(w.getGraphicsConfiguration());
                            this.cachedScreenBounds.x += screenInsets.left;
                            this.cachedScreenBounds.y += screenInsets.top;
                            this.cachedScreenBounds.width -= screenInsets.left + screenInsets.right;
                            this.cachedScreenBounds.height -= screenInsets.top + screenInsets.bottom;
                        }
                        Rectangle titlePaneBounds = Quaqua14RootPaneUI.this.getTitlePane().getBounds();
                        Dimension windowSize = Quaqua14RootPaneUI.this.window.getSize();
                        if (Quaqua14RootPaneUI.this.isVertical(Quaqua14RootPaneUI.this.getRootPane())) {
                            windowPt.x = Math.max(this.cachedScreenBounds.x + titlePaneBounds.x, windowPt.x);
                            windowPt.x = Math.min(this.cachedScreenBounds.x + this.cachedScreenBounds.width - titlePaneBounds.x - titlePaneBounds.width, windowPt.x);
                            windowPt.y = Math.max(this.cachedScreenBounds.y - windowSize.height + 20, windowPt.y);
                            windowPt.y = Math.min(this.cachedScreenBounds.y + this.cachedScreenBounds.height - 20, windowPt.y);
                        } else {
                            windowPt.y = Math.max(this.cachedScreenBounds.y + titlePaneBounds.y, windowPt.y);
                            windowPt.y = Math.min(this.cachedScreenBounds.y + this.cachedScreenBounds.height - titlePaneBounds.y - titlePaneBounds.height, windowPt.y);
                            windowPt.x = Math.max(this.cachedScreenBounds.x - windowSize.width + 20, windowPt.x);
                            windowPt.x = Math.min(this.cachedScreenBounds.x + this.cachedScreenBounds.width - 20, windowPt.x);
                        }
                    }
                    w.setLocation(windowPt);
                }
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min = w.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                }
                if (!r.equals(startBounds)) {
                    w.setBounds(r);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w.validate();
                        Quaqua14RootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Quaqua14RootPaneUI.this.lastCursor = w.getCursor();
            this.mouseMoved(ev);
        }

        public void mouseExited(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            w.setCursor(Quaqua14RootPaneUI.this.lastCursor);
        }

        public void mouseClicked(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Frame f = null;
            if (!(w instanceof Frame)) {
                return;
            }
            f = (Frame)w;
            Point convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), Quaqua14RootPaneUI.this.getTitlePane());
            int state = f.getExtendedState();
            if (Quaqua14RootPaneUI.this.getTitlePane() != null && Quaqua14RootPaneUI.this.getTitlePane().contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & 6) != 0) {
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f.setExtendedState(state | 6);
                }
                return;
            }
        }
    }

    private static class QuaquaRootLayout
    implements LayoutManager2 {
        private QuaquaRootLayout() {
        }

        private boolean isVertical(Container parent) {
            if (parent instanceof JComponent) {
                return ((JComponent)parent).getClientProperty("Quaqua.RootPane.isVertical") == Boolean.TRUE;
            }
            return false;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            boolean isVertical = this.isVertical(parent);
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof Quaqua14RootPaneUI && (titlePane = ((Quaqua14RootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if (isVertical) {
                return new Dimension(Math.max(cpWidth, mbWidth) + tpWidth + i.left + i.right, Math.max(cpHeight + mbHeight, tpHeight) + i.top + i.bottom);
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            boolean isVertical = this.isVertical(parent);
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof Quaqua14RootPaneUI && (titlePane = ((Quaqua14RootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if (isVertical) {
                return new Dimension(Math.max(cpWidth, mbWidth) + tpWidth + i.left + i.right, Math.max(cpHeight + mbHeight, tpHeight) + i.top + i.bottom);
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            boolean isVertical = this.isVertical(target);
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof Quaqua14RootPaneUI && (titlePane = ((Quaqua14RootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            boolean isVertical = this.isVertical(parent);
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int nextX = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof Quaqua14RootPaneUI && (titlePane = ((Quaqua14RootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                if (isVertical) {
                    int tpWidth = tpd.width;
                    titlePane.setBounds(0, 0, tpWidth, h);
                    nextX += tpWidth;
                } else {
                    int tpHeight = tpd.height;
                    titlePane.setBounds(0, 0, w, tpHeight);
                    nextY += tpHeight;
                }
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(nextX, nextY, w - nextX, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                Dimension cpd = root.getContentPane().getPreferredSize();
                root.getContentPane().setBounds(nextX, nextY, w - nextX, h < nextY ? 0 : h - nextY);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }

    private static class RootPaneAncestorListener
    implements AncestorListener,
    WindowListener {
        private RootPaneAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent evt) {
            Window window;
            Container ancestor = evt.getAncestor();
            Window window2 = window = ancestor instanceof Window ? (Window)ancestor : SwingUtilities.getWindowAncestor(ancestor);
            if (window != null) {
                window.addWindowListener(this);
                Quaqua14RootPaneUI.updateWindowModified((JRootPane)evt.getSource());
            }
        }

        public void ancestorMoved(AncestorEvent evt) {
        }

        public void ancestorRemoved(AncestorEvent evt) {
            Container ancestorParent = evt.getAncestorParent();
            if (ancestorParent != null) {
                Window window;
                Window window2 = window = ancestorParent instanceof Window ? (Window)ancestorParent : SwingUtilities.getWindowAncestor(ancestorParent);
                if (window != null) {
                    window.removeWindowListener(this);
                }
            }
        }

        public void windowActivated(WindowEvent e) {
            RootPaneAncestorListener.updateComponentTreeUIActivation(e.getComponent(), Boolean.TRUE);
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
            RootPaneAncestorListener.updateComponentTreeUIActivation(e.getComponent(), Boolean.FALSE);
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        private static void updateComponentTreeUIActivation(Component c, Boolean isActive) {
            if (c instanceof JComponent) {
                ((JComponent)c).putClientProperty("Frame.active", isActive);
            }
            Component[] children = null;
            if (c instanceof JMenu) {
                children = ((JMenu)c).getMenuComponents();
            } else if (c instanceof Container) {
                children = ((Container)c).getComponents();
            }
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    RootPaneAncestorListener.updateComponentTreeUIActivation(children[i], isActive);
                }
            }
        }
    }
}

