/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.boardpainter;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import net.sf.gogui.boardpainter.BoardPainter;
import net.sf.gogui.boardpainter.ConstField;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BoardPainterUtil {
    public static BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    public static BufferedImage getImage(BoardPainter painter, ConstField[][] field, int width, int height) {
        BufferedImage image = BoardPainterUtil.createImage(width, height);
        Graphics2D graphics = image.createGraphics();
        painter.draw(graphics, field, width, false);
        graphics.dispose();
        return image;
    }

    public static void writeImage(BufferedImage image, File file, Map<String, String> metaData) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix("png");
        ImageWriter writer = iter.next();
        IIOMetadata meta = null;
        if (metaData != null) {
            ImageTypeSpecifier specifier = new ImageTypeSpecifier(image);
            meta = writer.getDefaultImageMetadata(specifier, null);
            String formatName = "javax_imageio_1.0";
            Node node = meta.getAsTree(formatName);
            for (Map.Entry<String, String> entry : metaData.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                BoardPainterUtil.addMeta(node, key, value);
            }
            try {
                meta.mergeTree(formatName, node);
            }
            catch (IIOInvalidTreeException e) {
                assert (false);
                return;
            }
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(file);
        writer.setOutput(ios);
        try {
            writer.write(null, new IIOImage(image, null, meta), null);
        }
        catch (IllegalStateException e) {
            throw new IOException("Could not write to file " + file);
        }
    }

    private BoardPainterUtil() {
    }

    private static void addMeta(Node node, String keyword, String value) {
        IIOMetadataNode text = new IIOMetadataNode("Text");
        IIOMetadataNode textEntry = new IIOMetadataNode("TextEntry");
        textEntry.setAttribute("value", value);
        textEntry.setAttribute("keyword", keyword);
        textEntry.setAttribute("encoding", Locale.getDefault().toString());
        textEntry.setAttribute("language", "en");
        textEntry.setAttribute("compression", "none");
        text.appendChild(textEntry);
        node.appendChild(text);
    }
}

