/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import net.sf.gogui.gamefile.GameFileFilter;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.gui.SgfPreview;
import net.sf.gogui.thumbnail.ThumbnailPlatform;
import net.sf.gogui.util.Platform;

public final class FileDialogs {
    private static final boolean NATIVE_DIALOGS = Platform.isMac() || Platform.isWindows();
    private static File s_lastFile;

    public static File showOpen(Component parent, String title) {
        return FileDialogs.showFileChooser(parent, Type.FILE_OPEN, null, false, title);
    }

    public static File showOpenSgf(Component parent) {
        return FileDialogs.showFileChooser(parent, Type.FILE_OPEN, null, true, null);
    }

    public static File showSave(Component parent, String title, MessageDialogs messageDialogs) {
        return FileDialogs.showFileChooserSave(parent, null, false, title, messageDialogs);
    }

    public static File showSaveSgf(Frame parent, MessageDialogs messageDialogs) {
        return FileDialogs.showFileChooserSave(parent, s_lastFile, true, null, messageDialogs);
    }

    public static File showSelectFile(Component parent, String title) {
        return FileDialogs.showFileChooser(parent, Type.FILE_SELECT, s_lastFile, false, title);
    }

    public static void setLastFile(File file) {
        s_lastFile = file;
    }

    private FileDialogs() {
    }

    private static Frame findParentFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private static File showFileChooser(Component parent, Type type, File lastFile, boolean setSgfFilter, String title) {
        if (NATIVE_DIALOGS && type != Type.FILE_SELECT) {
            Frame frame = FileDialogs.findParentFrame(parent);
            return FileDialogs.showFileChooserAWT(frame, type, title);
        }
        return FileDialogs.showFileChooserSwing(parent, type, lastFile, setSgfFilter, title);
    }

    private static File showFileChooserSave(Component parent, File lastFile, boolean setSgfFilter, String title, MessageDialogs messageDialogs) {
        String optionalMessage;
        String mainMessage;
        File file = FileDialogs.showFileChooser(parent, Type.FILE_SAVE, lastFile, setSgfFilter, title);
        if (NATIVE_DIALOGS) {
            return file;
        }
        while (file != null && file.exists() && !messageDialogs.showQuestion(parent, mainMessage = MessageFormat.format(I18n.i18n("MSG_REPLACE_FILE"), file.getName()), optionalMessage = I18n.i18n("MSG_REPLACE_FILE_2"), I18n.i18n("LB_REPLACE"), true)) {
            file = FileDialogs.showFileChooser(parent, Type.FILE_SAVE, lastFile, setSgfFilter, title);
        }
        return file;
    }

    private static File showFileChooserAWT(Frame parent, Type type, String title) {
        FileDialog dialog = new FileDialog(parent);
        if (title == null) {
            switch (type) {
                case FILE_OPEN: {
                    title = I18n.i18n("TIT_OPEN");
                    break;
                }
                case FILE_SAVE: {
                    title = I18n.i18n("TIT_SAVE");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        dialog.setTitle(title);
        int mode = 0;
        if (type == Type.FILE_SAVE) {
            mode = 1;
        }
        dialog.setMode(mode);
        dialog.setLocationByPlatform(true);
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return null;
        }
        return new File(dialog.getDirectory(), dialog.getFile());
    }

    private static File showFileChooserSwing(Component parent, Type type, File lastFile, boolean setSgfFilter, String title) {
        File file;
        int ret;
        JFileChooser chooser = s_lastFile == null ? (Platform.isMac() ? new JFileChooser((String)null) : new JFileChooser(System.getProperty("user.dir"))) : new JFileChooser(s_lastFile);
        chooser.setMultiSelectionEnabled(false);
        GameFileFilter filter = new GameFileFilter();
        chooser.addChoosableFileFilter(filter);
        if (setSgfFilter) {
            chooser.setFileFilter(filter);
            if (ThumbnailPlatform.checkThumbnailSupport()) {
                SgfPreview preview = new SgfPreview();
                chooser.setAccessory(preview);
                chooser.addPropertyChangeListener(preview);
            }
        } else {
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        }
        if (type == Type.FILE_SAVE && lastFile != null && lastFile.isFile() && lastFile.exists()) {
            chooser.setSelectedFile(lastFile);
        }
        if (title != null) {
            chooser.setDialogTitle(title);
        }
        switch (type) {
            case FILE_SAVE: {
                ret = chooser.showSaveDialog(parent);
                break;
            }
            case FILE_OPEN: {
                ret = chooser.showOpenDialog(parent);
                break;
            }
            default: {
                ret = chooser.showDialog(parent, I18n.i18n("TIT_SELECT"));
            }
        }
        if (ret != 0) {
            return null;
        }
        s_lastFile = file = chooser.getSelectedFile();
        return file;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        FILE_OPEN,
        FILE_SAVE,
        FILE_SELECT;

    }
}

