/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.io.File;
import java.util.ArrayList;
import net.sf.gogui.gui.GuiMenu;
import net.sf.gogui.gui.RecentMenu;

public class RecentFileMenu {
    private final Listener m_listener;
    private final RecentMenu m_menu;
    private final ArrayList<String> m_sameName = new ArrayList();

    public RecentFileMenu(String label, String path, Listener listener) {
        assert (listener != null);
        this.m_listener = listener;
        RecentMenu.Listener recentListener = new RecentMenu.Listener(){

            public void itemSelected(String label, String value) {
                RecentFileMenu.this.m_listener.fileSelected(label, new File(value));
            }
        };
        this.m_menu = new RecentMenu(label, path, recentListener);
        for (int i = 0; i < this.m_menu.getCount(); ++i) {
            if (this.getFile(i).exists()) continue;
            this.m_menu.remove(i);
        }
    }

    public void add(File file) {
        String name = file.getName();
        this.m_menu.add(name, file.toString());
        this.m_sameName.clear();
        for (int i = 0; i < this.getCount(); ++i) {
            if (!this.getName(i).equals(name)) continue;
            this.m_sameName.add(this.getValue(i));
        }
        if (this.m_sameName.size() > 1) {
            int n = 0;
            while (true) {
                boolean samePrefix = true;
                if (file.toString().length() <= n) break;
                char c = file.toString().charAt(n);
                for (int i = 0; i < this.m_sameName.size(); ++i) {
                    String sameName = this.m_sameName.get(i);
                    if (sameName.length() > n && sameName.charAt(n) == c) continue;
                    samePrefix = false;
                    break;
                }
                if (!samePrefix) break;
                ++n;
            }
            for (int i = 0; i < this.getCount(); ++i) {
                if (!this.getName(i).equals(name)) continue;
                this.m_menu.setLabel(i, this.getValue(i).substring(n));
            }
        }
    }

    public GuiMenu getMenu() {
        return this.m_menu.getMenu();
    }

    public void updateEnabled() {
        this.m_menu.updateEnabled();
    }

    private int getCount() {
        return this.m_menu.getCount();
    }

    private File getFile(int i) {
        return new File(this.getValue(i));
    }

    private String getValue(int i) {
        return this.m_menu.getValue(i);
    }

    private String getName(int i) {
        return this.getFile(i).getName();
    }

    public static interface Listener {
        public void fileSelected(String var1, File var2);
    }
}

