/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.boardpainter;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import net.sf.gogui.boardpainter.RadialGradientContext;

public class RadialGradientPaint
implements Paint {
    private final int m_transparency;
    private Point2D m_transformedCenter;
    private Point2D m_transformedRadius1;
    private Point2D m_transformedRadius2;
    private RadialGradientContext m_cachedContext;
    private final double m_focus;
    private final Point2D m_center;
    private final Point2D m_radius1;
    private final Point2D m_radius2;
    private final Color m_color1;
    private final Color m_color2;

    public RadialGradientPaint(Point2D center, Point2D radius1, Point2D radius2, double focus, Color color1, Color color2) {
        this.m_center = center;
        this.m_radius1 = radius1;
        this.m_radius2 = radius2;
        this.m_focus = focus;
        this.m_color1 = color1;
        this.m_color2 = color2;
        int alpha1 = color1.getAlpha();
        int alpha2 = color2.getAlpha();
        this.m_transparency = (alpha1 & alpha2) == 255 ? 1 : 3;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        Point2D transformedCenter = xform.transform(this.m_center, null);
        Point2D transformedRadius1 = xform.deltaTransform(this.m_radius1, null);
        Point2D transformedRadius2 = xform.deltaTransform(this.m_radius2, null);
        if (this.m_cachedContext != null && transformedCenter.equals(this.m_transformedCenter) && transformedRadius1.equals(this.m_transformedRadius1) && transformedRadius2.equals(this.m_transformedRadius2)) {
            return this.m_cachedContext;
        }
        this.m_transformedCenter = (Point2D)transformedCenter.clone();
        this.m_transformedRadius1 = (Point2D)transformedRadius1.clone();
        this.m_transformedRadius2 = (Point2D)transformedRadius2.clone();
        this.m_cachedContext = new RadialGradientContext(transformedCenter, transformedRadius1, transformedRadius2, this.m_focus, this.m_color1, this.m_color2);
        return this.m_cachedContext;
    }

    public int getTransparency() {
        return this.m_transparency;
    }
}

