/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import java.util.Locale;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.InvalidPointException;
import net.sf.gogui.go.PointList;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoPoint
implements Comparable<GoPoint> {
    public static final int MAX_SIZE = 25;
    public static final int DEFAULT_SIZE = 19;
    public static final int NUMBER_INDEXES = 625;
    private static GoPoint[][] s_points = new GoPoint[25][25];
    private final int m_x;
    private final int m_y;
    private final int m_index;
    private final String m_string;

    @Override
    public int compareTo(GoPoint p) {
        if (this.m_index < p.m_index) {
            return -1;
        }
        if (this.m_index > p.m_index) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public static boolean equals(GoPoint point1, GoPoint point2) {
        return point1 == point2;
    }

    public static GoPoint get(int x, int y) {
        assert (x >= 0);
        assert (y >= 0);
        assert (x < 25);
        assert (y < 25);
        GoPoint point = s_points[x][y];
        assert (point != null);
        return point;
    }

    public int getIndex() {
        return this.m_index;
    }

    public static int getIndex(int x, int y) {
        return y * 25 + x;
    }

    public int hashCode() {
        return this.m_index;
    }

    public GoPoint down() {
        if (this.m_y > 0) {
            return GoPoint.get(this.m_x, this.m_y - 1);
        }
        return this;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public boolean isOnBoard(int size) {
        assert (size > 0);
        assert (size <= 25);
        return this.m_x < size && this.m_y < size;
    }

    public GoPoint left() {
        if (this.m_x > 0) {
            return GoPoint.get(this.m_x - 1, this.m_y);
        }
        return this;
    }

    public static GoPoint parsePoint(String string, int boardSize) throws InvalidPointException {
        int y;
        if ((string = string.trim().toUpperCase(Locale.ENGLISH)).equals("PASS")) {
            return null;
        }
        if (string.length() < 2) {
            throw new InvalidPointException(string);
        }
        char xChar = string.charAt(0);
        if (xChar >= 'J') {
            xChar = (char)(xChar - '\u0001');
        }
        int x = xChar - 65;
        try {
            y = Integer.parseInt(string.substring(1)) - 1;
        }
        catch (NumberFormatException e) {
            throw new InvalidPointException(string);
        }
        if (x < 0 || x >= boardSize || y < 0 || y >= boardSize) {
            throw new InvalidPointException(string);
        }
        return GoPoint.get(x, y);
    }

    public static PointList parsePointList(String s, int boardSize) throws InvalidPointException {
        PointList list = new PointList();
        for (String p : StringUtil.splitArguments(s)) {
            if (p.equals("")) continue;
            list.add(GoPoint.parsePoint(p, boardSize));
        }
        return list;
    }

    public GoPoint right(int max) {
        if (this.m_x < max - 1) {
            return GoPoint.get(this.m_x + 1, this.m_y);
        }
        return this;
    }

    public String toString() {
        return this.m_string;
    }

    public static String toString(GoPoint point) {
        if (point == null) {
            return "PASS";
        }
        return point.toString();
    }

    public static String toString(ConstPointList pointList) {
        if (pointList == null) {
            return "(null)";
        }
        int length = pointList.size();
        StringBuilder buffer = new StringBuilder(length * 4);
        for (int i = 0; i < length; ++i) {
            buffer.append(pointList.get(i));
            if (i >= length - 1) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public GoPoint up(int max) {
        if (this.m_y < max - 1) {
            return GoPoint.get(this.m_x, this.m_y + 1);
        }
        return this;
    }

    private GoPoint(int x, int y) {
        this.m_x = x;
        this.m_y = y;
        char xChar = (char)(65 + x);
        if (xChar >= 'I') {
            xChar = (char)(xChar + '\u0001');
        }
        this.m_string = xChar + Integer.toString(this.m_y + 1);
        this.m_index = GoPoint.getIndex(x, y);
    }

    static {
        for (int x = 0; x < 25; ++x) {
            for (int y = 0; y < 25; ++y) {
                GoPoint.s_points[x][y] = new GoPoint(x, y);
            }
        }
    }
}

