/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.util.Platform;

public class Comment
extends JScrollPane
implements DocumentListener {
    private boolean m_monoFont;
    private boolean m_duringSetText;
    private final JTextPane m_textPane;
    private final Listener m_listener;
    private final Font m_normalFont;

    public Comment(Listener listener) {
        this.m_listener = listener;
        this.m_textPane = new JTextPane();
        Comment.setFocusTraversalKeys(this.m_textPane);
        GuiUtil.addStyle(this.m_textPane, "marked", Color.white, Color.decode("#38d878"), false);
        this.setPreferredSize();
        this.m_textPane.getDocument().addDocumentListener(this);
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent event) {
                if (Comment.this.m_listener == null) {
                    return;
                }
                Comment.this.m_listener.textSelected(Comment.this.m_textPane.getSelectedText());
            }
        };
        this.m_textPane.addCaretListener(caretListener);
        this.setViewportView(this.m_textPane);
        this.setHorizontalScrollBarPolicy(31);
        this.m_normalFont = Platform.isMac() ? new Font("Lucida Grande", 0, 11) : UIManager.getFont("TextPane.font");
        this.setMonoFont(false);
    }

    public void changedUpdate(DocumentEvent e) {
        this.fireChangedEvent();
    }

    public boolean getMonoFont() {
        return this.m_monoFont;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public String getSelectedText() {
        return this.m_textPane.getSelectedText();
    }

    public void insertUpdate(DocumentEvent e) {
        this.fireChangedEvent();
    }

    public void markAll(Pattern pattern) {
        block4: {
            Document doc = this.m_textPane.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                Matcher matcher = pattern.matcher(text);
                boolean firstMatch = true;
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    if (firstMatch) {
                        GuiUtil.setStyle(this.m_textPane, 0, doc.getLength(), null);
                        this.m_textPane.setCaretPosition(start);
                        firstMatch = false;
                    }
                    GuiUtil.setStyle(this.m_textPane, start, end - start, "marked");
                }
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void removeUpdate(DocumentEvent e) {
        this.fireChangedEvent();
    }

    public final void setMonoFont(boolean enable) {
        if (enable) {
            GuiUtil.setMonospacedFont(this.m_textPane);
        } else {
            this.m_textPane.setFont(this.m_normalFont);
        }
        this.m_monoFont = enable;
        this.m_textPane.repaint();
    }

    public void setComment(String comment) {
        if (comment == null) {
            comment = "";
        }
        if (comment.equals(this.m_textPane.getText())) {
            return;
        }
        this.m_duringSetText = true;
        this.m_textPane.setText(comment);
        this.m_textPane.setCaretPosition(0);
        this.m_duringSetText = false;
    }

    public final void setPreferredSize() {
        int fontSize = GuiUtil.getDefaultMonoFontSize();
        this.setPreferredSize(new Dimension(15 * fontSize, 5 * fontSize));
    }

    private void fireChangedEvent() {
        if (this.m_duringSetText) {
            return;
        }
        String comment = this.m_textPane.getText();
        this.m_listener.changed(comment);
    }

    private static void setFocusTraversalKeys(JTextPane textPane) {
        int id = 0;
        HashSet<AWTKeyStroke> keystrokes = new HashSet<AWTKeyStroke>();
        keystrokes.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        textPane.setFocusTraversalKeys(id, keystrokes);
    }

    public static interface Listener {
        public void changed(String var1);

        public void textSelected(String var1);
    }
}

