/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import net.sf.gogui.gui.GameTreePanel;

class GameTreeJunction
extends JComponent {
    private final int[] m_childrenDy;
    private final GameTreePanel m_gameTreePanel;
    private static final Color COLOR_GRID = new Color(148, 148, 148);

    public GameTreeJunction(int[] childrenDy, GameTreePanel gameTreePanel) {
        this.m_gameTreePanel = gameTreePanel;
        this.m_childrenDy = childrenDy;
        this.setOpaque(false);
        this.setFocusable(false);
        this.setFocusTraversalKeysEnabled(false);
        int fullSize = this.m_gameTreePanel.getNodeFullSize();
        int lastDy = childrenDy[childrenDy.length - 1];
        this.setPreferredSize(new Dimension(fullSize, lastDy));
    }

    public void paintComponent(Graphics graphics) {
        int size = this.m_gameTreePanel.getNodeSize();
        int fullSize = this.m_gameTreePanel.getNodeFullSize();
        int halfSize = size / 2;
        graphics.setColor(COLOR_GRID);
        int lastDy = this.m_childrenDy[this.m_childrenDy.length - 1];
        graphics.drawLine(halfSize, 0, halfSize, lastDy - fullSize);
        for (int i = 1; i < this.m_childrenDy.length; ++i) {
            int y = this.m_childrenDy[i] - fullSize;
            graphics.drawLine(halfSize, y, size, y + halfSize);
            graphics.drawLine(size, y + halfSize, fullSize, y + halfSize);
        }
    }
}

