/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SpringLayout;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.gui.GameTreeJunction;
import net.sf.gogui.gui.GameTreeNode;
import net.sf.gogui.gui.GameTreeViewer;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.gui.TextViewer;

public class GameTreePanel
extends JPanel
implements Scrollable {
    public static final Color BACKGROUND = new Color(192, 192, 192);
    private boolean m_showSubtreeSizes;
    private int m_currentNodeX;
    private int m_currentNodeY;
    private Label m_labelMode;
    private int m_minHeight;
    private int m_minWidth;
    private Size m_sizeMode;
    private int m_nodeSize;
    private int m_nodeFullSize;
    private static final int MARGIN = 15;
    private int m_maxX;
    private int m_maxY;
    private Dimension m_preferredNodeSize;
    private Font m_font;
    private ConstGameTree m_tree;
    private final GameTreeViewer.Listener m_listener;
    private final JDialog m_owner;
    private JScrollPane m_scrollPane;
    private ConstNode m_currentNode;
    private ConstNode m_popupNode;
    private final HashMap<ConstNode, GameTreeNode> m_map = new HashMap(500, 0.8f);
    private final HashSet<ConstNode> m_isExpanded = new HashSet(200);
    private final MouseListener m_mouseListener;
    private Point m_popupLocation;
    private ImageIcon m_iconBlack;
    private ImageIcon m_iconWhite;
    private ImageIcon m_iconSetup;
    private final MessageDialogs m_messageDialogs;
    private JPopupMenu m_popup;
    private JMenuItem m_itemGoto;
    private JMenuItem m_itemScrollToCurrent;
    private JMenuItem m_itemHideSubtree;
    private JMenuItem m_itemShowSubtree;
    private JMenuItem m_itemShowChildren;

    public GameTreePanel(JDialog owner, GameTreeViewer.Listener listener, Label labelMode, Size sizeMode, MessageDialogs messageDialogs) {
        super(new SpringLayout());
        this.m_messageDialogs = messageDialogs;
        this.m_owner = owner;
        this.setBackground(BACKGROUND);
        this.m_labelMode = labelMode;
        this.m_sizeMode = sizeMode;
        this.initSize(sizeMode);
        this.setFocusable(false);
        this.setFocusTraversalKeysEnabled(false);
        this.setAutoscrolls(true);
        this.addMouseMotionListener(new MouseMotionListener());
        this.m_listener = listener;
        this.m_mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getButton() != 1) {
                    return;
                }
                GameTreeNode gameNode = (GameTreeNode)event.getSource();
                GameTreePanel.this.gotoNode(gameNode.getNode());
            }

            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    GameTreeNode gameNode = (GameTreeNode)event.getSource();
                    int x = event.getX();
                    int y = event.getY();
                    GameTreePanel.this.showPopup(x, y, gameNode);
                }
            }

            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    GameTreeNode gameNode = (GameTreeNode)event.getSource();
                    int x = event.getX();
                    int y = event.getY();
                    GameTreePanel.this.showPopup(x, y, gameNode);
                }
            }
        };
    }

    public ConstNode getCurrentNode() {
        return this.m_currentNode;
    }

    public Label getLabelMode() {
        return this.m_labelMode;
    }

    public int getNodeFullSize() {
        return this.m_nodeFullSize;
    }

    public int getNodeSize() {
        return this.m_nodeSize;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.m_nodeFullSize * 10, this.m_nodeFullSize * 3);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int result = orientation == 1 ? visibleRect.height : visibleRect.width;
        result = result / this.m_nodeFullSize * this.m_nodeFullSize;
        return result;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.m_nodeFullSize;
    }

    public boolean getShowSubtreeSizes() {
        return this.m_showSubtreeSizes;
    }

    public Size getSizeMode() {
        return this.m_sizeMode;
    }

    public void gotoNode(ConstNode node) {
        if (this.m_listener != null) {
            this.m_listener.actionGotoNode(node);
        }
    }

    public boolean isCurrent(ConstNode node) {
        return node == this.m_currentNode;
    }

    public boolean isExpanded(ConstNode node) {
        return this.m_isExpanded.contains(node);
    }

    public void paintComponent(Graphics graphics) {
        GuiUtil.setAntiAlias(graphics);
        super.paintComponent(graphics);
    }

    public void redrawCurrentNode() {
        GameTreeNode gameNode = this.getGameTreeNode(this.m_currentNode);
        gameNode.repaint();
    }

    public void scrollToCurrent() {
        this.scrollRectToVisible(new Rectangle(this.m_currentNodeX - 2 * this.m_nodeSize, this.m_currentNodeY - this.m_nodeSize, 5 * this.m_nodeSize, 3 * this.m_nodeSize));
    }

    public void setLabelMode(Label mode) {
        switch (mode) {
            case NUMBER: 
            case MOVE: 
            case NONE: {
                this.m_labelMode = mode;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.m_scrollPane = scrollPane;
    }

    public void setShowSubtreeSizes(boolean showSubtreeSizes) {
        this.m_showSubtreeSizes = showSubtreeSizes;
    }

    public void setSizeMode(Size mode) {
        switch (mode) {
            case LARGE: 
            case NORMAL: 
            case SMALL: 
            case TINY: {
                if (mode == this.m_sizeMode) break;
                this.m_sizeMode = mode;
                this.initSize(this.m_sizeMode);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void addNewSingleChild(ConstNode node) {
        assert (!node.hasChildren());
        ConstNode father = node.getFatherConst();
        assert (father != null);
        assert (father.getNumberChildren() == 1);
        GameTreeNode fatherGameNode = this.getGameTreeNode(father);
        if (fatherGameNode == null) {
            assert (false);
            return;
        }
        int moveNumber = NodeUtil.getMoveNumber(node);
        GameTreeNode gameNode = this.createNode(node, moveNumber);
        this.m_map.put(node, gameNode);
        this.add(gameNode);
        this.putConstraint(fatherGameNode, gameNode, this.m_nodeFullSize, 0);
        gameNode.setLocation(fatherGameNode.getX() + this.m_nodeFullSize, fatherGameNode.getY());
        gameNode.setSize(this.m_nodeFullSize, this.m_nodeFullSize);
        this.m_maxX = Math.max(fatherGameNode.getX() + 2 * this.m_nodeFullSize, this.m_maxX);
        this.setPreferredSize(new Dimension(this.m_maxX + this.m_nodeFullSize + 15, this.m_maxY + this.m_nodeFullSize + 15));
    }

    public void showPopup() {
        if (this.m_currentNode == null) {
            return;
        }
        this.scrollToCurrent();
        GameTreeNode gameNode = this.getGameTreeNode(this.m_currentNode);
        if (gameNode == null) {
            return;
        }
        this.showPopup(gameNode.getWidth() / 2, gameNode.getHeight() / 2, gameNode);
    }

    public void update(ConstGameTree tree, ConstNode currentNode, int minWidth, int minHeight) {
        boolean gameTreeChanged;
        assert (currentNode != null);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_minWidth = minWidth;
        this.m_minHeight = minHeight;
        boolean bl = gameTreeChanged = tree != this.m_tree;
        if (gameTreeChanged) {
            this.m_isExpanded.clear();
        }
        this.ensureVisible(currentNode);
        this.m_tree = tree;
        this.m_currentNode = currentNode;
        this.removeAll();
        this.m_map.clear();
        this.m_maxX = minWidth;
        this.m_maxY = minHeight;
        try {
            ConstNode root = this.m_tree.getRootConst();
            this.createNodes(this, root, 0, 0, 15, 15, 0);
            if (gameTreeChanged && !NodeUtil.subtreeGreaterThan(root, 10000)) {
                this.showSubtree(root);
            }
        }
        catch (OutOfMemoryError e) {
            this.m_isExpanded.clear();
            this.removeAll();
            this.m_messageDialogs.showError((Component)this.m_owner, I18n.i18n("MSG_TREE_OUTOFMEM"), I18n.i18n("MSG_TREE_OUTOFMEM_2"));
            this.update(tree, currentNode, minWidth, minHeight);
        }
        this.setPreferredSize(new Dimension(this.m_maxX + this.m_nodeFullSize + 15, this.m_maxY + this.m_nodeFullSize + 15));
        this.revalidate();
        this.scrollToCurrent();
        if (this.m_scrollPane != null) {
            this.m_scrollPane.requestFocusInWindow();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void update(ConstNode currentNode, int minWidth, int minHeight) {
        assert (currentNode != null);
        if (this.ensureVisible(currentNode)) {
            this.update(this.m_tree, currentNode, minWidth, minHeight);
            return;
        }
        GameTreeNode gameNode = this.getGameTreeNode(this.m_currentNode);
        if (gameNode == null) {
            System.err.println("GameTreePanel: current node not found");
            return;
        }
        gameNode.repaint();
        gameNode = this.getGameTreeNode(currentNode);
        if (gameNode == null) {
            this.update(this.m_tree, currentNode, minWidth, minHeight);
            return;
        }
        Point location = gameNode.getLocation();
        this.m_currentNodeX = location.x;
        this.m_currentNodeY = location.y;
        gameNode.repaint();
        gameNode.updateToolTip();
        this.m_currentNode = currentNode;
        this.scrollToCurrent();
        if (this.m_scrollPane != null) {
            this.m_scrollPane.requestFocusInWindow();
        }
    }

    private void initSize(Size sizeMode) {
        switch (sizeMode) {
            case LARGE: {
                this.m_nodeSize = 32;
                this.m_nodeFullSize = 40;
                this.m_iconBlack = GuiUtil.getIcon("gogui-black-32x32", "");
                this.m_iconWhite = GuiUtil.getIcon("gogui-white-32x32", "");
                this.m_iconSetup = GuiUtil.getIcon("gogui-setup-32x32", "");
                break;
            }
            case SMALL: {
                this.m_nodeSize = 16;
                this.m_nodeFullSize = 20;
                this.m_iconBlack = GuiUtil.getIcon("gogui-black-16x16", "");
                this.m_iconWhite = GuiUtil.getIcon("gogui-white-16x16", "");
                this.m_iconSetup = GuiUtil.getIcon("gogui-setup-16x16", "");
                break;
            }
            case TINY: {
                this.m_nodeSize = 8;
                this.m_nodeFullSize = 10;
                this.m_iconBlack = GuiUtil.getIcon("gogui-black-8x8", "");
                this.m_iconWhite = GuiUtil.getIcon("gogui-white-8x8", "");
                this.m_iconSetup = GuiUtil.getIcon("gogui-setup-8x8", "");
                break;
            }
            case NORMAL: {
                this.m_nodeSize = 24;
                this.m_nodeFullSize = 30;
                this.m_iconBlack = GuiUtil.getIcon("gogui-black-24x24", "");
                this.m_iconWhite = GuiUtil.getIcon("gogui-white-24x24", "");
                this.m_iconSetup = GuiUtil.getIcon("gogui-setup-24x24", "");
            }
        }
        this.m_font = new Font("Dialog", 0, (int)(0.4 * (double)this.m_nodeSize));
        this.m_preferredNodeSize = new Dimension(this.m_nodeFullSize, this.m_nodeFullSize);
    }

    private GameTreeNode createNode(ConstNode node, int moveNumber) {
        return new GameTreeNode(node, moveNumber, this, this.m_mouseListener, this.m_font, this.m_iconBlack.getImage(), this.m_iconWhite.getImage(), this.m_iconSetup.getImage(), this.m_preferredNodeSize);
    }

    private int createNodes(Component father, ConstNode node, int x, int y, int dx, int dy, int moveNumber) {
        this.m_maxX = Math.max(x, this.m_maxX);
        this.m_maxY = Math.max(y, this.m_maxY);
        if (node.getMove() != null) {
            ++moveNumber;
        }
        GameTreeNode gameNode = this.createNode(node, moveNumber);
        this.m_map.put(node, gameNode);
        this.add(gameNode);
        this.putConstraint(father, gameNode, dx, dy);
        int numberChildren = node.getNumberChildren();
        dx = this.m_nodeFullSize;
        dy = 0;
        boolean isExpanded = this.isExpanded(node);
        if (isExpanded) {
            int[] childrenDy = new int[numberChildren];
            for (int i = 0; i < numberChildren; ++i) {
                childrenDy[i] = dy;
                dy += this.createNodes(gameNode, node.getChildConst(i), x + dx, y + dy, dx, dy, moveNumber);
                if (i >= numberChildren - 1) continue;
                dy += this.m_nodeFullSize;
            }
            if (numberChildren > 1) {
                GameTreeJunction junction = new GameTreeJunction(childrenDy, this);
                this.add(junction);
                this.putConstraint(gameNode, junction, 0, this.m_nodeFullSize);
            }
        } else if (this.m_showSubtreeSizes && node.hasChildren()) {
            int subtreeSize = NodeUtil.subtreeSize(node) - 1;
            String text = Integer.toString(subtreeSize);
            int textWidth = text.length() + this.m_font.getSize();
            int textHeight = this.m_font.getSize();
            int pad = 2;
            this.m_maxX = Math.max(x + textWidth + pad, this.m_maxX);
            JLabel label = new JLabel(text);
            label.setFont(this.m_font);
            this.add(label);
            this.putConstraint(gameNode, label, dx + pad, (this.m_nodeSize - textHeight) / 2);
        }
        if (node == this.m_currentNode) {
            this.m_currentNodeX = x;
            this.m_currentNodeY = y;
        }
        return dy;
    }

    private void createPopup() {
        this.m_popup = new JPopupMenu();
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String command = event.getActionCommand();
                if (command.equals("goto")) {
                    GameTreePanel.this.gotoNode(GameTreePanel.this.m_popupNode);
                } else if (command.equals("show-variations")) {
                    GameTreePanel.this.showChildren(GameTreePanel.this.m_popupNode);
                } else if (command.equals("show-subtree")) {
                    GameTreePanel.this.showSubtree(GameTreePanel.this.m_popupNode);
                } else if (command.equals("hide-others")) {
                    GameTreePanel.this.hideOthers(GameTreePanel.this.m_popupNode);
                } else if (command.equals("hide-subtree")) {
                    GameTreePanel.this.hideSubtree(GameTreePanel.this.m_popupNode);
                } else if (command.equals("node-info")) {
                    GameTreePanel.this.nodeInfo(GameTreePanel.this.m_popupLocation, GameTreePanel.this.m_popupNode);
                } else if (command.equals("scroll-to-current")) {
                    GameTreePanel.this.scrollTo(GameTreePanel.this.m_currentNode);
                } else if (command.equals("tree-info")) {
                    GameTreePanel.this.treeInfo(GameTreePanel.this.m_popupLocation, GameTreePanel.this.m_popupNode);
                } else if (command.equals("cancel")) {
                    GameTreePanel.this.m_popup.setVisible(false);
                } else assert (false);
            }
        };
        JMenuItem item = new JMenuItem(I18n.i18n("MN_TREE_GOTO"));
        item.setActionCommand("goto");
        item.addActionListener(listener);
        this.m_popup.add(item);
        this.m_itemGoto = item;
        item = new JMenuItem(I18n.i18n("MN_TREE_SCROLL_TO_CURRENT"));
        item.setActionCommand("scroll-to-current");
        item.addActionListener(listener);
        this.m_popup.add(item);
        this.m_itemScrollToCurrent = item;
        this.m_popup.addSeparator();
        this.m_itemHideSubtree = item = new JMenuItem(I18n.i18n("MN_TREE_HIDE_SUBTREE"));
        item.setActionCommand("hide-subtree");
        item.addActionListener(listener);
        this.m_popup.add(item);
        item = new JMenuItem(I18n.i18n("MN_TREE_HIDE_OTHERS"));
        item.setActionCommand("hide-others");
        item.addActionListener(listener);
        this.m_popup.add(item);
        this.m_itemShowChildren = item = new JMenuItem(I18n.i18n("MN_TREE_SHOW_CHILDREN"));
        item.setActionCommand("show-variations");
        item.addActionListener(listener);
        this.m_popup.add(item);
        this.m_itemShowSubtree = item = new JMenuItem(I18n.i18n("MN_TREE_SHOW_SUBTREE"));
        item.setActionCommand("show-subtree");
        item.addActionListener(listener);
        this.m_popup.add(item);
        this.m_popup.addSeparator();
        item = new JMenuItem(I18n.i18n("MN_TREE_NODE_INFO"));
        item.setActionCommand("node-info");
        item.addActionListener(listener);
        this.m_popup.add(item);
        item = new JMenuItem(I18n.i18n("MN_TREE_SUBTREE_STATISTICS"));
        item.setActionCommand("tree-info");
        item.addActionListener(listener);
        this.m_popup.add(item);
        this.m_popup.addSeparator();
        item = new JMenuItem(I18n.i18n("LB_CANCEL"));
        item.setActionCommand("cancel");
        item.addActionListener(listener);
        this.m_popup.add(item);
    }

    private GameTreeNode getGameTreeNode(ConstNode node) {
        return this.m_map.get(node);
    }

    private boolean ensureVisible(ConstNode node) {
        boolean changed = false;
        while (node != null) {
            ConstNode father = node.getFatherConst();
            if (father != null && this.m_isExpanded.add(father)) {
                changed = true;
            }
            node = father;
        }
        return changed;
    }

    private void hideOthers(ConstNode node) {
        this.m_isExpanded.clear();
        this.ensureVisible(node);
        this.update(this.m_tree, this.m_currentNode, this.getWidth(), this.getHeight());
    }

    private void hideSubtree(ConstNode root) {
        boolean changed = false;
        boolean currentChanged = false;
        int depth = NodeUtil.getDepth(root);
        ConstNode node = root;
        while (node != null) {
            if (node == this.m_currentNode) {
                this.m_currentNode = root;
                currentChanged = true;
                changed = true;
            }
            if (this.m_isExpanded.remove(node)) {
                changed = true;
            }
            node = NodeUtil.nextNode(node, depth);
        }
        if (currentChanged) {
            this.gotoNode(this.m_currentNode);
            root = this.m_currentNode;
        }
        if (changed) {
            this.update(this.m_tree, this.m_currentNode, this.getWidth(), this.getHeight());
            this.scrollTo(root);
        }
    }

    private void nodeInfo(Point location, ConstNode node) {
        String nodeInfo = NodeUtil.nodeInfo(node);
        String title = I18n.i18n("TIT_NODE_INFO");
        TextViewer textViewer = new TextViewer(this.m_owner, title, nodeInfo, true, null);
        textViewer.setLocation(location);
        textViewer.setVisible(true);
    }

    private void putConstraint(Component father, Component son, int west, int north) {
        SpringLayout layout = (SpringLayout)this.getLayout();
        layout.putConstraint("West", son, west, "West", father);
        layout.putConstraint("North", son, north, "North", father);
    }

    private void scrollTo(ConstNode node) {
        if (node == null) {
            return;
        }
        GameTreeNode gameNode = this.getGameTreeNode(node);
        Rectangle rectangle = new Rectangle();
        rectangle.x = gameNode.getLocation().x;
        rectangle.y = gameNode.getLocation().y;
        rectangle.width = 3 * this.m_nodeFullSize;
        rectangle.height = 3 * this.m_nodeFullSize;
        this.scrollRectToVisible(rectangle);
    }

    private void showPopup(int x, int y, GameTreeNode gameNode) {
        ConstNode node;
        this.m_popupNode = node = gameNode.getNode();
        if (this.m_popup == null) {
            this.createPopup();
        }
        this.m_itemGoto.setEnabled(node != this.m_currentNode);
        this.m_itemScrollToCurrent.setEnabled(node != this.m_currentNode);
        boolean hasChildren = node.hasChildren();
        this.m_itemHideSubtree.setEnabled(hasChildren);
        this.m_itemShowSubtree.setEnabled(hasChildren);
        this.m_itemShowChildren.setEnabled(hasChildren);
        this.m_popup.show(gameNode, x, y);
        this.m_popupLocation = this.m_popup.getLocationOnScreen();
    }

    private void showSubtree(ConstNode root) {
        String optionalMessage;
        String mainMessage;
        if (NodeUtil.subtreeGreaterThan(root, 10000) && !this.m_messageDialogs.showWarningQuestion(this.m_owner, mainMessage = I18n.i18n("MSG_TREE_EXPAND_LARGE"), optionalMessage = I18n.i18n("MSG_TREE_EXPAND_LARGE_2"), I18n.i18n("LB_TREE_EXPAND"), true)) {
            return;
        }
        boolean changed = false;
        ConstNode node = root;
        int depth = NodeUtil.getDepth(node);
        while (node != null) {
            if (this.m_isExpanded.add(node)) {
                changed = true;
            }
            node = NodeUtil.nextNode(node, depth);
        }
        if (changed) {
            this.update(this.m_tree, this.m_currentNode, this.m_minWidth, this.m_minHeight);
            if (this.getGameTreeNode(root) == null) {
                this.ensureVisible(root);
                this.update(this.m_tree, this.m_currentNode, this.m_minWidth, this.m_minHeight);
            }
            this.scrollTo(root);
        }
    }

    private void showChildren(ConstNode node) {
        if (this.m_isExpanded.add(node)) {
            this.update(this.m_tree, this.m_currentNode, this.m_minWidth, this.m_minHeight);
            this.scrollTo(node);
        }
    }

    private void treeInfo(Point location, ConstNode node) {
        String treeInfo = NodeUtil.treeInfo(node);
        String title = I18n.i18n("TIT_SUBTREE_INFO");
        TextViewer textViewer = new TextViewer(this.m_owner, title, treeInfo, true, null);
        textViewer.setLocation(location);
        textViewer.setVisible(true);
    }

    private static class MouseMotionListener
    extends MouseMotionAdapter {
        private MouseMotionListener() {
        }

        public void mouseDragged(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            JPanel panel = (JPanel)event.getSource();
            Rectangle rectangle = new Rectangle(x, y, 1, 1);
            panel.scrollRectToVisible(rectangle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Size {
        LARGE,
        NORMAL,
        SMALL,
        TINY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Label {
        NUMBER,
        MOVE,
        NONE;

    }
}

