/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import net.sf.gogui.gui.GuiUtil;

public abstract class GuiAction
extends AbstractAction {
    public static final ArrayList<GuiAction> s_allActions = new ArrayList();
    private static final int SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private String m_nameWithMnemonic;

    public GuiAction(String name) {
        this(name, null, null, 0, null);
    }

    public GuiAction(String name, String desc) {
        this(name, desc, null, 0, null);
    }

    public GuiAction(String name, String desc, String icon) {
        this(name, desc, null, 0, icon);
    }

    public GuiAction(String name, String desc, int accel, String icon) {
        this(name, desc, accel, SHORTCUT, icon);
    }

    public GuiAction(String name, String desc, int accel) {
        this(name, desc, accel, SHORTCUT, null);
    }

    public GuiAction(String name, String desc, int accel, int modifier) {
        this(name, desc, accel, modifier, null);
    }

    public GuiAction(String name, String desc, Integer accel, int modifier, String icon) {
        this.m_nameWithMnemonic = name;
        name = name.replace("&", "");
        this.putValue("Name", name);
        if (desc != null) {
            this.putValue("ShortDescription", desc);
        }
        if (accel != null) {
            this.putValue("AcceleratorKey", GuiAction.getKeyStroke(accel, modifier));
        }
        if (icon != null) {
            this.putValue("SmallIcon", GuiUtil.getIcon(icon, name));
        }
        s_allActions.add(this);
    }

    public String getNameWithMnemonic() {
        return this.m_nameWithMnemonic;
    }

    public static void register(JComponent component, GuiAction action) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke != null) {
            String name = (String)action.getValue("Name");
            InputMap inputMap = component.getInputMap(1);
            inputMap.put(keyStroke, name);
            component.getActionMap().put(name, action);
        }
    }

    public static void registerAll(JComponent component) {
        for (GuiAction action : s_allActions) {
            GuiAction.register(component, action);
        }
    }

    public final void setDescription(String desc) {
        if (desc == null) {
            this.putValue("ShortDescription", null);
        } else {
            this.putValue("ShortDescription", desc);
        }
    }

    public void setDescription(String desc, Object ... args) {
        this.putValue("ShortDescription", MessageFormat.format(desc, args));
    }

    public void setSelected(boolean selected) {
        this.putValue("selected", selected);
    }

    private static KeyStroke getKeyStroke(int keyCode, int modifier) {
        return KeyStroke.getKeyStroke(keyCode, modifier);
    }
}

