/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.gui.FileDialogs;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.gui.ObjectListEditor;
import net.sf.gogui.gui.Program;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramEditor
implements ObjectListEditor.ItemEditor<Program> {
    private JPanel m_panelLeft;
    private JPanel m_panelRight;
    private JTextField m_label;
    private JTextField m_name;
    private JTextField m_version;
    private JTextField m_command;
    private JTextField m_workingDirectory;
    private JDialog m_dialog;
    private boolean m_editOnlyCommand;
    private boolean m_editOnlyLabel;

    @Override
    public Program editItem(Component parent, Program object, MessageDialogs messageDialogs) {
        return this.editItem(parent, I18n.i18n("TIT_PROGRAMEDIT"), object, false, false, messageDialogs);
    }

    public Program editItem(Component parent, String title, Program program, boolean editOnlyCommand, boolean editOnlyLabel, MessageDialogs messageDialogs) {
        this.m_editOnlyCommand = editOnlyCommand;
        this.m_editOnlyLabel = editOnlyLabel;
        JPanel panel = new JPanel(new BorderLayout(2, 0));
        Box box = null;
        if (editOnlyCommand || editOnlyLabel) {
            String optionalMessage;
            String mainMessage;
            box = Box.createVerticalBox();
            panel.add((Component)box, "North");
            if (editOnlyCommand) {
                mainMessage = I18n.i18n("MSG_PROGRAMEDIT_EDIT_COMMAND");
                optionalMessage = I18n.i18n("MSG_PROGRAMEDIT_EDIT_COMMAND_2");
            } else {
                mainMessage = I18n.i18n("MSG_PROGRAMEDIT_EDIT_LABEL");
                optionalMessage = I18n.i18n("MSG_PROGRAMEDIT_EDIT_LABEL_2");
            }
            String css = GuiUtil.getMessageCss();
            JLabel label = new JLabel("<html>" + css + "<b>" + GuiUtil.insertLineBreaks(mainMessage) + "</b><p>" + GuiUtil.insertLineBreaks(optionalMessage) + "</p>");
            label.setAlignmentX(0.0f);
            box.add(label);
            ProgramEditor.addFiller(box);
            ProgramEditor.addFiller(box);
            ProgramEditor.addFiller(box);
        }
        this.m_panelLeft = new JPanel(new GridLayout(0, 1, 0, 5));
        panel.add((Component)this.m_panelLeft, "West");
        this.m_panelRight = new JPanel(new GridLayout(0, 1, 0, 5));
        panel.add((Component)this.m_panelRight, "Center");
        if (!editOnlyCommand) {
            this.m_label = this.createEntry("LB_PROGRAMEDIT_LABEL", 20, program.m_label);
        }
        this.m_command = this.createFileEntry("LB_PROGRAMEDIT_COMMAND", program.m_command, "TT_PROGRAMEDIT_COMMAND", "TIT_PROGRAMEDIT_COMMAND", !this.m_editOnlyLabel);
        this.m_workingDirectory = this.createEntry("LB_PROGRAMEDIT_DIR", 30, program.m_workingDirectory, !this.m_editOnlyLabel);
        if (!editOnlyCommand) {
            this.m_name = this.createEntry("LB_PROGRAMEDIT_NAME", 20, program.m_name, false);
            this.m_version = this.createEntry("LB_PROGRAMEDIT_VERSION", 20, program.m_version, false);
        }
        JOptionPane optionPane = new JOptionPane(panel, -1, 2);
        this.m_dialog = optionPane.createDialog(parent, title);
        this.m_dialog.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                if (ProgramEditor.this.m_label == null) {
                    ProgramEditor.this.m_command.requestFocusInWindow();
                } else {
                    ProgramEditor.this.m_label.requestFocusInWindow();
                }
            }
        });
        if (box != null) {
            box.invalidate();
            this.m_dialog.pack();
        }
        boolean done = false;
        while (!done) {
            this.m_dialog.setVisible(true);
            Object value = optionPane.getValue();
            if (!(value instanceof Integer) || (Integer)value != 0) {
                return null;
            }
            done = this.validate(parent, messageDialogs);
        }
        String newLabel = "";
        String newName = "";
        String newVersion = "";
        if (!editOnlyCommand) {
            newLabel = this.m_label.getText().trim();
            newName = this.m_name.getText().trim();
            newVersion = this.m_version.getText().trim();
        }
        String newCommand = this.m_command.getText().trim();
        String newWorkingDirectory = this.m_workingDirectory.getText().trim();
        Program newProgram = new Program(newLabel, newName, newVersion, newCommand, newWorkingDirectory);
        this.m_dialog.dispose();
        return newProgram;
    }

    @Override
    public String getItemLabel(Program object) {
        return object.m_label;
    }

    @Override
    public Program cloneItem(Program object) {
        return new Program(object);
    }

    private static void addFiller(JComponent component) {
        Box.Filler filler = GuiUtil.createFiller();
        filler.setAlignmentX(0.0f);
        component.add(filler);
    }

    private JTextField createEntry(String labelText, int cols, String text) {
        return this.createEntry(labelText, cols, text, true);
    }

    private JTextField createEntry(String labelText, int cols, String text, boolean editable) {
        JComponent label = this.createEntryLabel(labelText);
        this.m_panelLeft.add(label);
        Box box = Box.createVerticalBox();
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        box.add(Box.createVerticalGlue());
        box.add(panel);
        box.add(Box.createVerticalGlue());
        JTextField field = new JTextField(cols);
        field.setText(text);
        if (!editable) {
            GuiUtil.setEditableFalse(field);
        }
        panel.add(field);
        this.m_panelRight.add(box);
        return field;
    }

    private JComponent createEntryLabel(String text) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JLabel label = new JLabel(I18n.i18n(text));
        label.setAlignmentY(0.5f);
        box.add(label);
        return box;
    }

    private JTextField createFileEntry(String label, String text, String browseToolTip, final String title, boolean editable) {
        this.m_panelLeft.add(this.createEntryLabel(label));
        Box box = Box.createVerticalBox();
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        box.add(Box.createVerticalGlue());
        box.add(panel);
        box.add(Box.createVerticalGlue());
        final JTextField field = new JTextField(30);
        field.setText(text);
        panel.add(field);
        if (editable) {
            panel.add(GuiUtil.createSmallFiller());
            JButton button = new JButton();
            panel.add(button);
            button.setIcon(GuiUtil.getIcon("document-open-16x16", I18n.i18n("LB_BROWSE")));
            GuiUtil.setMacBevelButton(button);
            button.setToolTipText(I18n.i18n(browseToolTip));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File file = FileDialogs.showOpen(ProgramEditor.this.m_dialog, I18n.i18n(title));
                    if (file == null) {
                        return;
                    }
                    String text = file.toString();
                    if (text.indexOf(32) >= 0) {
                        text = "\"" + text + "\"";
                    }
                    field.setText(text);
                    field.setCaretPosition(text.length());
                    field.requestFocusInWindow();
                }
            });
        } else {
            GuiUtil.setEditableFalse(field);
        }
        this.m_panelRight.add(box);
        return field;
    }

    private boolean validate(Component parent, MessageDialogs messageDialogs) {
        if (!this.m_editOnlyCommand && StringUtil.isEmpty(this.m_label.getText())) {
            String mainMessage = I18n.i18n("MSG_PROGRAMEDIT_EMPTY_LABEL");
            String optionalMessage = I18n.i18n("MSG_PROGRAMEDIT_EMPTY_LABEL_2");
            messageDialogs.showError(parent, mainMessage, optionalMessage, false);
            return false;
        }
        if (this.m_command.getText().trim().equals("")) {
            String mainMessage = I18n.i18n("MSG_PROGRAMEDIT_EMPTY_COMMAND");
            String optionalMessage = I18n.i18n("MSG_PROGRAMEDIT_EMPTY_COMMAND_2");
            messageDialogs.showError(parent, mainMessage, optionalMessage, false);
            return false;
        }
        String workingDirectory = this.m_workingDirectory.getText().trim();
        if (!workingDirectory.equals("") && !new File(workingDirectory).isDirectory()) {
            String mainMessage = I18n.i18n("MSG_PROGRAMEDIT_INVALID_DIR");
            String optionalMessage = I18n.i18n("MSG_PROGRAMEDIT_INVALID_DIR_2");
            messageDialogs.showError(parent, mainMessage, optionalMessage, false);
            return false;
        }
        return true;
    }
}

