/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import net.sf.gogui.gui.GuiMenu;
import net.sf.gogui.gui.RecentMenuItem;
import net.sf.gogui.util.PrefUtil;

public final class RecentMenu {
    public static final int MAX_ITEMS = 10;
    private final String m_path;
    private final ActionListener m_actionListener;
    private final Listener m_listener;
    private final GuiMenu m_menu;

    public RecentMenu(String text, String path, Listener listener) {
        assert (listener != null);
        this.m_path = path;
        this.m_listener = listener;
        this.m_menu = new GuiMenu(text);
        this.m_actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RecentMenuItem item = (RecentMenuItem)event.getSource();
                String label = item.getRecentMenuLabel();
                String value = item.getRecentMenuValue();
                RecentMenu.this.m_listener.itemSelected(label, value);
            }
        };
        this.get();
        this.updateEnabled();
    }

    public void add(String label, String value) {
        this.addNewItem(label, value);
        this.put();
    }

    public int getCount() {
        return this.m_menu.getMenuComponentCount();
    }

    public GuiMenu getMenu() {
        return this.m_menu;
    }

    public String getValue(int i) {
        return this.getItem(i).getRecentMenuValue();
    }

    public void remove(int i) {
        this.m_menu.remove(this.getItem(i));
        this.relabel();
    }

    public void setLabel(int i, String label) {
        this.getItem(i).setRecentMenuLabel(label);
        this.getItem(i).setPosition(i);
        this.put();
    }

    public void updateEnabled() {
        int count = this.getCount();
        this.m_menu.setEnabled(count > 0);
    }

    private void addNewItem(String label, String value) {
        for (int i = 0; i < this.getCount(); ++i) {
            if (!this.getValue(i).equals(value)) continue;
            this.m_menu.remove(i);
        }
        RecentMenuItem item = new RecentMenuItem(label, value, this.m_actionListener);
        this.m_menu.add((Component)item, 0);
        while (this.getCount() > 10) {
            this.m_menu.remove(this.getCount() - 1);
        }
        this.relabel();
    }

    private void get() {
        Preferences prefs = PrefUtil.getNode(this.m_path);
        if (prefs == null) {
            return;
        }
        int size = prefs.getInt("size", 0);
        if (size < 0) {
            size = 0;
        }
        this.m_menu.removeAll();
        for (int i = 0; i < size && (prefs = PrefUtil.getNode(this.m_path + "/" + i)) != null; ++i) {
            String label = prefs.get("label", null);
            String value = prefs.get("value", null);
            if (label == null || value == null) continue;
            this.addNewItem(label, value);
        }
    }

    private RecentMenuItem getItem(int i) {
        return (RecentMenuItem)this.m_menu.getItem(i);
    }

    private String getLabel(int i) {
        return this.getItem(i).getRecentMenuLabel();
    }

    private void put() {
        Preferences prefs = PrefUtil.createNode(this.m_path);
        if (prefs == null) {
            return;
        }
        int size = this.getCount();
        prefs.putInt("size", size);
        for (int i = 0; i < size && (prefs = PrefUtil.createNode(this.m_path + "/" + (size - i - 1))) != null; ++i) {
            prefs.put("label", this.getLabel(i));
            prefs.put("value", this.getValue(i));
        }
    }

    private void relabel() {
        int size = this.getCount();
        for (int i = 0; i < size; ++i) {
            this.getItem(i).setPosition(i);
        }
    }

    public static interface Listener {
        public void itemSelected(String var1, String var2);
    }
}

