/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.gogui.go.CountScore;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Score;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;

public class ScoreDialog
extends JDialog {
    private final Score.ScoringMethod m_initialRules;
    private final JButton m_cancelButton;
    private final ColorFields m_territory;
    private final ColorFields m_area;
    private final ColorFields m_prisoners;
    private final JTextField m_komi;
    private final JTextField m_resultArea;
    private final JTextField m_resultTerritory;
    private JRadioButton m_useArea;
    private JRadioButton m_useTerritory;
    private final JTextField m_result;
    private Score m_score;
    private static final ImageIcon ICON_BLACK = GuiUtil.getIcon("gogui-black-16x16", I18n.i18n("LB_BLACK"));
    private static final ImageIcon ICON_WHITE = GuiUtil.getIcon("gogui-white-16x16", I18n.i18n("LB_WHITE"));

    public ScoreDialog(Frame owner, final Listener listener, Score.ScoringMethod initialRules) {
        super(owner, I18n.i18n("TIT_SCORE"));
        this.m_initialRules = initialRules;
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                listener.actionScoreDone(null);
                ScoreDialog.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        Box outerBox = Box.createVerticalBox();
        Box box = Box.createHorizontalBox();
        outerBox.add(box);
        JPanel labels = new JPanel(new GridLayout(0, 1, 0, 5));
        box.add(labels);
        box.add(GuiUtil.createSmallFiller());
        JPanel values = new JPanel(new GridLayout(0, 1, 0, 5));
        box.add(values);
        this.m_area = this.createColorEntry("LB_SCORE_AREA", 3, "TT_SCORE_AREA_BLACK", "TT_SCORE_AREA_WHITE", labels, values);
        this.m_territory = this.createColorEntry("LB_SCORE_TERRITORY", 3, "TT_SCORE_TERRITORY_BLACK", "TT_SCORE_TERRITORY_WHITE", labels, values);
        this.m_prisoners = this.createColorEntry("LB_SCORE_PRISONERS", 3, "TT_SCORE_PRISONERS_BLACK", "TT_SCORE_PRISONERS_WHITE", labels, values);
        this.m_komi = this.createKomiEntry(3, labels, values);
        this.m_resultArea = this.createEntry("LB_SCORE_RESULT_AREA", 8, "TT_SCORE_RESULT_AREA", labels, values);
        this.m_resultTerritory = this.createEntry("LB_SCORE_RESULT_TERRITORY", 8, "TT_SCORE_RESULT_TERRITORY", labels, values);
        this.createRulesEntry(labels, values);
        this.m_result = this.createEntry("LB_SCORE_RESULT", 8, "TT_SCORE_RESULT", labels, values);
        JButton okButton = new JButton(I18n.i18n("LB_OK"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                listener.actionScoreDone(ScoreDialog.this.m_score);
            }
        });
        this.m_cancelButton = new JButton(I18n.i18n("LB_CANCEL"));
        this.m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                listener.actionScoreDone(null);
            }
        });
        Object[] options = new Object[]{okButton, this.m_cancelButton};
        JOptionPane optionPane = new JOptionPane(outerBox, -1, 2, null, options, options[0]);
        this.setContentPane(optionPane);
        this.pack();
    }

    public void showScore(CountScore countScore, Komi komi) {
        Score.ScoringMethod rules = this.m_initialRules;
        if (this.m_score != null) {
            rules = this.m_score.m_rules;
        }
        this.m_score = countScore.getScore(komi, rules);
        this.showScore();
    }

    private JComponent createEntryLabel(String text) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JLabel label = new JLabel(I18n.i18n(text));
        label.setAlignmentY(0.5f);
        box.add(label);
        return box;
    }

    private JTextField createEntry(String labelText, int cols, String toolTip, JComponent labels, JComponent values) {
        labels.add(this.createEntryLabel(labelText));
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        JTextField field = new JTextField(cols);
        GuiUtil.setEditableFalse(field);
        field.setHorizontalAlignment(0);
        field.setToolTipText(I18n.i18n(toolTip));
        panel.add(field);
        values.add(panel);
        return field;
    }

    private ColorFields createColorEntry(String labelText, int cols, String toolTipBlack, String toolTipWhite, JComponent labels, JComponent values) {
        labels.add(this.createEntryLabel(labelText));
        ColorFields colorFields = new ColorFields();
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        panel.add(new JLabel(ICON_BLACK));
        panel.add(GuiUtil.createSmallFiller());
        JTextField black = new JTextField(cols);
        black.setHorizontalAlignment(0);
        colorFields.m_black = black;
        GuiUtil.setEditableFalse(black);
        if (toolTipBlack != null) {
            black.setToolTipText(I18n.i18n(toolTipBlack));
        }
        panel.add(black);
        panel.add(GuiUtil.createFiller());
        panel.add(new JLabel(ICON_WHITE));
        panel.add(GuiUtil.createSmallFiller());
        JTextField white = new JTextField(cols);
        white.setHorizontalAlignment(0);
        colorFields.m_white = white;
        GuiUtil.setEditableFalse(white);
        if (toolTipWhite != null) {
            white.setToolTipText(I18n.i18n(toolTipWhite));
        }
        panel.add(white);
        values.add(panel);
        return colorFields;
    }

    private JTextField createKomiEntry(int cols, JComponent labels, JComponent values) {
        labels.add(this.createEntryLabel("LB_SCORE_KOMI"));
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        panel.add(new JLabel(ICON_WHITE));
        panel.add(GuiUtil.createSmallFiller());
        JTextField field = new JTextField(cols);
        field.setHorizontalAlignment(0);
        GuiUtil.setEditableFalse(field);
        field.setToolTipText(I18n.i18n("TT_SCORE_KOMI"));
        panel.add(field);
        values.add(panel);
        return field;
    }

    private void createRulesEntry(JComponent labels, JComponent values) {
        labels.add(this.createEntryLabel("LB_SCORE_METHOD"));
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        ButtonGroup group = new ButtonGroup();
        this.m_useArea = new JRadioButton(I18n.i18n("LB_SCORE_METHOD_AREA"));
        this.m_useArea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ScoreDialog.this.m_score != null) {
                    ScoreDialog.this.m_score.updateRules(Score.ScoringMethod.AREA);
                    ScoreDialog.this.showScore();
                }
            }
        });
        this.m_useArea.setToolTipText(I18n.i18n("TT_SCORE_METHOD_AREA"));
        group.add(this.m_useArea);
        panel.add(this.m_useArea);
        panel.add(GuiUtil.createFiller());
        this.m_useTerritory = new JRadioButton(I18n.i18n("LB_SCORE_METHOD_TERRITORY"));
        this.m_useTerritory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ScoreDialog.this.m_score != null) {
                    ScoreDialog.this.m_score.updateRules(Score.ScoringMethod.TERRITORY);
                    ScoreDialog.this.showScore();
                }
            }
        });
        this.m_useTerritory.setToolTipText(I18n.i18n("TT_SCORE_METHOD_TERRITORY"));
        group.add(this.m_useTerritory);
        panel.add(this.m_useTerritory);
        values.add(panel);
    }

    private static void setTextInteger(JTextField field, int value) {
        field.setText(Integer.toString(value));
    }

    private void showScore() {
        if (this.m_score == null) {
            return;
        }
        ScoreDialog.setTextInteger(this.m_territory.m_black, this.m_score.m_territoryBlack);
        ScoreDialog.setTextInteger(this.m_territory.m_white, this.m_score.m_territoryWhite);
        ScoreDialog.setTextInteger(this.m_area.m_black, this.m_score.m_areaBlack);
        ScoreDialog.setTextInteger(this.m_area.m_white, this.m_score.m_areaWhite);
        ScoreDialog.setTextInteger(this.m_prisoners.m_black, this.m_score.m_capturedWhite);
        ScoreDialog.setTextInteger(this.m_prisoners.m_white, this.m_score.m_capturedBlack);
        if (this.m_score.m_komi != null) {
            this.m_komi.setText(this.m_score.m_komi.toString());
        }
        double resultArea = this.m_score.m_resultArea;
        this.m_resultArea.setText(Score.formatResult(resultArea));
        double resultTerritory = this.m_score.m_resultTerritory;
        this.m_resultTerritory.setText(Score.formatResult(resultTerritory));
        if (this.m_score.m_rules == Score.ScoringMethod.TERRITORY) {
            this.m_useTerritory.setSelected(true);
        } else {
            assert (this.m_score.m_rules == Score.ScoringMethod.AREA);
            this.m_useArea.setSelected(true);
        }
        this.m_result.setText(this.m_score.formatResult());
    }

    private static class ColorFields {
        public JTextField m_black;
        public JTextField m_white;

        private ColorFields() {
        }
    }

    public static interface Listener {
        public void actionScoreDone(Score var1);
    }
}

