/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import net.sf.gogui.game.Clock;
import net.sf.gogui.game.ConstClock;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.Game;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;

public final class TimeLeftDialog
extends JOptionPane {
    private final PlayerTime m_black;
    private final PlayerTime m_white;

    public static void show(Component parent, Game game, ConstNode node, MessageDialogs messageDialogs) {
        ConstGameInfo info = game.getGameInfoNode(node).getGameInfoConst();
        Clock clock = null;
        TimeSettings timeSettings = info.getTimeSettings();
        if (timeSettings != null) {
            clock = new Clock();
            clock.setTimeSettings(timeSettings);
            NodeUtil.restoreClock(node, clock);
        }
        TimeLeftDialog timeLeftDialog = new TimeLeftDialog(clock);
        JDialog dialog = timeLeftDialog.createDialog(parent, I18n.i18n("TIT_TIME_LEFT"));
        boolean done = false;
        while (!done) {
            dialog.setVisible(true);
            Object value = timeLeftDialog.getValue();
            if (!(value instanceof Integer) || (Integer)value != 0) {
                return;
            }
            done = timeLeftDialog.validate(parent, messageDialogs);
        }
        for (GoColor c : GoColor.BLACK_WHITE) {
            long timeLeft = timeLeftDialog.getTimeLeft(c);
            game.setTimeLeft(node, c, timeLeft / 1000L);
            int movesLeft = timeLeftDialog.getMovesLeft(c);
            if (movesLeft >= 0) {
                game.setMovesLeft(node, c, movesLeft);
            }
            game.restoreClock();
        }
        dialog.dispose();
    }

    private TimeLeftDialog(ConstClock clock) {
        Box box = Box.createVerticalBox();
        this.m_white = this.createPlayerTime(GoColor.WHITE, clock);
        this.m_white.m_box.setAlignmentX(0.0f);
        box.add(this.m_white.m_box);
        box.add(GuiUtil.createFiller());
        this.m_black = this.createPlayerTime(GoColor.BLACK, clock);
        this.m_black.m_box.setAlignmentX(0.0f);
        box.add(this.m_black.m_box);
        this.setMessage(box);
        this.setOptionType(2);
    }

    private PlayerTime createPlayerTime(GoColor c, ConstClock clock) {
        String tooltipMovesLeft;
        String tooltipTimeLeft;
        JLabel label;
        assert (c.isBlackWhite());
        PlayerTime playerInfo = new PlayerTime();
        Box box = Box.createHorizontalBox();
        if (c == GoColor.BLACK) {
            label = new JLabel(GuiUtil.getIcon("gogui-black-16x16", I18n.i18n("LB_BLACK")));
            tooltipTimeLeft = "TT_TIMELEFT_TIME_BLACK";
            tooltipMovesLeft = "TT_TIMELEFT_MOVES_BLACK";
        } else {
            label = new JLabel(GuiUtil.getIcon("gogui-white-16x16", I18n.i18n("LB_WHITE")));
            tooltipTimeLeft = "TT_TIMELEFT_TIME_WHITE";
            tooltipMovesLeft = "TT_TIMELEFT_MOVES_WHITE";
        }
        label.setAlignmentY(0.5f);
        box.add(label);
        box.add(GuiUtil.createFiller());
        playerInfo.m_box = box;
        playerInfo.m_timeLeft = new JTextField(9);
        playerInfo.m_timeLeft.setToolTipText(I18n.i18n(tooltipTimeLeft));
        box.add(playerInfo.m_timeLeft);
        playerInfo.m_timeLeft.setHorizontalAlignment(0);
        box.add(GuiUtil.createFiller());
        playerInfo.m_movesLeft = new JTextField(3);
        playerInfo.m_movesLeft.setHorizontalAlignment(0);
        playerInfo.m_movesLeft.setToolTipText(I18n.i18n(tooltipMovesLeft));
        box.add(playerInfo.m_movesLeft);
        if (clock != null) {
            String timeLeft = Clock.getTimeString(clock.getTimeLeft(c) / 1000L, -1);
            playerInfo.m_timeLeft.setText(timeLeft);
            if (clock.getUseByoyomi() && clock.isInByoyomi(c)) {
                String movesLeft = Integer.toString(clock.getMovesLeft(c));
                playerInfo.m_movesLeft.setText(movesLeft);
            }
        }
        box.setAlignmentY(0.5f);
        return playerInfo;
    }

    private int getMovesLeft(GoColor c) {
        JTextField textField;
        JTextField jTextField = textField = c == GoColor.BLACK ? this.m_black.m_movesLeft : this.m_white.m_movesLeft;
        if (this.isEmpty(textField)) {
            return -1;
        }
        return Integer.parseInt(TimeLeftDialog.getTextFieldContent(textField));
    }

    private static String getTextFieldContent(JTextField textField) {
        return textField.getText().trim();
    }

    private long getTimeLeft(GoColor c) {
        JTextField textField = c == GoColor.BLACK ? this.m_black.m_timeLeft : this.m_white.m_timeLeft;
        long timeLeft = Clock.parseTimeString(TimeLeftDialog.getTextFieldContent(textField));
        assert (timeLeft >= 0L);
        return timeLeft;
    }

    private boolean isEmpty(JTextField textField) {
        return TimeLeftDialog.getTextFieldContent(textField).equals("");
    }

    private boolean validate(Component parent, MessageDialogs messageDialogs) {
        return this.validatePosIntOrEmpty(parent, this.m_black.m_movesLeft, "MSG_TIMELEFT_INVALID_MOVESLEFT", messageDialogs) && this.validatePosIntOrEmpty(parent, this.m_white.m_movesLeft, "MSG_TIMELEFT_INVALID_MOVESLEFT", messageDialogs) && this.validateTime(parent, this.m_black.m_timeLeft, "MSG_TIMELEFT_INVALID_TIMELEFT", messageDialogs) && this.validateTime(parent, this.m_white.m_timeLeft, "MSG_TIMELEFT_INVALID_TIMELEFT", messageDialogs);
    }

    private boolean validatePosIntOrEmpty(Component parent, JTextField textField, String errorMessage, MessageDialogs messageDialogs) {
        try {
            String content = TimeLeftDialog.getTextFieldContent(textField);
            if (content.trim().equals("")) {
                return true;
            }
            int value = Integer.parseInt(content);
            if (value < 0) {
                messageDialogs.showError(parent, I18n.i18n(errorMessage), I18n.i18n("MSG_TIMELEFT_NEGATIVE_NUMBER"), false);
                return false;
            }
        }
        catch (NumberFormatException e) {
            messageDialogs.showError(parent, I18n.i18n(errorMessage), I18n.i18n("MSG_TIMELEFT_NO_NUMBER"), false);
            return false;
        }
        return true;
    }

    private boolean validateTime(Component parent, JTextField textField, String errorMessage, MessageDialogs messageDialogs) {
        long timeLeft = Clock.parseTimeString(TimeLeftDialog.getTextFieldContent(textField));
        if (timeLeft < 0L) {
            messageDialogs.showError(parent, I18n.i18n(errorMessage), I18n.i18n("MSG_TIMELEFT_NO_TIME"), false);
            return false;
        }
        return true;
    }

    private static class PlayerTime {
        public Box m_box;
        public JTextField m_timeLeft;
        public JTextField m_movesLeft;

        private PlayerTime() {
        }
    }
}

