/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.AnalyzeDefinition;
import net.sf.gogui.gtp.AnalyzeType;
import net.sf.gogui.gtp.AnalyzeUtil;
import net.sf.gogui.gtp.GtpClientBase;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.util.ErrorMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GtpClientUtil {
    public static String getAnalyzeCommands(GtpClientBase gtp) {
        String command;
        if (gtp.isSupported("gogui-analyze_commands")) {
            command = "gogui-analyze_commands";
        } else if (gtp.isSupported("gogui_analyze_commands")) {
            command = "gogui_analyze_commands";
        } else {
            return null;
        }
        try {
            return gtp.send(command);
        }
        catch (GtpError e) {
            return null;
        }
    }

    public static String getPlaySequenceCommand(GtpClientBase gtp, ArrayList<Move> moves) {
        assert (GtpClientUtil.isPlaySequenceSupported(gtp));
        StringBuilder cmd = new StringBuilder(2048);
        cmd.append(GtpClientUtil.getPlaySequenceCommand(gtp));
        for (int i = 0; i < moves.size(); ++i) {
            cmd.append(' ');
            cmd.append(moves.get(i));
        }
        return cmd.toString();
    }

    public static String getPlaySequenceCommand(GtpClientBase gtp) {
        if (gtp.isSupported("gogui-play_sequence")) {
            return "gogui-play_sequence";
        }
        if (gtp.isSupported("play_sequence")) {
            return "play_sequence";
        }
        return null;
    }

    public static String getTitle(GtpClientBase gtp) {
        try {
            if (gtp.isSupported("gogui-title")) {
                return gtp.send("gogui-title");
            }
            if (gtp.isSupported("gogui_title")) {
                return gtp.send("gogui_title");
            }
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
        return null;
    }

    public static boolean isPlaySequenceSupported(GtpClientBase gtp) {
        return GtpClientUtil.getPlaySequenceCommand(gtp) != null;
    }

    public static void saveParameters(GtpClientBase gtp, ArrayList<AnalyzeDefinition> analyzeCommands, File file) throws ErrorMessage {
        PrintStream out = null;
        try {
            out = new PrintStream(file);
            for (AnalyzeDefinition definition : analyzeCommands) {
                String line;
                String response;
                if (definition.getType() != AnalyzeType.PARAM) continue;
                out.print("# ");
                out.println(definition.getLabel());
                try {
                    response = gtp.send(definition.getCommand());
                }
                catch (GtpError e) {
                    out.print("# ? ");
                    out.println(e.getMessage());
                    out.println();
                    if (!gtp.isProgramDead()) continue;
                    throw new ErrorMessage("The Go program has terminated.");
                }
                BufferedReader reader = new BufferedReader(new StringReader(response));
                while ((line = reader.readLine()) != null) {
                    AnalyzeUtil.Result result = AnalyzeUtil.parseParameterLine(line);
                    if (result == null) continue;
                    String command = AnalyzeUtil.getParameterCommand(definition.getCommand(), result.m_key, result.m_value);
                    out.println(command);
                }
                out.println();
            }
        }
        catch (IOException e) {
            throw new ErrorMessage(e.getMessage());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private GtpClientUtil() {
    }
}

