/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.InvalidPointException;
import net.sf.gogui.go.PointList;
import net.sf.gogui.gtp.GtpCallback;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.ReadThread;

public class GtpEngine {
    private volatile boolean m_interrupted;
    private boolean m_quit;
    private String m_name = "Unknown";
    private String m_version;
    private final Map<String, GtpCallback> m_commands = new TreeMap<String, GtpCallback>();
    private InputStream m_in;
    private final PrintStream m_log;
    private PrintStream m_out;

    public GtpEngine(PrintStream log) {
        this.m_log = log;
        this.register("known_command", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                GtpEngine.this.cmdKnownCommand(cmd);
            }
        });
        this.register("list_commands", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                GtpEngine.this.cmdListCommands(cmd);
            }
        });
        this.register("name", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                GtpEngine.this.cmdName(cmd);
            }
        });
        this.register("protocol_version", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                GtpEngine.this.cmdProtocolVersion(cmd);
            }
        });
        this.register("quit", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                GtpEngine.this.cmdQuit(cmd);
            }
        });
        this.register("version", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                GtpEngine.this.cmdVersion(cmd);
            }
        });
    }

    public void cmdKnownCommand(GtpCommand cmd) throws GtpError {
        String name = cmd.getArg();
        cmd.setResponse(this.m_commands.containsKey(name) ? "true" : "false");
    }

    public void cmdListCommands(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        StringBuilder response = cmd.getResponse();
        Iterator<String> it = this.m_commands.keySet().iterator();
        while (it.hasNext()) {
            response.append((Object)it.next());
            response.append('\n');
        }
    }

    public void cmdName(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        cmd.setResponse(this.m_name);
    }

    public void cmdProtocolVersion(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        cmd.setResponse("2");
    }

    public void cmdQuit(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        this.setQuit();
    }

    public void cmdUnknown(GtpCommand cmd) throws GtpError {
        throw new GtpError("unknown command: " + cmd.getCommand());
    }

    public void cmdVersion(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        cmd.setResponse(this.m_version);
    }

    public void interruptCommand() {
        this.m_interrupted = true;
    }

    public void handleCommand(GtpCommand cmd) throws GtpError {
        this.m_interrupted = false;
        String name = cmd.getCommand();
        GtpCallback callback = this.m_commands.get(name);
        if (callback == null) {
            this.cmdUnknown(cmd);
        } else {
            callback.run(cmd);
        }
    }

    public boolean isRegistered(String command) {
        return this.m_commands.containsKey(command);
    }

    public synchronized void log(String line) {
        assert (this.m_log != null);
        this.m_log.println(line);
    }

    public void mainLoop(InputStream in, OutputStream out) throws IOException {
        GtpCommand cmd;
        this.m_out = new PrintStream(out);
        this.m_in = in;
        ReadThread readThread = new ReadThread(this, this.m_in, this.m_log != null);
        readThread.start();
        do {
            String response;
            if ((cmd = readThread.getCommand()) == null) {
                return;
            }
            boolean status = true;
            try {
                this.handleCommand(cmd);
                response = cmd.getResponse().toString();
            }
            catch (GtpError e) {
                response = e.getMessage();
                status = false;
            }
            String sanitizedResponse = response.replaceAll("\\n\\n", "\n \n");
            this.respond(status, cmd.hasId(), cmd.getId(), sanitizedResponse);
        } while (!this.m_quit && !cmd.isQuit());
    }

    public static GoPoint parsePointArgument(String[] cmdArray, int boardSize) throws GtpError {
        if (cmdArray.length != 2) {
            throw new GtpError("Missing point argument");
        }
        try {
            return GoPoint.parsePoint(cmdArray[1], boardSize);
        }
        catch (InvalidPointException e) {
            throw new GtpError(e.getMessage());
        }
    }

    public static PointList parsePointListArgument(String[] cmdArray, int boardSize) throws GtpError {
        try {
            int length = cmdArray.length;
            assert (length >= 1);
            PointList pointList = new PointList();
            for (int i = 1; i < length; ++i) {
                GoPoint p = GoPoint.parsePoint(cmdArray[i], boardSize);
                pointList.add(p);
            }
            return pointList;
        }
        catch (InvalidPointException e) {
            throw new GtpError(e.getMessage());
        }
    }

    public void printInvalidResponse(String text) {
        this.m_out.print(text);
    }

    public final void register(String command, GtpCallback callback) {
        this.unregister(command);
        this.m_commands.put(command, callback);
    }

    public void respond(boolean status, boolean hasId, int id, String response) {
        StringBuilder fullResponse = new StringBuilder(256);
        if (status) {
            fullResponse.append('=');
        } else {
            fullResponse.append('?');
        }
        if (hasId) {
            fullResponse.append(id);
        }
        fullResponse.append(' ');
        fullResponse.append(response);
        if (response.length() == 0 || response.charAt(response.length() - 1) != '\n') {
            fullResponse.append('\n');
        }
        this.m_out.println(fullResponse);
        if (this.m_log != null) {
            this.m_log.println(fullResponse);
        }
    }

    public void setQuit() {
        this.m_quit = true;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public final void unregister(String command) {
        if (this.m_commands.containsKey(command)) {
            this.m_commands.remove(command);
        }
    }

    protected boolean isInterrupted() {
        return this.m_interrupted;
    }
}

