/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.regress;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.tools.regress.RegressUtil;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.FileUtil;
import net.sf.gogui.util.HtmlUtil;
import net.sf.gogui.util.Platform;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Regress
implements GtpClient.IOCallback {
    private boolean m_lastError;
    private final boolean m_longOutput;
    private boolean m_result;
    private final boolean m_verbose;
    private int m_lastCommandId;
    private int m_lastSgfMove;
    private int m_otherErrors;
    private File m_testFile;
    private PrintStream m_out;
    private static final String COLOR_ERROR = "#ffa954";
    private static final String COLOR_HEADER = "#91aee8";
    private static final String COLOR_INFO = "#e0e0e0";
    private static final String COLOR_BG_LIGHT = "#e0e0e0";
    private static final String COLOR_BG_GRAY = "#e0e0e0";
    private static final String COLOR_GREEN = "#5eaf5e";
    private static final String COLOR_RED = "#ff5454";
    private File m_outFile;
    private final File m_gtpFile;
    private String m_currentStyle;
    private String m_lastCommand;
    private String m_lastFullResponse;
    private String m_lastResponse;
    private String m_lastSgf;
    private String m_name;
    private String m_outName;
    private String m_outFileRelativeName;
    private String m_outPrefix;
    private final String m_prefix;
    private final String m_program;
    private String m_relativePath;
    private String m_version;
    private TreeMap<String, String> m_outNames;
    private final ArrayList<Test> m_tests = new ArrayList();
    private final ArrayList<TestSummary> m_testSummaries = new ArrayList();
    private GtpClient m_gtp;

    public Regress(String program, ArrayList<String> tests, String output, boolean longOutput, boolean verbose, File gtpFile) throws Exception {
        tests = RegressUtil.expandTestSuites(tests);
        RegressUtil.checkFiles(tests);
        this.m_result = true;
        this.m_program = program;
        this.m_longOutput = longOutput;
        this.m_verbose = verbose;
        this.m_gtpFile = gtpFile;
        if (output.equals("")) {
            this.m_prefix = "";
        } else {
            File file = new File(output);
            if (!file.exists() && !file.mkdir()) {
                throw new ErrorMessage("Could not create output directory '" + output + "'");
            }
            this.m_prefix = output + File.separator;
        }
        this.initOutNames(tests);
        for (int i = 0; i < tests.size(); ++i) {
            String test = tests.get(i);
            this.m_outPrefix = tests.size() > 1 ? test + " " : "";
            this.runTest(test);
        }
        this.writeSummary();
        this.writeData();
    }

    public boolean getResult() {
        return this.m_result;
    }

    @Override
    public void receivedInvalidResponse(String s) {
        this.printOutLine("invalid", "Invalid response: " + s);
    }

    @Override
    public void receivedResponse(boolean error, String s) {
    }

    @Override
    public void receivedStdErr(String s) {
        this.printOut("stderr", s, -1);
    }

    @Override
    public void sentCommand(String s) {
    }

    private void checkLastSgf(String line) {
        Matcher matcher;
        Pattern pattern;
        String regex;
        block4: {
            regex = "[0-9]*\\s*loadsgf\\s+(\\S+\\.[Ss][Gg][Ff])\\s+([0-9]+)\\s*";
            pattern = Pattern.compile(regex);
            matcher = pattern.matcher(line);
            if (matcher.matches()) {
                this.m_lastSgf = matcher.group(1);
                try {
                    this.m_lastSgfMove = Integer.parseInt(matcher.group(2));
                    return;
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
        if ((matcher = (pattern = Pattern.compile(regex = "[0-9]*\\s*loadsgf\\s+(\\S+\\.[Ss][Gg][Ff])\\s*")).matcher(line)).matches()) {
            this.m_lastSgf = matcher.group(1);
            this.m_lastSgfMove = -1;
        }
    }

    private void finishOutFile() {
        if (this.m_currentStyle != null) {
            this.m_out.print("</span>");
        }
        this.m_out.print("</pre>\n" + HtmlUtil.getFooter("gogui-regress") + "</body>\n" + "</html>\n");
        this.m_out.close();
    }

    private int getId(String line) {
        int index = (line = line.replaceAll("\\t", "\n")).indexOf(32);
        if (index < 0) {
            return -1;
        }
        try {
            return Integer.parseInt(line.substring(0, index));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private TestSummary getTestSummary(long timeMillis, double cpuTime) {
        TestSummary summary = new TestSummary();
        summary.m_file = this.m_testFile;
        summary.m_outName = this.m_outName;
        summary.m_timeMillis = timeMillis;
        summary.m_cpuTime = cpuTime;
        summary.m_otherErrors = this.m_otherErrors;
        for (int i = 0; i < this.m_tests.size(); ++i) {
            Test t = this.m_tests.get(i);
            ++summary.m_numberTests;
            if (t.m_fail && !t.m_expectedFail) {
                ++summary.m_unexpectedFails;
                continue;
            }
            if (t.m_fail && t.m_expectedFail) {
                ++summary.m_expectedFails;
                continue;
            }
            if (!t.m_fail && !t.m_expectedFail) {
                ++summary.m_expectedPasses;
                continue;
            }
            if (t.m_fail || !t.m_expectedFail) continue;
            ++summary.m_unexpectedPasses;
        }
        return summary;
    }

    private synchronized void handleLastResponse() {
        if (this.m_lastCommandId >= 0) {
            boolean fail = false;
            if (this.m_lastError) {
                this.printOutLine("fail", this.m_lastFullResponse);
                if (this.m_lastResponse.equals("")) {
                    System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " unexpected FAIL");
                } else {
                    System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " unexpected FAIL: '" + this.m_lastResponse + "'");
                }
                fail = true;
            } else {
                this.printOutLine("test", this.m_lastFullResponse);
            }
            this.m_tests.add(new Test(this.m_lastCommandId, this.m_lastCommand, fail, false, "", this.m_lastResponse, this.m_lastSgf, this.m_lastSgfMove));
        } else if (this.m_lastError) {
            this.printOutLine("error", this.m_lastFullResponse);
            ++this.m_otherErrors;
        } else {
            this.printOutLine(null, this.m_lastFullResponse);
        }
    }

    private void handleLine(String line) throws ErrorMessage, ProgramIsDeadException {
        if ((line = line.trim()).startsWith("#?")) {
            if (this.m_lastFullResponse == null) {
                throw new ErrorMessage(this.m_testFile + ": Response pattern" + " without preceding test command: " + line);
            }
            this.printOutLine("test", line);
            this.handleTest(line.substring(2).trim());
            this.m_lastFullResponse = null;
            return;
        }
        if (this.m_lastFullResponse != null) {
            this.handleLastResponse();
            this.m_lastFullResponse = null;
        }
        if (line.equals("")) {
            this.printOutLine(null, line);
        } else if (line.startsWith("#")) {
            this.printOutLine("comment", line);
        } else {
            block12: {
                line = line.replaceAll("\\t", " ");
                this.m_lastCommandId = this.getId(line);
                if (this.m_lastCommandId < 0) {
                    this.m_lastCommand = line;
                } else {
                    int index = line.indexOf(32);
                    this.m_lastCommand = line.substring(index + 1);
                }
                this.printOutLine(this.m_lastCommandId >= 0 ? "test" : "command", line, this.m_lastCommandId);
                this.checkLastSgf(line);
                this.m_lastError = false;
                assert (this.m_lastFullResponse == null);
                try {
                    this.m_lastResponse = this.m_gtp.send(line);
                }
                catch (GtpError error) {
                    this.m_lastError = true;
                    this.m_lastResponse = error.getMessage();
                    if (!this.m_gtp.isProgramDead()) break block12;
                    throw new ProgramIsDeadException();
                }
            }
            this.m_lastFullResponse = this.m_gtp.getFullResponse();
        }
    }

    private void handleTest(String patternString) throws ErrorMessage {
        boolean expectedFail = false;
        if (StringUtil.isEmpty(patternString)) {
            this.handleLastResponse();
            return;
        }
        if (patternString.endsWith("*")) {
            expectedFail = true;
            patternString = patternString.substring(0, patternString.length() - 1);
        }
        if (!patternString.startsWith("[")) {
            throw new ErrorMessage(this.m_testFile + ": Pattern has no opening bracket: " + patternString);
        }
        if (!patternString.endsWith("]")) {
            throw new ErrorMessage(this.m_testFile + ": Pattern has no closing bracket: " + patternString);
        }
        String expectedResponse = patternString = patternString.substring(1, patternString.length() - 1).trim();
        boolean notPattern = false;
        if (patternString.startsWith("!")) {
            notPattern = true;
            patternString = patternString.substring(1);
        }
        boolean fail = false;
        String response = "";
        int index = this.m_lastFullResponse.indexOf(32);
        if (index >= 0) {
            response = this.m_lastFullResponse.substring(index).trim();
        }
        if (this.m_lastError) {
            fail = true;
        } else {
            Pattern pattern = Pattern.compile(patternString, 40);
            Matcher matcher = pattern.matcher(response);
            if (!matcher.matches() && !notPattern || matcher.matches() && notPattern) {
                fail = true;
            }
        }
        if (fail && !expectedFail) {
            this.m_result = false;
        }
        String style = null;
        style = fail && !expectedFail ? "fail" : (!fail && expectedFail ? "pass" : "test");
        this.printOutLine(style, this.m_lastFullResponse);
        if (this.m_longOutput) {
            if (fail && !expectedFail) {
                System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " FAILED: Correct '" + expectedResponse + "', got '" + response + "'");
            } else if (fail && expectedFail) {
                System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " failed: Correct '" + expectedResponse + "', got '" + response + "'");
            } else if (!fail && expectedFail) {
                System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " PASSED");
            } else if (!fail && !expectedFail) {
                System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " passed");
            }
        } else if (fail && !expectedFail) {
            System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " unexpected FAIL: Correct '" + expectedResponse + "', got '" + response + "'");
        } else if (!fail && expectedFail) {
            System.out.println(this.m_outPrefix + Integer.toString(this.m_lastCommandId) + " unexpected PASS!");
        }
        this.m_tests.add(new Test(this.m_lastCommandId, this.m_lastCommand, fail, expectedFail, expectedResponse, response, this.m_lastSgf, this.m_lastSgfMove));
    }

    private void initOutNames(ArrayList<String> tests) {
        this.m_outNames = new TreeMap();
        for (int i = 0; i < tests.size(); ++i) {
            String test = tests.get(i);
            File testFile = new File(test);
            String name = FileUtil.removeExtension(new File(testFile.getName()), "tst");
            if (this.m_outNames.containsValue(name)) {
                int j = 2;
                while (true) {
                    String testName;
                    if (!this.m_outNames.containsValue(testName = name + "_" + j)) {
                        name = testName;
                        break;
                    }
                    ++j;
                }
            }
            this.m_outNames.put(test, name);
        }
    }

    private void initOutFile() throws Exception {
        this.m_outFileRelativeName = this.m_outName + ".out.html";
        this.m_outFile = new File(this.m_prefix + this.m_outFileRelativeName);
        File parent = this.m_outFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdir()) {
            throw new ErrorMessage("Could not create directory '" + parent + "'");
        }
        this.m_currentStyle = null;
        this.m_out = new PrintStream(this.m_outFile);
        this.m_out.print("<html>\n<head>\n<title>Output: " + this.m_testFile + "</title>\n" + HtmlUtil.getMeta("gogui-regress") + "<style type=\"text/css\">\n" + "<!--\n" + "body { margin:0; }\n" + "span.comment { color:#999999; }\n" + "span.fail { font-weight:bold; color:" + COLOR_RED + "; }\n" + "span.error { font-weight:bold; color:" + COLOR_ERROR + "; }\n" + "span.stderr { color:#666666; }\n" + "span.invalid { background:" + COLOR_RED + ";}\n" + "span.pass { font-weight:bold; color:" + COLOR_GREEN + "; }\n" + "span.test { font-weight:bold; }\n" + "-->\n" + "</style>\n" + "</head>\n" + "<body bgcolor=\"white\" text=\"black\"" + " link=\"#0000ee\" vlink=\"#551a8b\">\n" + "<table border=\"0\" width=\"100%\" bgcolor=\"" + COLOR_HEADER + "\" border=\"0\">\n" + "<tr><td>\n" + "<h1>Output: " + this.m_testFile + "</h1>\n" + "</td></tr>\n" + "</table>\n" + "<table width=\"100%\" bgcolor=\"" + "#e0e0e0" + "\">\n");
        this.writeInfo(this.m_out, false);
        this.m_out.print("</table>\n<pre style=\"margin:1em\">\n");
    }

    private synchronized void printOut(String style, String line, int id) {
        Pattern pattern;
        Matcher matcher;
        if (line == null || line.length() == 0) {
            return;
        }
        line = line.replaceAll("&", "&amp;");
        line = line.replaceAll(">", "&gt;");
        line = line.replaceAll("<", "&lt;");
        if (style != null && (style.equals("command") || style.equals("test")) && (matcher = (pattern = Pattern.compile("\\S*\\.[Ss][Gg][Ff]")).matcher(line)).find()) {
            String sgf = matcher.group();
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append(line.substring(0, matcher.start()));
            stringBuffer.append("<a href=\"");
            stringBuffer.append(this.m_relativePath);
            stringBuffer.append(sgf);
            stringBuffer.append("\">");
            stringBuffer.append(sgf);
            stringBuffer.append("</a>");
            stringBuffer.append(line.substring(matcher.end()));
            line = stringBuffer.toString();
        }
        if (style == null && this.m_currentStyle != null || style != null && this.m_currentStyle == null || style != null && this.m_currentStyle != null && !style.equals(this.m_currentStyle)) {
            if (this.m_currentStyle != null) {
                this.m_out.print("</span>");
            }
            if (style != null) {
                this.m_out.print("<span class=\"" + style + "\">");
            }
            this.m_currentStyle = style;
        }
        if (id >= 0) {
            this.m_out.print("<a name=\"" + id + "\">");
        }
        this.m_out.print(line);
        if (id >= 0) {
            this.m_out.print("</a>");
        }
    }

    private synchronized void printOutLine(String style, String line, int id) {
        if (line == null) {
            return;
        }
        if (!line.endsWith("\n")) {
            line = line + "\n";
        }
        this.printOut(style, line, id);
    }

    private synchronized void printOutSeparator() {
        if (this.m_currentStyle != null) {
            this.m_out.print("</span>");
        }
        this.m_out.println("</pre>\n<hr style=\"margin:1em\" size=\"1\">\n<pre style=\"margin:1em\">");
    }

    private synchronized void printOutLine(String style, String line) {
        this.printOutLine(style, line, -1);
    }

    private String send(String command) throws GtpError {
        this.printOutLine(null, command);
        try {
            String string = this.m_gtp.send(command);
            return string;
        }
        finally {
            this.printOutLine(null, this.m_gtp.getFullResponse());
        }
    }

    private double getCpuTime() {
        try {
            return Double.parseDouble(this.send("cputime"));
        }
        catch (GtpError e) {
            return 0.0;
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private String getTimeString(double seconds) {
        NumberFormat format1 = StringUtil.getNumberFormat(1);
        StringBuilder buffer = new StringBuilder(16);
        buffer.append(format1.format(seconds));
        buffer.append("&nbsp;(");
        buffer.append(StringUtil.formatTime((long)seconds));
        buffer.append(')');
        return buffer.toString();
    }

    private TestSummary getTotalSummary() {
        TestSummary total = new TestSummary();
        for (int i = 0; i < this.m_testSummaries.size(); ++i) {
            TestSummary summary = this.m_testSummaries.get(i);
            total.m_numberTests += summary.m_numberTests;
            total.m_otherErrors += summary.m_otherErrors;
            total.m_unexpectedFails += summary.m_unexpectedFails;
            total.m_expectedFails += summary.m_expectedFails;
            total.m_expectedPasses += summary.m_expectedPasses;
            total.m_unexpectedPasses += summary.m_unexpectedPasses;
            total.m_timeMillis += summary.m_timeMillis;
            total.m_cpuTime += summary.m_cpuTime;
        }
        return total;
    }

    private void queryNameAndVersion() throws GtpError {
        block4: {
            try {
                this.m_name = this.send("name");
            }
            catch (GtpError e) {
                this.m_name = "";
                if (!this.m_gtp.isProgramDead()) break block4;
                throw e;
            }
        }
        try {
            this.m_version = this.send("version");
        }
        catch (GtpError e) {
            this.m_version = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(String test) throws Exception {
        this.m_tests.clear();
        this.m_otherErrors = 0;
        this.m_testFile = new File(test);
        this.m_outName = this.m_outNames.get(test);
        this.initOutFile();
        File testFileDir = this.m_testFile.getAbsoluteFile().getParentFile();
        this.m_relativePath = FileUtil.getRelativeURI(this.m_outFile, testFileDir);
        if (!this.m_relativePath.equals("") && !this.m_relativePath.endsWith("/")) {
            this.m_relativePath = this.m_relativePath + "/";
        }
        FileReader fileReader = new FileReader(this.m_testFile);
        BufferedReader reader = new BufferedReader(fileReader);
        try {
            String line;
            this.m_gtp = new GtpClient(this.m_program, testFileDir, this.m_verbose, (GtpClient.IOCallback)this);
            if (this.m_gtpFile != null) {
                this.sendGtpFile();
            }
            this.m_lastSgf = null;
            this.queryNameAndVersion();
            double cpuTime = this.getCpuTime();
            long timeMillis = System.currentTimeMillis();
            this.printOutSeparator();
            while ((line = reader.readLine()) != null) {
                this.handleLine(line);
            }
            timeMillis = System.currentTimeMillis() - timeMillis;
            if (this.m_lastFullResponse != null) {
                this.handleLastResponse();
                this.m_lastFullResponse = null;
            }
            this.printOutSeparator();
            cpuTime = this.getCpuTime() - cpuTime;
            if (this.m_lastFullResponse != null) {
                this.handleLastResponse();
                this.m_lastFullResponse = null;
            }
            if (!this.m_gtp.isProgramDead()) {
                this.send("quit");
                this.m_gtp.close();
            }
            this.m_gtp.waitForExit();
            this.finishOutFile();
            TestSummary testSummary = this.getTestSummary(timeMillis, cpuTime);
            this.m_testSummaries.add(testSummary);
            this.writeTestSummary(testSummary);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendGtpFile() throws ErrorMessage {
        FileReader reader;
        try {
            reader = new FileReader(this.m_gtpFile);
        }
        catch (FileNotFoundException e) {
            throw new ErrorMessage("GTP file not found: " + this.m_gtpFile);
        }
        BufferedReader in = new BufferedReader(reader);
        try {
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if (!GtpUtil.isCommand(line)) continue;
                    this.send(line);
                }
            }
            catch (IOException e) {
                throw new ErrorMessage("Error reading GTP file: " + e.getMessage());
            }
            catch (GtpError e) {
                throw new ErrorMessage("GTP command '" + e.getCommand() + "' from file " + this.m_gtpFile + " failed: " + e.getMessage());
            }
            this.printOutSeparator();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String truncate(String string) {
        int maxLength = 25;
        if (string.length() < maxLength) {
            return string.trim();
        }
        return string.substring(0, maxLength).trim() + "...";
    }

    private void writeInfo(PrintStream out, boolean withName) {
        String host = Platform.getHostInfo();
        if (withName) {
            out.print("<tr><th align=\"left\">Name:</th><td>" + this.m_name + "</td></tr>\n" + "<tr><th align=\"left\">Version:</th><td>" + this.m_version + "</td></tr>\n");
        }
        out.print("<tr><th align=\"left\">Date:</th><td>" + StringUtil.getDate() + "</td></tr>\n" + "<tr><th align=\"left\">Host:</th><td>" + host + "</td></tr>\n" + "<tr><th align=\"left\" valign=\"top\">Command:</th>\n" + "<td valign=\"top\"><tt>" + this.m_program + "</tt></td></tr>\n");
        if (this.m_gtpFile != null) {
            out.print("<tr><th align=\"left\">GtpFile:</th><td>" + this.m_gtpFile + "</td></tr>\n");
        }
    }

    private void writeData() throws FileNotFoundException {
        File file = new File(this.m_prefix + "summary.dat");
        PrintStream out = new PrintStream(file);
        NumberFormat format1 = StringUtil.getNumberFormat(1);
        TestSummary s = this.getTotalSummary();
        double time = (double)s.m_timeMillis / 1000.0;
        out.print("#Tests\tFAIL\tfail\tPASS\tpass\tError\tTime\tCpuTime\n" + s.m_numberTests + "\t" + s.m_unexpectedFails + "\t" + s.m_expectedFails + "\t" + s.m_unexpectedPasses + "\t" + s.m_expectedPasses + "\t" + s.m_otherErrors + "\t" + format1.format(time) + "\t" + format1.format(s.m_cpuTime) + "\t" + "\n");
        out.close();
    }

    private void writeSummary() throws FileNotFoundException {
        File file = new File(this.m_prefix + "index.html");
        PrintStream out = new PrintStream(file);
        out.print("<html>\n<head>\n<title>Regression Test Summary</title>\n" + HtmlUtil.getMeta("gogui-regress") + "<style type=\"text/css\">\n" + "<!--\n" + "body { margin:0; }\n" + "-->\n" + "</style>\n" + "</head>\n" + "<body bgcolor=\"white\" text=\"black\" link=\"blue\"" + " vlink=\"purple\" alink=\"red\">\n" + "<table border=\"0\" width=\"100%\" bgcolor=\"" + COLOR_HEADER + "\">\n" + "<tr><td>\n" + "<h1>Regression Test Summary</h1>\n" + "</td></tr>\n" + "</table>\n" + "<table width=\"100%\" bgcolor=\"" + "#e0e0e0" + "\">\n");
        this.writeInfo(out, true);
        out.print("</table>\n<table width=\"100%\" border=\"0\" cellpadding=\"0\"cellspacing=\"1\">\n<colgroup>\n<col width=\"20%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n<col width=\"10%\">\n</colgroup>\n<thead align=\"center\">\n<tr bgcolor = \"#91aee8\">\n<th>File</th>\n<th>Tests</th>\n<th>FAIL</th>\n<th>fail</th>\n<th>PASS</th>\n<th>pass</th>\n<th>Error</th>\n<th>Time</th>\n<th>CpuTime</th>\n</tr>\n</thead>\n");
        for (int i = 0; i < this.m_testSummaries.size(); ++i) {
            TestSummary summary = this.m_testSummaries.get(i);
            this.writeSummaryRow(out, summary, true, false);
        }
        this.writeSummaryRow(out, this.getTotalSummary(), true, true);
        out.print("</table>\n" + HtmlUtil.getFooter("gogui-regress") + "</body>\n" + "</html>\n");
        out.close();
    }

    private void writeSummaryRow(PrintStream out, TestSummary summary, boolean withFileName, boolean foot) {
        File file = summary.m_file;
        if (foot) {
            out.print("<tfoot align=\"center\">\n");
            out.print("<tr align=\"center\" bgcolor=\"#91aee8\">\n");
        } else {
            out.print("<tr align=\"center\" bgcolor=\"#e0e0e0\">\n");
        }
        if (withFileName) {
            if (foot) {
                out.print("<td><b>Total</b></td>");
            } else {
                out.print("<td><a href=\"" + summary.m_outName + ".html" + "\">" + file + "</a></td>");
            }
        }
        double time = (double)summary.m_timeMillis / 1000.0;
        String colorAttrUnexpectedFails = "";
        if (summary.m_unexpectedFails > 0) {
            colorAttrUnexpectedFails = " bgcolor=\"#ff5454\"";
        }
        String colorAttrUnexpectedPasses = "";
        if (summary.m_unexpectedPasses > 0) {
            colorAttrUnexpectedPasses = " bgcolor=\"#5eaf5e\"";
        }
        String colorAttrOtherErrors = "";
        if (summary.m_otherErrors > 0) {
            colorAttrOtherErrors = " bgcolor=\"#ffa954\"";
        }
        out.print("<td>" + summary.m_numberTests + "</td>\n" + "<td" + colorAttrUnexpectedFails + ">" + summary.m_unexpectedFails + "</td>\n" + "<td>" + summary.m_expectedFails + "</td>\n" + "<td" + colorAttrUnexpectedPasses + ">\n" + summary.m_unexpectedPasses + "</td>\n" + "<td>" + summary.m_expectedPasses + "</td>\n" + "<td" + colorAttrOtherErrors + ">\n" + summary.m_otherErrors + "</td>\n" + "<td align=\"right\">" + this.getTimeString(time) + "</td>\n" + "<td align=\"right\">" + this.getTimeString(summary.m_cpuTime) + "</td>\n" + "</tr>\n");
        if (foot) {
            out.print("</tfoot>\n");
        }
    }

    private void writeTestSummary(TestSummary summary) throws FileNotFoundException {
        if (this.m_longOutput) {
            System.out.println("Summary: " + summary.getNumberPasses() + "/" + summary.m_numberTests + " passes. " + summary.m_unexpectedPasses + " unexpected passes, " + summary.m_unexpectedFails + " unexpected failures");
        }
        File file = new File(this.m_prefix + this.m_outName + ".html");
        PrintStream out = new PrintStream(file);
        out.print("<html>\n<head>\n<title>Summary: " + this.m_testFile + "</title>\n" + HtmlUtil.getMeta("gogui-regress") + "<style type=\"text/css\">\n" + "<!--\n" + "body { margin:0; }\n" + "-->\n" + "</style>\n" + "</head>\n" + "<body bgcolor=\"white\" text=\"black\" link=\"blue\"" + " vlink=\"purple\" alink=\"red\">\n" + "<table border=\"0\" width=\"100%\" bgcolor=\"" + COLOR_HEADER + "\">\n" + "<tr><td>\n" + "<h1>Summary: " + this.m_testFile + "</h1>\n" + "</td></tr>\n" + "</table>\n" + "<table width=\"100%\" bgcolor=\"" + "#e0e0e0" + "\">\n");
        this.writeInfo(out, true);
        out.print("<tr><th align=\"left\">Output:</th><td><a href=\"" + this.m_outFileRelativeName + "\">" + this.m_outFileRelativeName + "</a></td></tr>\n" + "</table>\n" + "<table width=\"100%\" border=\"0\" cellpadding=\"0\"" + " cellspacing=\"1\">\n" + "<colgroup>\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "<col width=\"12%\">\n" + "</colgroup>\n" + "<thead align=\"center\">\n" + "<tr bgcolor=\"" + COLOR_HEADER + "\">\n" + "<th>Tests</th>\n" + "<th>FAIL</th>\n" + "<th>fail</th>\n" + "<th>PASS</th>\n" + "<th>pass</th>\n" + "<th>Error</th>\n" + "<th>Time</th>\n" + "<th>CpuTime</th>\n" + "</tr>\n" + "</thead>\n");
        this.writeSummaryRow(out, summary, false, false);
        out.print("</table>\n<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"1\">\n<thead>\n<tr bgcolor=\"#91aee8\">\n<th>ID</th>\n<th>Status</th>\n<th>Command</th>\n<th>Output</th>\n<th>Required</th>\n<th>Last SGF</th>\n</tr>\n</thead>\n");
        for (int i = 0; i < this.m_tests.size(); ++i) {
            String rowBackground;
            Test t = this.m_tests.get(i);
            String statusColor = rowBackground = "#e0e0e0";
            String status = null;
            if (t.m_fail && t.m_expectedFail) {
                status = "fail";
            } else if (t.m_fail && !t.m_expectedFail) {
                statusColor = COLOR_RED;
                status = "FAIL";
            } else if (!t.m_fail && t.m_expectedFail) {
                statusColor = COLOR_GREEN;
                status = "PASS";
            } else if (!t.m_fail && !t.m_expectedFail) {
                status = "pass";
            } else assert (false);
            String lastSgf = "";
            if (t.m_lastSgf != null) {
                lastSgf = "<a href=\"" + this.m_relativePath + t.m_lastSgf + "\">" + t.m_lastSgf + "</a>";
                if (t.m_lastSgfMove != -1) {
                    lastSgf = lastSgf + "&nbsp;" + t.m_lastSgfMove;
                }
            }
            String command = t.m_command.replaceAll(" ", "&nbsp;");
            out.print("<tr bgcolor=\"" + rowBackground + "\">\n" + "<td align=\"right\"><a href=\"" + this.m_outFileRelativeName + "#" + t.m_id + "\">" + t.m_id + "</a></td>\n" + "<td align=\"center\" bgcolor=\"" + statusColor + "\">" + status + "</td>\n" + "<td>" + command + "</td>\n" + "<td align=\"center\">" + this.truncate(t.m_response) + "</td>\n" + "<td align=\"center\">" + this.truncate(t.m_required) + "</td>\n" + "<td>" + lastSgf + "</td>\n" + "</tr>\n");
        }
        out.print("</table>\n" + HtmlUtil.getFooter("gogui-regress") + "</body>\n" + "</html>\n");
        out.close();
    }

    private static class TestSummary {
        public File m_file;
        public String m_outName;
        public int m_numberTests;
        public int m_otherErrors;
        public int m_unexpectedFails;
        public int m_expectedFails;
        public int m_expectedPasses;
        public int m_unexpectedPasses;
        public long m_timeMillis;
        public double m_cpuTime;

        private TestSummary() {
        }

        public int getNumberPasses() {
            return this.m_expectedPasses + this.m_unexpectedPasses;
        }
    }

    private static class Test {
        public int m_id;
        public int m_lastSgfMove;
        public boolean m_expectedFail;
        public boolean m_fail;
        public String m_command;
        public String m_required;
        public String m_response;
        public String m_lastSgf;

        public Test(int id, String command, boolean fail, boolean expectedFail, String required, String response, String lastSgf, int lastSgfMove) {
            this.m_id = id;
            this.m_fail = fail;
            this.m_expectedFail = expectedFail;
            this.m_command = command;
            this.m_required = required;
            this.m_response = response;
            this.m_lastSgf = lastSgf;
            this.m_lastSgfMove = lastSgfMove;
        }
    }

    private static class ProgramIsDeadException
    extends Exception {
        private ProgramIsDeadException() {
        }

        public String getMessage() {
            return "Program died";
        }
    }
}

