/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.sf.gogui.gtp.AnalyzeUtil;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.ParameterType;
import net.sf.gogui.gui.GuiGtpClient;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.util.ObjectUtil;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterDialog {
    private static final int TEXTFIELD_LEN = 13;
    private static final int MAX_PARAM_PER_COLUMN = 15;

    public static void editParameters(final String paramCommand, Frame owner, String title, String response, final GuiGtpClient gtp, final MessageDialogs messageDialogs) {
        final ArrayList<Parameter> parameters = ParameterDialog.parseResponse(response);
        Component mainComponent = ParameterDialog.createMainComponent(parameters);
        final Object[] options = new Object[]{I18n.i18n("LB_OK"), I18n.i18n("LB_CANCEL")};
        final JOptionPane optionPane = new JOptionPane(mainComponent, -1, 2, null, options, options[0]);
        final JDialog dialog = new JDialog(owner, title, true);
        dialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String prop = event.getPropertyName();
                if (dialog.isVisible() && event.getSource() == optionPane && prop.equals("value")) {
                    Object value = optionPane.getValue();
                    if (ObjectUtil.equals(value, JOptionPane.UNINITIALIZED_VALUE)) {
                        return;
                    }
                    if (ObjectUtil.equals(value, options[0])) {
                        for (int i = 0; i < parameters.size(); ++i) {
                            Parameter parameter = (Parameter)parameters.get(i);
                            if (!parameter.isChanged()) continue;
                            try {
                                String command = ParameterDialog.getNewValueCommand(paramCommand, parameter);
                                gtp.send(command);
                                continue;
                            }
                            catch (GtpError e) {
                                ParameterDialog.showError(dialog, messageDialogs, parameter, e);
                                optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                                return;
                            }
                        }
                    }
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setLocationByPlatform(true);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                optionPane.selectInitialValue();
            }
        });
        dialog.setVisible(true);
    }

    private static ArrayList<Parameter> parseResponse(String response) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        BufferedReader reader = new BufferedReader(new StringReader(response));
        while (true) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (line == null) break;
            AnalyzeUtil.Result result = AnalyzeUtil.parseParameterLine(line);
            if (result == null) continue;
            if (result.m_type == ParameterType.BOOL) {
                parameters.add(new BoolParameter(result.m_key, result.m_value));
                continue;
            }
            if (result.m_type == ParameterType.LIST) {
                parameters.add(new ListParameter(result.m_typeInfo, result.m_key, result.m_value));
                continue;
            }
            parameters.add(new StringParameter(result.m_key, result.m_value));
        }
        return parameters;
    }

    private static Component createMainComponent(ArrayList<Parameter> parameters) {
        int numberParameters = parameters.size();
        Box outerBox = Box.createHorizontalBox();
        int numberColumns = 0;
        JPanel panel = null;
        GridBagLayout gridbag = null;
        int gridy = 0;
        int paramPerColumn = (numberParameters + 1) / (numberParameters / 15 + 1);
        for (int i = 0; i < numberParameters; ++i) {
            if (i % paramPerColumn == 0) {
                if (panel != null) {
                    if (numberColumns > 0) {
                        outerBox.add(GuiUtil.createFiller());
                        outerBox.add(new JSeparator(1));
                        outerBox.add(GuiUtil.createFiller());
                    }
                    outerBox.add(panel);
                    ++numberColumns;
                }
                gridbag = new GridBagLayout();
                panel = new JPanel(gridbag);
                gridy = 0;
            }
            parameters.get(i).createComponents(gridy, panel, gridbag);
            ++gridy;
        }
        if (panel != null) {
            if (numberColumns > 0) {
                outerBox.add(GuiUtil.createFiller());
                outerBox.add(new JSeparator(1));
                outerBox.add(GuiUtil.createFiller());
            }
            outerBox.add(panel);
        }
        return outerBox;
    }

    private static String getNewValueCommand(String paramCommand, Parameter parameter) {
        String key = parameter.getKey();
        String value = parameter.getNewValue();
        return AnalyzeUtil.getParameterCommand(paramCommand, key, value);
    }

    private static void showError(JDialog owner, MessageDialogs messageDialogs, Parameter parameter, GtpError e) {
        String mainMessage = MessageFormat.format(I18n.i18n("MSG_PARAMDIALOG_COULD_NOT_CHANGE"), parameter.getLabel());
        String optionalMessage = StringUtil.capitalize(e.getMessage());
        messageDialogs.showError((Component)owner, mainMessage, optionalMessage);
    }

    private static class StringParameter
    extends Parameter {
        private JTextField m_textField;

        public StringParameter(String key, String value) {
            super(key, value);
        }

        public String getNewValue() {
            return this.m_textField.getText().trim();
        }

        public boolean isChanged() {
            return !this.getNewValue().equals(this.getValue());
        }

        public void createComponents(int gridy, JPanel panel, GridBagLayout gridbag) {
            JLabel label = new JLabel(this.getLabel() + ":");
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = gridy;
            constraints.weightx = 1.0;
            constraints.ipadx = 2;
            constraints.insets = new Insets(2, 0, 0, 0);
            constraints.anchor = 13;
            gridbag.setConstraints(label, constraints);
            panel.add(label);
            this.m_textField = new JTextField(13);
            this.m_textField.setText(this.getValue());
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = gridy;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(2, 0, 0, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.m_textField, constraints);
            panel.add(this.m_textField);
        }
    }

    private static class ListParameter
    extends Parameter {
        private final int m_initialIndex;
        private final String[] m_items;
        private final String[] m_labels;
        private JComboBox m_comboBox;

        public ListParameter(String type, String key, String value) {
            super(key, value);
            String[] args = type.split("/");
            assert (args[0].equals("list"));
            this.m_items = new String[args.length - 1];
            this.m_labels = new String[args.length - 1];
            int initialIndex = 0;
            int maxLength = 0;
            for (int i = 1; i < args.length; ++i) {
                String item = args[i];
                if (item.equals(value)) {
                    initialIndex = i - 1;
                }
                maxLength = Math.max(item.length(), maxLength);
                this.m_items[i - 1] = item;
                this.m_labels[i - 1] = StringUtil.capitalize(item.replace('_', ' '));
            }
            this.m_initialIndex = initialIndex;
        }

        public String getNewValue() {
            return this.m_items[this.m_comboBox.getSelectedIndex()];
        }

        public boolean isChanged() {
            return this.m_comboBox.getSelectedIndex() != this.m_initialIndex;
        }

        public void createComponents(int gridy, JPanel panel, GridBagLayout gridbag) {
            JLabel label = new JLabel(this.getLabel() + ":");
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = gridy;
            constraints.weightx = 1.0;
            constraints.ipadx = 2;
            constraints.insets = new Insets(2, 0, 0, 0);
            constraints.anchor = 13;
            gridbag.setConstraints(label, constraints);
            panel.add(label);
            this.m_comboBox = new JComboBox<String>(this.m_labels);
            this.m_comboBox.setSelectedIndex(this.m_initialIndex);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = gridy;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(2, 0, 0, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.m_comboBox, constraints);
            panel.add(this.m_comboBox);
        }
    }

    private static class BoolParameter
    extends Parameter {
        private boolean m_initialValue;
        private JCheckBox m_checkBox;

        public BoolParameter(String key, String value) {
            super(key, value);
            try {
                this.m_initialValue = Integer.parseInt(value) != 0;
            }
            catch (NumberFormatException e) {
                this.m_initialValue = false;
            }
        }

        public String getNewValue() {
            if (this.m_checkBox.isSelected()) {
                return "1";
            }
            return "0";
        }

        public boolean isChanged() {
            return this.m_checkBox.isSelected() != this.m_initialValue;
        }

        public void createComponents(int gridy, JPanel panel, GridBagLayout gridbag) {
            this.m_checkBox = new JCheckBox(this.getLabel(), this.m_initialValue);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = gridy;
            constraints.gridwidth = 0;
            constraints.weightx = 1.0;
            constraints.anchor = 17;
            gridbag.setConstraints(this.m_checkBox, constraints);
            panel.add(this.m_checkBox);
        }
    }

    private static abstract class Parameter {
        private final String m_key;
        private final String m_label;
        private final String m_value;

        public Parameter(String key, String value) {
            this.m_key = key;
            this.m_value = value;
            this.m_label = StringUtil.capitalize(key.replace('_', ' '));
        }

        public String getKey() {
            return this.m_key;
        }

        public String getLabel() {
            return this.m_label;
        }

        public String getValue() {
            return this.m_value;
        }

        public abstract String getNewValue();

        public abstract boolean isChanged();

        public abstract void createComponents(int var1, JPanel var2, GridBagLayout var3);
    }
}

