/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.util.Platform;

public class StatusBar
extends JPanel {
    private static final Icon ICON_BLACK = GuiUtil.getIcon("gogui-black-16x16", I18n.i18n("LB_BLACK"));
    private static final Icon ICON_WHITE = GuiUtil.getIcon("gogui-white-16x16", I18n.i18n("LB_WHITE"));
    private final Box m_iconBox;
    private final JLabel m_toPlayLabel;
    private final JLabel m_labelSetup;
    private final JLabel m_moveText;
    private final JLabel m_text;
    private final JSeparator m_moveTextSeparator;

    public StatusBar() {
        super(new BorderLayout());
        JPanel outerPanel = new JPanel(new BorderLayout());
        this.add((Component)outerPanel, "Center");
        if (Platform.isMac()) {
            Dimension dimension = new Dimension(20, 1);
            Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
            outerPanel.add((Component)filler, "East");
        }
        JPanel panel = new JPanel(new BorderLayout());
        outerPanel.add((Component)panel, "Center");
        this.m_iconBox = Box.createHorizontalBox();
        panel.add((Component)this.m_iconBox, "West");
        this.m_toPlayLabel = new JLabel();
        this.m_toPlayLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setToPlay(GoColor.BLACK);
        this.m_iconBox.add(this.m_toPlayLabel);
        this.m_labelSetup = new JLabel(GuiUtil.getIcon("gogui-setup-16x16", I18n.i18n("LB_STATUS_SETUP")));
        this.m_labelSetup.setVisible(false);
        this.m_labelSetup.setToolTipText(I18n.i18n("TT_STATUS_SETUP"));
        this.m_iconBox.add(this.m_labelSetup);
        this.m_iconBox.add(GuiUtil.createSmallFiller());
        this.m_text = new JLabel(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                String text = super.getText();
                if (text == null || g.getFontMetrics().stringWidth(text) < this.getWidth()) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(text);
                }
            }
        };
        StatusBar.setPreferredLabelSize(this.m_text, 10);
        panel.add((Component)this.m_text, "Center");
        Box moveTextBox = Box.createHorizontalBox();
        panel.add((Component)moveTextBox, "East");
        this.m_moveText = new JLabel();
        StatusBar.setPreferredLabelSize(this.m_moveText, 12);
        this.m_moveText.setHorizontalAlignment(2);
        this.m_moveTextSeparator = new JSeparator(1);
        moveTextBox.add(this.m_moveTextSeparator);
        moveTextBox.add(GuiUtil.createSmallFiller());
        moveTextBox.add(this.m_moveText);
    }

    public void clear() {
        this.setText("");
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void immediatelyPaintMoveText(String text) {
        assert (SwingUtilities.isEventDispatchThread());
        this.setMoveText(text, null);
        GuiUtil.paintImmediately(this.m_moveText);
        GuiUtil.paintImmediately(this.m_moveTextSeparator);
    }

    public void immediatelyPaintText(String text) {
        assert (SwingUtilities.isEventDispatchThread());
        this.setText(text);
        GuiUtil.paintImmediately(this.m_text);
    }

    public void setMoveText(String text, String toolTip) {
        if (text.length() > 18) {
            text = text.substring(0, 18) + "...";
        }
        this.m_moveText.setText(text);
        this.m_moveText.setToolTipText(toolTip);
    }

    public void setSetupMode(boolean enabled) {
        this.m_labelSetup.setVisible(enabled);
    }

    public void setText(String text) {
        this.m_text.setText(text);
    }

    public final void setToPlay(GoColor color) {
        if (color == GoColor.BLACK) {
            this.m_toPlayLabel.setIcon(ICON_BLACK);
            this.m_toPlayLabel.setToolTipText(I18n.i18n("LB_STATUS_TO_PLAY_BLACK"));
        } else {
            assert (color == GoColor.WHITE);
            this.m_toPlayLabel.setIcon(ICON_WHITE);
            this.m_toPlayLabel.setToolTipText(I18n.i18n("LB_STATUS_TO_PLAY_WHITE"));
        }
    }

    public void showMoveText(boolean show) {
        this.m_moveText.setVisible(show);
        this.m_moveTextSeparator.setVisible(show);
    }

    private static void setPreferredLabelSize(JLabel label, int columns) {
        Font font = label.getFont();
        Insets insets = label.getInsets();
        int height = font.getSize() + insets.top + insets.bottom;
        int width = columns * font.getSize() + insets.left + insets.right;
        label.setPreferredSize(new Dimension(width, height));
    }
}

