/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.statistics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.Move;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.util.ErrorMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCheck {
    private final boolean m_allowSetup;
    private final int m_size;
    private File m_file;

    public FileCheck(ArrayList<String> sgfFiles, int size, boolean allowSetup) throws ErrorMessage {
        this.m_size = size;
        this.m_allowSetup = allowSetup;
        for (int i = 0; i < sgfFiles.size(); ++i) {
            this.m_file = new File(sgfFiles.get(i));
            this.checkFile();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkFile() throws ErrorMessage {
        void var6_8;
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.m_file);
        }
        catch (FileNotFoundException e) {
            this.throwError("file not found");
        }
        SgfReader reader = new SgfReader(in, this.m_file, null, 0L);
        GameTree tree = reader.getTree();
        if (tree.getBoardSize() != this.m_size) {
            this.throwError("size is not " + this.m_size);
        }
        Node root = tree.getRoot();
        GoColor toMove = GoColor.BLACK;
        Node node = root;
        while (var6_8 != null) {
            Move move;
            if (var6_8.hasSetup()) {
                if (!this.m_allowSetup) throw new ErrorMessage("contains setup stones");
                if (var6_8 != root) throw new ErrorMessage("setup stones in non-root position");
                toMove = GoColor.EMPTY;
            }
            if ((move = var6_8.getMove()) != null) {
                if (toMove == GoColor.EMPTY) {
                    toMove = move.getColor();
                }
                if (move.getColor() != toMove) {
                    this.throwError("non-alternating moves");
                }
                toMove = toMove.otherColor();
            }
            ConstNode constNode = var6_8.getChildConst();
        }
    }

    private void throwError(String reason) throws ErrorMessage {
        throw new ErrorMessage(this.m_file + ": " + reason);
    }
}

