/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.gogui.util.StringUtil;

public class StreamCopy
implements Runnable {
    private final boolean m_verbose;
    private final boolean m_close;
    private final InputStream m_src;
    private final OutputStream m_dest;

    public StreamCopy(boolean verbose, InputStream src, OutputStream dest, boolean close) {
        this.m_verbose = verbose;
        this.m_src = src;
        this.m_dest = dest;
        this.m_close = close;
    }

    public void run() {
        try {
            int n;
            byte[] buffer = new byte[1024];
            while ((n = this.m_src.read(buffer)) >= 0) {
                if (this.m_verbose) {
                    System.err.write(buffer, 0, n);
                }
                this.m_dest.write(buffer, 0, n);
                this.m_dest.flush();
            }
        }
        catch (Throwable e) {
            StringUtil.printException(e);
        }
        finally {
            if (this.m_close) {
                try {
                    this.m_dest.close();
                }
                catch (IOException e) {
                    StringUtil.printException(e);
                }
            }
        }
    }
}

