/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PointList
extends ArrayList<GoPoint>
implements ConstPointList {
    private static final ConstPointList EMPTY_LIST = new PointList();

    public PointList() {
        this(0);
    }

    public PointList(int initialCapacity) {
        super(initialCapacity);
    }

    public PointList(GoPoint p) {
        this(1);
        this.add(p);
    }

    public PointList(ConstPointList list) {
        super((PointList)list);
    }

    public void addAllFromConst(ConstPointList list) {
        this.addAll((PointList)list);
    }

    public static ConstPointList getEmptyList() {
        return EMPTY_LIST;
    }

    @Override
    public Iterator<GoPoint> iterator() {
        return new ConstIterator();
    }

    public GoPoint pop() {
        int index = this.size() - 1;
        if (index < 0) {
            assert (false);
            return null;
        }
        GoPoint p = (GoPoint)this.get(index);
        this.remove(index);
        return p;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(this.get(i));
        }
        return buffer.toString();
    }

    public static String toString(ConstPointList list) {
        if (list == null) {
            return "";
        }
        return list.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConstIterator
    implements Iterator<GoPoint> {
        private int m_index;

        @Override
        public boolean hasNext() {
            return this.m_index < PointList.this.size();
        }

        @Override
        public GoPoint next() {
            return (GoPoint)PointList.this.get(this.m_index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

